# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Sort IPv4 Addresses Correctly
http://community.idera.com/powershell/powertips/b/tips/posts/sort-ipv4-addresses-correctly

# Recorrer rango direcciones IP
* https://www.jesusninoc.com/2017/07/14/recorrer-un-rango-de-direcciones-ip/
* https://www.jesusninoc.com/2017/07/06/recorrer-direcciones-ip/
* https://github.com/jesusninoc/PowerShell/blob/master/Red/EjemplosRed.ps1

# Puertos abiertos
## Si está abierto parece que no hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",25,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Si no está abierto hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",215,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Scanning Ports
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/scanning-ports
```PowerShell
function Get-PortInfo
{
    param
    (
        [Parameter(Mandatory)]
        [Int]
        $Port,
    
        [Parameter(Mandatory)]
        [Int]
        $TimeoutMilliseconds,
        
        [String]
        $ComputerName = $env:COMPUTERNAME
    )
  
    # try and establish a connection to port async
    $tcpobject = New-Object System.Net.Sockets.TcpClient 
    $connect = $tcpobject.BeginConnect($computername,$port,$null,$null)
    
    # wait for the connection no longer than $timeoutMilliseconds 
    $wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false) 
    
    # return rich information
    $result = @{
        ComputerName = $ComputerName
    }
    
    if(!$wait) { 
        # timeout
        $tcpobject.Close() 
        $result.Online = $false
        $result.Error = 'Timeout'
    } else { 
        try { 
            # try and complete the connection
            $null = $tcpobject.EndConnect($connect)
            $result.Online = $true
        }
        catch { 
            $result.Online = $false
        } 
        $tcpobject.Close() 
    } 
    $tcpobject.Dispose()
    
    [PSCustomObject]$result
} 
```
--------------

# Ejercicios realizados
- https://www.jesusninoc.com/02/04/ejercicios-de-powershell-sacar-los-nombre-de-los-procesos-de-cada-conexion-de-red-tcp/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-sacar-el-nombre-del-proceso-que-abre-cada-conexion-de-red-tcp-junto-con-la-direccion-ip-remota/
- https://www.jesusninoc.com/02/05/sacar-el-nombre-del-proceso-que-abre-cada-conexion-de-red-udp-junto-con-la-direccion-ip-local/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-ver-los-puertos-locales-que-estan-abiertos-en-nuestro-equipo-tcp-y-udp/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-comprobar-los-puertos-tcp-abiertos-de-un-rango-a-otro-mediante-un-try-y-un-catch-e-indicar-si-esta-abierto-o-no-el-puerto-si-hace-lo-que-queremos/
- https://www.jesusninoc.com/02/05/ejercicios-de-powershell-listar-las-direcciones-ip-remotas-que-utilizan-el-protocolo-tcp-e-indicar-la-resolucion-dns/

# Ejercicios propuestos
- Analizar la red del Centro, ¿qué detectas?, ¿DNS?
- Se puede comunicar dentro del la red por UDP, enviar el movimiento del ratón entre dos equipos.
