# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Teoría red
* https://www.jesusninoc.com/04/26/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

# Conceptos de red
## TTL
Para evitar que una petición ping viaje de forma ilimitada por internet, en cada una de ellas se establece un Time To Live (TTL), que representa el número de saltos que ha dado el paquete de host en host por internet hasta alcanzar su destino. En cada salto, el TTL se decrementa en una unidad, y si en algún momento llega a 0 entonces el paquete se descarta y el host devuelve un error al origen.
## ¿Por que me cambia el valor TTL dependiendo de a quien haga ping?
https://foro.elhacker.net/redes/duda_iquestpor_que_me_cambia_el_valor_ttl_dependiendo_de_a_quien_haga_ping-t69071.0.html
## Cómo usar TRACERT para solucionar problemas de TCP/IP en Windows
https://support.microsoft.com/es-es/help/314868/how-to-use-tracert-to-troubleshoot-tcp-ip-problems-in-windows
## Ping continuado a servidores de tarificación por byte consumido
https://www.jesusninoc.com/2004/06/02/ping-continuado-a-servidores-de-tarificacion-por-byte-consumido/
## Modificar TTL para un solo registro en la zona DNS
http://nextadmin.blogspot.com.es/2014/10/modificar-ttl-para-un-solo-registro-en.html
## Cmdlets for TCP/IP Model Layers (Windows)
https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-11.md
## ifconfig vs ip (Linux) 
https://p5r.uk/blog/2010/ifconfig-ip-comparison.html
## Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/
## Almacenar la información enviada entre un cliente y un servidor en una base de datos MySQL con PowerShell
https://www.jesusninoc.com/2017/01/15/almacenar-la-informacion-enviada-entre-un-cliente-y-un-servidor-en-una-base-de-datos-mysql-con-powershell/
## Modificar datagramas UDP con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2016/03/19/modificar-datagramas-udp-con-softperfect-network-protocol-analyzer/
## Network
https://www.jesusninoc.com/network

--------------------

# Router
## Ideas para hacer con un router
- Ejecutar scripts
- Instalar aplicaciones
- Analizar información sobre llamadas (recibidas, realizadas, etc.)
- Enviar información desde el router (mail)
- Ver ficheros modificados
- Ver la IP asignada por el proveedor
- Ver la arquitectura del router
- Ejecutar scripts de Python
- Ejecutar código PHP
- Desensamblar aplicaciones

## busybox
For all the standard Unix utilities that the system didn't have.
https://busybox.net/downloads/BusyBox.html

## Binarios busybox
https://www.busybox.net/downloads/binaries/

## The Buildroot user manual
https://buildroot.org/downloads/manual/manual.html

## Busybox container and rootfs builder for minimal Docker base images with Python
https://github.com/odise/busybox-python

## Binario para mips
https://www.busybox.net/downloads/binaries/1.28.1-defconfig-multiarch/busybox-mips.log

## Router Mitrastar HGW-2501GN-R2: Shell e Ingeniería inversa (para crear firmwares modificadas, por ejemplo) (Actualizado)
http://blog.theliel.es/2015/10/router-mitrastar-hgw-2501gn-r2-shell-e-ingenieria-inversa-para-crear-firmwares-modificadas-por-ejemplo.html

## MitraStar DSL-100HN-T1/GPT-2541GNAC - Privilege Escalation
https://www.exploit-db.com/exploits/43061/

## Elevando privilegios en routers domésticos
http://jolama.es/temas/router-attack/index.php

## Enviar binario por SCP
### To copy files from the local system to a remote system:
```Bash
scp file... user@host.domain:path
```
### To copy files from a remote system to your local system:
```Bash
scp user@host.domain:path ... dest
```

----------
----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Concepto nuevo sobre PowerShell

## PowerShell Workflows: The Basics
* https://blogs.technet.microsoft.com/heyscriptingguy/2012/12/26/powershell-workflows-the-basics/

--------------------

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

--------------------

# Antivirus y virus
* https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
* https://www.jesusninoc.com/antivirus/

## Vulnerability
* https://www.jesusninoc.com/vulnerability/

## Una aproximación a los virus en PowerShell
* https://github.com/jesusninoc/Seguridad/blob/master/Una%20aproximaci%C3%B3n%20a%20los%20virus%20en%20PowerShell.md

## Virus examples
* https://www.symantec.com/security_response/landing/threats.jsp
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-012722-4614-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-031313-1110-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-112410-5327-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051114-5305-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052722-4205-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051817-0655-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052017-5535-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051210-1139-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052615-4530-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-012722-4614-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-111216-5350-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2009-061215-3706-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2009-063005-3448-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2010-100614-5201-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-031313-1110-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-112410-5327-99

## VirusTotal
* https://www.virustotal.com/#/home/upload

## Upload a suspected infected file (Retail)
* https://submit.symantec.com/websubmit/retail.cgi

# Ideas sobre comportamientos de troyanos
## Grabar audio
* http://www.jesusninoc.com/2015/06/27/grabar-audio-desde-la-linea-de-comandos/

## Keylogger
* https://www.jesusninoc.com/03/11/keylogger-sencillo-con-powershell/

# Enviar un cmdlet a un servidor y ejecutarlo
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()
```

## Cliente (manda un cmdlet al servidor)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

# Enviar un cmdlet a un servidor, ejecutarlo y mostrar el resultado de la ejecucción en el cliente
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente y devuelve el resultado de la ejecución al cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$respuesta=[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes($respuesta)
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Cliente (manda un cmdlet al servidor y muestra la respuesta que manda el servidor de lo que ha ejecutado)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Dispose()
```

----------
----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

## Equivalencias entre comandos de red de Windows y cmdlets de PowerShell
https://www.jesusninoc.com/2016/02/04/equivalencias-entre-comandos-de-red-de-windows-y-cmdlets-de-powershell/

## Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/2015/11/13/cmdlets-for-tcpip-model-layers/

## Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

## Ejemplos de redes básicos

```PowerShell
1..254|%{$_}
1..254|%{"192.168.1."+$_}
1..254|%{$ip="192.168.1."+$_;$ip}
1..254|%{$ip="192.168.1."+$_;ping $ip}
1..254|%{$ip="192.168.1."+$_;ping $ip;arp -a $ip}
1..254|%{$ip="192.168.1."+$_;$ip;arp -a | Select-String $ip}
```
```PowerShell
Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress
```
```PowerShell
[String]$a=(Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress)
$a.Substring(3,3)
```

## Ejercicio sobre la red

Analizar la siguiente información utilizando la red:
- Aplicaciones instaladas
- Ver si hay IP repetida
- Comprobar si hay fallo en red por culpa de IP repetida
- Comprobar que los equipos se han creado correctamente con el nombre de dominio correcto
- Ver rango de IP en Wifi
- Ver rango de IP en VDI
- ¿Qué usuario ha iniciado sesión?
- Realizar un inventario de la red (PDQ Inventory Tracks It All https://www.pdq.com/pdq-inventory/)

```PowerShell
Invoke-Command -ScriptBlock{([System.Security.Principal.WindowsIdentity]::GetCurrent()).name} -ComputerName 192.168.1.56 -Credential (Get-Credential)
```
```PowerShell
$p = Get-WmiObject win32_process -filter "name='explorer.exe'" -ComputerName 192.168.1.56 -Credential (Get-Credential)
$p.getowner().user
```

--------------------

# Configurar un túnel utilizando un servidor SSH
https://www.jesusninoc.com/2016/02/08/configurar-un-tunel-utilizando-un-servidor-ssh/

--------------------

# Post Exploitation
## Post Exploitation Command List Wiki
https://github.com/mubix/post-exploitation/wiki

## Linux Post Exploitation Command List
https://github.com/mubix/post-exploitation/wiki/Linux-Post-Exploitation-Command-List

## Post Exploitation without Automated Tools (pdf) - InfoSec Resources
This book acts as an introduction to those who know how to use Metasploit and do not know what happens behind the screens.
http://resources.infosecinstitute.com/wp-content/uploads/Post-Exploitation-without-Automated-Tools1.pdf

--------------------

# Ejecutar PHP
## Ejecutar código PHP desde PowerShell
https://www.jesusninoc.com/2017/03/01/ejecutar-codigo-php-desde-powershell/
## Ejecutar un cmdlet de PowerShell desde PHP
https://www.jesusninoc.com/2018/01/06/ejecutar-un-cmdlet-de-powershell-desde-php/
## Ejecutar en PHP un cmdlet de PowerShell en Base64
https://www.jesusninoc.com/2018/02/21/ejecutar-en-php-un-cmdlet-de-powershell-en-base64/
