# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Teoría red
* https://www.jesusninoc.com/04/26/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

# Repaso básico de red

## Convertir a binario las direcciones MAC de los dispositivos de red
* https://www.jesusninoc.com/01/25/convertir-a-binario-las-direcciones-mac-de-los-dispositivos-de-red/

## Configurar IP en Windows
```PowerShell
New-NetIPAddress -InterfaceAlias WiFi -IPAddress 192.168.1.10 -PrefixLength 24 -DefaultGateway 192.168.1.1
```

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Bash
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Conectar con Linux por SSH
https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Guardar un fichero html preguntando al usuario qué título quiere
"<html><title>"+(Read-Host "Introduzca título")+"</title></html>" | Out-File web.html

start chrome .\web.html

## Crear y ejecutar un script de Bash realizando una conexión SSH desde PowerShell en Windows
https://www.jesusninoc.com/2017/09/22/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-desde-powershell-en-windows/

## Crear y ejecutar un script de Bash realizando una conexión SSH a un contenedor Docker desde PowerShell en Windows
https://www.jesusninoc.com/2017/10/21/crear-y-ejecutar-un-script-de-bash-realizando-una-conexion-ssh-a-un-contenedor-docker-desde-powershell-en-windows/
