# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Repaso random PowerShell
* https://github.com/jesusninoc/ClasesISO/blob/master/2021-01-14.md#random

# Chuletas
* https://www.jesusninoc.com/05/02/chuleta-resumen-de-operaciones-en-el-sistema-operativo-con-archivos-y-directorios-en-modo-texto-comandos-en-linux-y-windows-y-cmdlets-en-powershell-y-modo-grafico/
* https://www.jesusninoc.com/05/03/chuleta-resumen-de-tareas-de-administracion-en-el-sistema-operativo-en-modo-texto-comandos-en-linux-y-windows-y-cmdlets-en-powershell-y-modo-grafico/

--------------

# Gestión de usuarios en Linux
## Por pasos dentro de un script
```Bash
nano
```
## Ver si está creado un usuario
```Bash
grep usuario1 /etc/passwd | wc -l
```
## Crear una carpeta en /home 
```Bash
sudo mkdir nombreusuario
```
## Dar permisos a la carpeta del usuario 
```Bash
sudo chmod 764
```
## Crear el usuario y se le asigna el directorio donde va a trabajar y la shell 
```Bash
useradd -d /home/usuarionuevo -s /bin/bash Usuario
```
## Crear la contraseña a el usuario
```Bash
sudo passwd usuario
```
## Cambiar a la carpeta del nuevo usuario de propietario de usuario y grupo
```Bash
chgrp Usuario /home/usuarionuevo
chown Usuario /home/usuarionuevo
```
## Asignar los permisos heredados a la carpeta de el usuario para que tenga los permisos necesarios para trabajar 
```Bash
cd nombreusuario, umask 0011
```

--------------

# Repaso para realizar scripts en Linux

## Resumen de comandos para examen liberatorio (Linux)
https://github.com/jesusninoc/Bash/blob/master/Repaso/ResumenComandosExamenLiberatorio

## Repaso scripting (extraer caracteres de cadenas)
```Bash
short=$(echo "${long}" | cut -c1-2)
short=$(echo "${long}" | head -c2)
short=$(echo "${long}" | awk '{print substr ($0, 0, 2)}')
short=$(echo "${long}" | sed 's/^\(..\).*/\1/')
```

## Partir una cadena por un cáracter determinado
```bash
echo 'hola:adios' | cut -d ':' -f1
```
## Mostrar campos específicos del fichero
```bash
echo "1 Juan Director Tecnología 3000€" > empleados.txt
echo "2 Pedro Becario Web 1000€" >> empleados.txt
awk '{print $2,$5;}' empleados.txt
```
## Sumar los valores de las columnas de un fichero
```bash
echo "1 100" > valor.txt
echo "2 300" >> valor.txt
cat valor.txt  | awk '{ sum += $2 } END { print sum }'
```
## Sumar los valores de las columnas de un fichero si se cumple una condición
```bash
echo "1 nivel1 100" > valor.txt
echo "2 nivel2 300" >> valor.txt
echo "3 nivel1 300" >> valor.txt
cat valor.txt  | awk ' $2 == "nivel1" { sum += $3 } END { print sum }'
```

## Ejemplos y trucos para el lenguaje de programación AWK
http://wiki.woop.es/AWK

--------------

# Utilizar xargs
Definir donde se van a definir los parámetros
```bash
ls | xargs -I ARG echo fichero ARG fichero
```
Definir donde se van a definir los parámetros
```bash
echo "después" | xargs echo "antes"
echo "antes" | xargs -i echo {} "después"
```
Mostrar los parámetros 1 y 2
```bash
cat fichero.txt | xargs -l bash -c 'echo this is first:$0 second:$1'
```
Asignar permisos leyendo desde un fichero el nombre y el permiso en octal
```bash
cat fichero.txt | xargs bash -c 'chmod $0 $1'
```

--------------
--------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Seguridad en Linux

## Linux Shell script to add a user with a password to the system
https://www.cyberciti.biz/tips/howto-write-shell-script-to-add-user.html

--------------

# Permisos en Windows

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Crear un recurso compartido y asignar permisos al recurso
https://www.jesusninoc.com/2015/06/09/crear-un-recurso-compartido-y-asignar-permisos-al-recurso/

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## PENTESTER’S WINDOWS NTFS TRICKS COLLECTION
https://www.sec-consult.com/en/blog/2018/06/pentesters-windows-ntfs-tricks-collection/
  
--------------

# Examen

## Crear usuarios

### En PowerShell (en Windows Server leyendo los usarios de la configuración actual del Directorio Activo del Centro con Win32_UserAccount)
```PowerShell
Get-WmiObject Win32_UserAccount | % {
    Invoke-Command -ScriptBlock {New-LocalUser $_.name -WhatIf} -ComputerName .
}
```
### Leyendo los usuarios desde un fichero en Linux
```PowerShell
wsl cat /root/usuarios.txt | %{
    New-LocalUser $_ -whatif
}
```

### Crear usuarios en Linux, leyendo de un fichero
```Bash
cat usuarios.txt | xargs -I{} useradd {}
```
