# ¿Server instalado?

----------
----------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## DESHABILITAR UAC DESDE POWERSHELL
* https://www.jesusninoc.com/01/15/deshabilitar-uac-desde-powershell/

## Ejercicios sobre usuarios en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1

## Ejercicio para clase
### Buscar un usuario dentro del ordenador (o del Directorio Activo), el nombre del usuario se transmite por radio y llega a un sistema Linux (al que hay que conectarse por SSH)
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/#Ver_o_listar_usuarios
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1
* https://github.com/jesusninoc/ClasesSOM/blob/master/2019-02-14.md#ssh
* https://www.jesusninoc.com/09/24/ssh-desde-powershell/

------------
------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Ejercicios sobre usuarios en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuariosFicheros.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida2.ps1
* https://www.jesusninoc.com/2012/12/30/add-users-xml/
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
* https://www.jesusninoc.com/users/

## Crear usuarios leyendo de un fichero el user y password
```PowerShell
gc .\usuarios.txt | %{
    $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
    New-LocalUser $_.split(",")[0] -Password $pass
}
```

## Crear y eliminar usuarios
```PowerShell
"asir1,p@ssword1" > usuarios.txt
"asir2,p@ssword2" >> usuarios.txt
"asir3"  >> usuarios.txt

#####

gc .\usuarios.txt | %{
    $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
    New-LocalUser $_.split(",")[0] -Password $pass
}

######

gc .\fichero.txt | %{
    if($_.split(",").count -eq 1)
    {
        Remove-LocalUser $_.split(",")[0] -WhatIf
    }
    else
    {
        $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
        New-LocalUser $_.split(",")[0] -Password $pass -WhatIf
    }
}
```

## Analizar información sobre usuarios con PowerShell (1ª parte)
* https://www.youtube.com/watch?v=bZWs08BBjDc
## Analizar información sobre usuarios con PowerShell (2ª parte)
* https://www.youtube.com/watch?v=CCipPiIUVFY
## Crear, modificar y borrar usuarios con PowerShell
* https://www.youtube.com/watch?v=7sxxCnyRwcg
## Analizar información sobre grupos con PowerShell (1ª parte)
* https://www.youtube.com/watch?v=jaIQHD9Jlgc
## Analizar información sobre grupos con PowerShell (2ª parte)
* https://www.youtube.com/watch?v=qprY8B6uI50
## Crear, modificar, añadir usuario, quitar usuario y borrar grupo con PowerShell
* https://www.youtube.com/watch?v=eudt3H2o8z0

## Perfiles
* https://www.jesusninoc.com/07/22/listar-las-rutas-de-los-perfiles-de-los-usuarios/

## UTILIZAR JSON CON NOMBRES Y APELLIDOS ALEATORIOS
* https://www.jesusninoc.com/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

--------------
--------------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Más ejercicios sobre usuarios en PowerShell

  - Ver el SID (Security Identifier) de un usuario en Windows con PowerShell
  - Verificar si existe un usuario en Windows 10 con PowerShell
  - Obtener los SID de las cuentas de usuario en Windows 10
  - Cmdlets relacionados con la gestión de cuentas locales en Windows 10
  - Creates a local user account
  - Creates a local security group
  - Gets local user accounts
  - Gets members from a local group
  - Gets the local security groups
  - Añadir usuarios a un grupo local en Windows 10 con PowerShell 5.1
  - Listar miembros de un grupo local en Windows 10 con PowerShell 5.1
  - Cambiar la contraseña a un usuario local en Windows 10 con PowerShell 5.1
  - Listar grupos locales en Windows 10 con PowerShell 5.1
  - Listar usuarios locales en Windows 10 con PowerShell 5.1
  - Eliminar un grupo local en Windows 10 con PowerShell 5.1
  - Crear un grupo local en Windows 10 con PowerShell 5.1
  - Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
  - Eliminar un usuario local en Windows 10 con PowerShell 5.1
  - Crear un usuario local en Windows 10 con PowerShell 5.1
  - Crear un usuario con contraseña leyendo los datos de un fichero
  - Cambiar contraseña a un usuario
  - Contar el número de grupos que hay en el sistema
  - Contar el número de usuarios que hay en el sistema
  - List local groups
  - List local users
  - Añadir un usuario a un grupo
  - Crear un grupo
  - Crear un usuario con contraseña
  - Usuario actual
  - Information about group accounts
  - Information about user accounts
  - Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
  - Reading username and password from file and do a login
  - Create users and groups, add a user to a group and share directory
  - Create users with passwords
  - Information about remote user

## CONVERTIR A JSON EL LISTADO DE USUARIOS QUE HAY EN EL SISTEMA EJECUTANDO UN CMDLET CON POWERSHELL
* https://www.jesusninoc.com/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

## UTILIZAR JSON CON NOMBRES Y APELLIDOS ALEATORIOS
* https://www.jesusninoc.com/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

## REGISTRAR Y MOSTRAR UN EVENTO EN POWERSHELL CUANDO SE CREA UN USUARIO
* https://www.jesusninoc.com/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

--------------

# Gestión de usuarios en Windows (Server)

## Instalación de servicios de directorio

# Administración de servicio de directorio

## Active Directory
* http://sec.cs.kent.ac.uk/x500book/
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-18.md
* http://www.developandsys.es/category/windows-server/active-directory/
* http://www.developandsys.es/gestion-objetos-active-directory/

### Instalación, configuración, objetos, relaciones de confianza, gpos, rodc, dc secundario (versión core)
* http://www.developandsys.es/category/windows-server/active-directory/

## OpenLDAP, Samba y Samba DC
* http://www.developandsys.es/?s=open+ldap
* http://www.developandsys.es/nfs-y-samba/

## Filtros LDAP

### UTILIZAR UN FILTRO LDAP PARA LOCALIZAR UN USUARIO
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
### UTILIZAR UN FILTRO LDAP PARA VERIFICAR LA HORA DEL ÚLTIMO INICIO DE SESIÓN DE LOS USUARIOS DEL ACTIVE DIRECTORY
* https://www.jesusninoc.com/07/05/utilizar-un-filtro-ldap-para-verificar-la-hora-del-ultimo-inicio-de-sesion-de-los-usuarios-del-active-directory/

## Crear usuarios leyendo desde un fichero (explicar fichero y bucle foreach)
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Ficheros
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Bucle_Foreach

## Cmdlets para Active Directory
* http://www.developandsys.es/gestion-objetos-active-directory/

## Crear en AD usuarios y OU leyendo de un fichero
```PowerShell
foreach($elemento in Get-Content .\crear.txt)
{
    $elemento
    New-ADUSer -Name $elemento -Sam $elemento -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    Start-Sleep -Seconds 5
}

foreach($elemento in Get-Content .\crear.txt)
{
    $elemento.split(",")[0]
}

foreach($elemento in Get-Content .\crear.txt)
{
    if($elemento.split(",")[0] -eq 1)
    {
        "crear ou " + $elemento.split(",")[1]
    }
    
    if($elemento.split(",")[0] -eq 2)
    {
        "crear user " + $elemento.split(",")[1]
        New-ADUSer -Name $elemento.split(",")[1] -Sam $elemento.split(",")[1] -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    }
}
```

---------
---------

# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuario SYSTEM en Windows
* [https://windowstips.wordpress.com/2011/01/10/system-causa-y-efecto-i-de-iv/](https://windowstips.wordpress.com/2011/01/10/system-causa-y-efecto-i-de-iv/)
* [https://windowstips.wordpress.com/2011/01/11/system-causa-y-efecto-ii-de-iv/](https://windowstips.wordpress.com/2011/01/11/system-causa-y-efecto-ii-de-iv/)

## Ejercicio script de creación de usuarios en AD
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

## Más sobre usuarios en AD
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-24.md

--------------

# Passwords

## ENCONTRAR UN PASSWORD QUE CONTIENE LOS NÚMEROS DE LA PRIMERA FILA DEL TECLADO QWERTY GENERANDO COMBINACIONES ALEATORIAS
https://www.jesusninoc.com/01/20/encontrar-un-password-que-contiene-los-numeros-de-la-primera-fila-del-teclado-qwerty-generando-combinaciones-aleatorias/

## Contraseñas seguras con PowerShell
https://www.jesusninoc.com/contrasenas-seguras-con-powershell/

## Cracking Passwords Version 1.1
https://repo.zenk-security.com/Reversing%20.%20cracking/Cracking_Passwords_Guide.pdf

## Privilege Escalation without Automated Tools - InfoSec Resources
https://securitydocs.com/privilege-escalation-without-automated-tools-infosec-resources/38418/

--------------

# Random

## Ejercicio PowerShell: adivinar un número aleatorio que genera PowerShell

```PowerShell
#Generar un número aleatorio entre 1 y 100
Get-Random (1..100)
```
```PowerShell
#Pedir al usuario un número una vez e intentar adivinar el número aleatorio que se ha generado
$numeroadivinar=Get-Random (1..100)
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100
$numeroadivinar=Get-Random (1..100)
while($true)
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
#Si se adivina el número salir del bucle while con break
break
}
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100, ofrecer ayuda al usuario para adivinar el número
$numeroadivinar=Get-Random (1..100)
do
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
switch($numeroadivinar)
{
{$_ -le $a -and $_ -ge 1}{Write-Host "No adivinado, el número es menor que $a" -ForegroundColor red}
{$_ -eq $a}{Write-Host "Número adivinado" -BackgroundColor Blue;break}
{$_ -ge $a -and $_ -le 100}{Write-Host "No adivinado, el número es mayor que $a" -ForegroundColor red}
}
#Si el número está adivinado acabar de preguntar al usuario
}while(!($numeroadivinar -eq $a))
```

## Más sobre random
### Generar letras aleatorias
https://www.jesusninoc.com/2017/10/11/generar-letras-aleatorias/

### Generate Random Text based on Length
https://www.commandlinefu.com/commands/view/24101/generate-random-text-based-on-length

### Ejercicios de PowerShell: mostrar y escribir una letra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/02/ejercicios-de-powershell-mostrar-y-escribir-una-letra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Generar palabras aleatorias con letras aleatorias
https://www.jesusninoc.com/2017/01/07/generar-palabras-aleatorias-con-letras-aleatorias/

### Ejercicios de PowerShell: mostrar y escribir una palabra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/05/ejercicios-de-powershell-mostrar-y-escribir-una-palabra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera
https://www.jesusninoc.com/2017/03/01/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera (script en una línea)
https://www.jesusninoc.com/2017/03/02/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera-script-en-una-linea/

### Tres en raya
```Java
private int[][] lineaGanadora = new int[][] { { 0, 1, 2 }, { 3, 4, 5 }, { 6, 7, 8 }, { 0, 3, 6 }, { 1, 4, 7 }, { 2, 5, 8 }, { 0, 4, 8 }, { 2, 4, 6 } };
```

--------------

# Ejercicio de password y random
## Crear usuarios con un password random e intentar adivinarlo con Cain y Abel
```PowerShell
(((1..9) | Get-Random -Count 4) -join "") + (((97..99) | Get-Random -Count 2 | % {[char]$_}) -join "") + (((65..67) | Get-Random -Count 2 | % {[char]$_}) -join "")
```
## Cain y Abel
* https://github.com/xchwarze/Cain
