# Examen 1ª recuperación
## Realizar el siguiente script mediante funciones:
1.	Crear carpetas para cada servicio.
2.	Añadir a cada carpeta información sobre los procesos que están relacionados con cada servicio.
3.	Añadir a cada carpeta información sobre los hilos y los procesos que están relacionados cada servicio.

------------------------

# Introducción a tareas de administración
https://www.jesusninoc.com/2017/09/01/administrar-el-sistema-operativo-windows-con-powershell-libro-gratis-nivel-intermedio/

## Agregar/Eliminar software
https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
## Actualización
https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
## Gestión de procesos
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
## Programación de tareas
https://www.jesusninoc.com/03/01/tareas-programadas-en-powershell/
## Usuarios
https://www.jesusninoc.com/2017/07/08/8-gestion-de-usuarios-en-powershell/
## Grupos
https://www.jesusninoc.com/2017/07/08/8-gestion-de-usuarios-en-powershell/
## Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
## Gestión de la red
https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
## Copias de seguridad
https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
## Reparación del sistema
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/
## Rendimiento del sistema
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

------------------------

# Gestión del software
## Crear directorios para cada proceso que se ejecuta y dentro de cada directorio añadir información sobre el paquete (Get-Package)

### Crear carpeta cada proceso que se ejecuta
```PowerShell
mkdir (Get-Process).Name
```
### Añadir información sobre el software para cada proceso que se ejecuta
```PowerShell
(Get-Process).Name | %{
    $_
    Get-Package | select * | Select-String $_ | Out-File -FilePath $_\$_
}
```

## Almacenar en Windows los programas que tienen los Linux de la red (realizar el siguiente ejercicio entre Windows y Linux sobre instalación de programas)
### Programas instalados Debian
```bash
dpkg --get-selections
```

### Saber si un programa está instalado
```bash
dpkg --get-selections | grep 'nano'
```

------------------

# Actualizar
## Buscar actualizaciones instaladas con PowerShell
https://www.jesusninoc.com/2017/09/12/buscar-actualizaciones-instaladas-con-powershell/
## Ver actualizaciones instaladas en el sistema
https://www.jesusninoc.com/2016/09/08/ver-actualizaciones-instaladas-en-el-sistema/
## ¿Qué actualizaciones de seguridad tenemos aplicadas en Windows y para qué sirven?
https://www.jesusninoc.com/2015/04/12/que-actualizaciones-de-seguridad-tenemos-aplicadas-en-windows-y-para-que-sirven/
## WUSA y nivel alto de privilegio
https://www.youtube.com/watch?v=Z2ugTm3vCrk

------------------

# Tareas programadas
## Tareas programadas en Windows
https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1
## Tareas programadas en Linux
https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh
