# Multimedia
## Leer palabras mediante la voz del Sistema Operativo
https://www.jesusninoc.com/2016/12/15/leer-palabras-mediante-la-voz-del-sistema-operativo/

## Leer palabras de un fichero y almacenar cada palabra en un fichero de audio mediante la voz del Sistema Operativo
https://www.jesusninoc.com/2016/12/24/leer-palabras-de-un-fichero-y-almacenar-cada-palabra-en-un-fichero-de-audio-mediante-la-voz-del-sistema-operativo/

## Convertir ficheros de audio a texto
https://www.jesusninoc.com/2016/12/25/convertir-ficheros-de-audio-a-texto/

## Convertir la entrada de micrófono a texto
https://www.jesusninoc.com/2016/12/26/convertir-la-entrada-de-microfono-a-texto/

--------------------

# Radio
## Ejercicios sobre señales de radio

[![Enviar señales de radio desde Raspberry Pi mediante una conexión SSH desde PowerShell
](https://img.youtube.com/vi/8kglbrLWHrY/0.jpg)](https://www.youtube.com/watch?v=8kglbrLWHrY)

## Enlaces importantes:
* Software-Defined Radio for Engineers https://news.ycombinator.com/item?id=17399554
* https://www.youtube.com/watch?v=8kglbrLWHrY
* https://github.com/markondej/fm_transmitter
* https://www.jesusninoc.com/2016/12/07/ejercicios-de-powershell-dividir-el-contenido-de-una-frase-en-palabras-y-guardar-cada-palabra-en-un-fichero/
* https://www.jesusninoc.com/2016/12/24/leer-palabras-de-un-fichero-y-almacenar-cada-palabra-en-un-fichero-de-audio-mediante-la-voz-del-sistema-operativo/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/10/14/ejecutar-airodump-ng-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjemplosDescomprimir.sh

## Crear un audio que vamos a mandar mediante señales de radio

```PowerShell
#Convertir una frase en audio con la voz del sistema operativo desde PowerShell

Add-Type -AssemblyName System.Speech
$synthesizer = New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer
$synthesizer.SetOutputToWaveFile("saludo.wav")
$synthesizer.Speak("Hola amigo Pedro")
$synthesizer.SetOutputToDefaultAudioDevice()
Get-ChildItem .\saludo.wav
```

## Subir el audio a Raspberry Pi realizando una conexión SCP
```PowerShell
#Iniciar una sesión SCP
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList "pi", $Pass

#Para configurar Set-SCPFile
#Indicar el fichero que vamos a subir -LocalFile
#Indicar el equipo al que nos vamos a conectar -ComputerName
#Indicar la ruta en la que vamos a subir el audio -RemotePath
#Forzar la conexión para evitar fallo "Key exchange negotiation failed."
#Indicar los credenciales que hemos creado anteriormente

Set-SCPFile -LocalFile .\saludo.wav -ComputerName 192.168.1.161 -RemotePath ./fmm/fm_transmitter-master -Force -Credential $Credential
```

## Enviar mediante señales de radio el fichero que hemos subido
```PowerShell
#Ejecutar fm_transmitter (use Raspberry Pi as FM transmitter)

#Iniciar una sesión SSH
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$sUser = "pi"
$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList $sUser, $Pass
$oSessionSSH = New-SSHSession -ComputerName 192.168.1.161 -Force -Credential $Credential

#Crear canal de comunicación entre PowerShell y Linux (Raspberry Pi)
#Convertirse en sudo para ejecutar fm_transmitter

$stream = $oSessionSSH.Session.CreateShellStream("PS-SSH", 0, 0, 0, 0, 1000)
Invoke-SSHStreamExpectSecureAction -ShellStream $stream -Command "sudo su -" -ExpectString "[sudo] password for $($sUser):" -SecureAction $Pass

#Transmitir por radio en la frecuencia 90 MHz el saludo creado anteriormente
$stream.WriteLine("/home/pi/fmm/fm_transmitter-master/fm_transmitter -f 90 /home/pi/fmm/fm_transmitter-master/saludo.wav")

#Verificar que llega bien la señal desde SDR o desde una radio FM en la frecuencia 90 MHz
```

--------------------

# Realizar una comunicación enviando preguntas y respondiendo de forma automática

## Teniendo en cuenta la idea de comunicar dos ordenadores mediante la voz del sistema operativo
https://www.jesusninoc.com/2016/01/10/comunicar-dos-ordenadores-mediante-la-voz-del-sistema-operativo/

## ENVIAR PREGUNTAS
```PowerShell
#Leer el texto contenido dentro de un fichero mediante la voz del Sistema Operativo
Add-Type -AssemblyName System.Speech

#Añadir textos para que se lean
"¿Qué tal?" | Out-File conversacion.txt
"¿Cuántos años tienes?" | Out-File conversacion.txt -Append
"¿Tienes novia?" | Out-File conversacion.txt -Append

#Leer los textos mediante la voz del Sistema Operativo
gc conversacion.txt | %{
$_
(New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer).Speak($_)
Start-Sleep -Seconds 3
}
```

## RECONOCIMIENTO Y RESPUESTA
```PowerShell
#Crear objeto para reconocimiento
Add-Type -AssemblyName System.Speech
$rec = New-Object 'System.Speech.Recognition.SpeechRecognitionEngine'
$rec.LoadGrammar((New-Object 'System.Speech.Recognition.DictationGrammar'))
$rec.SetInputToDefaultAudioDevice()

#Añadir posibles respuestas
"tal|Bien y tú?" | Out-File frases.txt
"años|40" | Out-File frases.txt -Append
"novia|Sí" | Out-File frases.txt -Append
"novio|Sí" | Out-File frases.txt -Append

#Crear un ArrayList con las respuestas
[System.Collections.ArrayList]$arraylist = New-Object System.Collections.ArrayList
ForEach ($elemento in (gc .\frases.txt).split("|")){[void]$arraylist.Add($elemento)}

#Función para comprobar si el mensaje que llega está entre las posibles respuestas
#La función responde mediante la voz del Sistema Operativo
function comprobar($frase){
    [System.Collections.ArrayList]$arraylist2 = New-Object System.Collections.ArrayList
    ForEach ($elemento in $frase.split(" ")){[void]$arraylist2.Add($elemento)}

    $arraylist2 | %{
        if($arraylist.IndexOf($_) -ne -1){
            (New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer).Speak($arraylist[($arraylist.IndexOf($_))+1])
        }
    }
}

#Comenzar a reconocer los audios que vayan llegando y comprobar qué mensajes llegan
do{
$mensaje=$rec.Recognize().Text
$mensaje
comprobar $mensaje
}while(1)
```

--------------------

# Motor de síntesis de voz en PowerShell

## Realizar: 
- Pronunciar un texto mediante el motor de síntesis de voz en PowerShell
- Pronunciar un texto cambiando la voz del motor de síntesis de voz en PowerShell
- Guardar en un fichero de audio un texto pronunciado mediante el motor de síntesis de voz en PowerShell

## Vídeo en Youtube
https://www.youtube.com/watch?v=eFqCh7JR5rc&list=UUNQh1Ef6VUqRzejB5lrTc0Q&index=16

[![Utilizar el motor de síntesis de voz en Powershell para leer cualquier texto
](https://img.youtube.com/vi/eFqCh7JR5rc/0.jpg)](https://www.youtube.com/watch?v=eFqCh7JR5rc)

## Pronunciar un texto mediante el motor de síntesis de voz en PowerShell
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz
$speaker = [System.Speech.Synthesis.SpeechSynthesizer]::new()

#Obtener información sobre la voz actual del motor de síntesis de voz
$speaker.Voice

#Pronunciar el texto
$speaker.Speak("Hola, hola. ¿Qué tal estás?. ¿Qué edad tienes?.")
```

## Pronunciar un texto cambiando la voz del motor de síntesis de voz en PowerShell
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz
$speaker = [System.Speech.Synthesis.SpeechSynthesizer]::new()

#Cambiar la voz actual del motor de síntesis de voz
$speaker.SelectVoice("Microsoft Helena Desktop")

#Pronunciar el texto
$speaker.Speak("Hola, hola. ¿Qué tal estás?. ¿Qué edad tienes?.")
```

## Guardar en un fichero de audio un texto pronunciado mediante el motor de síntesis de voz en PowerShell
```PowerShell
#Cargar el espacio de nombres System.Speech que contiene los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz
$speaker = [System.Speech.Synthesis.SpeechSynthesizer]::new()

#Configurar el motor de síntesis de voz para guardar en un fichero de audio
$speaker.SetOutputToWaveFile("saludos.wav")

#Pronunciar el texto
$speaker.Speak("Hola, hola. ¿Qué tal estás?. ¿Qué edad tienes?.")

#Configurar el motor de síntesis de voz para enviar el resultado en el dispositivo de audio predeterminado
$speaker.SetOutputToDefaultAudioDevice()

.\saludos.wav
```

--------------------

# Reconocimiento mediante el motor de síntesis

## Realizar: 
1. Reconocer una palabra con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para el dictado de texto sin formato
2. Reconocer una palabra contenida en un fichero de audio con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para texto sin formato
3. Reconocer varias palabras con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para el dictado de texto sin formato
4. Reconocer varias palabras contenidas en un fichero de audio con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para texto sin formato
5. Reconocer varias palabras contenidas en un fichero de audio con el motor de síntesis de voz en PowerShell creando las restricciones de una gramática de reconocimiento de voz

## Vídeo en Youtube
https://www.youtube.com/watch?v=z2PHuFKBjfU

[![Utilizar el motor de síntesis de voz en Powershell para analizar audios con voz](https://img.youtube.com/vi/z2PHuFKBjfU/0.jpg)](https://www.youtube.com/watch?v=z2PHuFKBjfU)

## 1. Reconocer una palabra con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para el dictado de texto sin formato
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Representar una gramática de reconocimiento de voz utilizada para el dictado de texto sin formato
$speechRecogEng.LoadGrammar([System.Speech.Recognition.DictationGrammar]::new())

#Configurar el motor de síntesis de voz para recibir la entrada desde el dispositivo de audio predeterminado
$speechRecogEng.SetInputToDefaultAudioDevice()

#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
```

## 2. Reconocer una palabra contenida en un fichero de audio con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para texto sin formato
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Representar una gramática de reconocimiento de voz utilizada para el dictado de texto sin formato
$speechRecogEng.LoadGrammar([System.Speech.Recognition.DictationGrammar]::new())

#Configurar el motor de síntesis de voz para recibir la entrada desde un archivo de formato de sonido (.wav)
$speechRecogEng.SetInputToWaveFile(".\holas.wav")

#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
```

## 3. Reconocer varias palabras con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para el dictado de texto sin formato
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Representar una gramática de reconocimiento de voz utilizada para el dictado de texto sin formato
$speechRecogEng.LoadGrammar([System.Speech.Recognition.DictationGrammar]::new())

#Configurar el motor de sínteris de voz para recibir la entrada desde el dispositivo de audio predeterminado
$speechRecogEng.SetInputToDefaultAudioDevice()

do
{
#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
#Mientras que haya audio
}while($speechRecogEng.AudioFormat)
```

## 4. Reconocer varias palabras contenidas en un fichero de audio con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para texto sin formato
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Representar una gramática de reconocimiento de voz utilizada para el dictado de texto sin formato
$speechRecogEng.LoadGrammar([System.Speech.Recognition.DictationGrammar]::new())

#Configurar el motor de síntesis de voz para recibir la entrada desde un archivo de formato de sonido (.wav)
#El fichero holas2.wav contiene: "Hola, hola. ¿Qué tal estás?. ¿Qué edad tienes?."
$speechRecogEng.SetInputToWaveFile(".\holas2.wav")

do{
#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
#Mientras que haya audio
}while($speechRecogEng.AudioFormat)
```

## 5. Reconocer varias palabras contenidas en un fichero de audio con el motor de síntesis de voz en PowerShell creando las restricciones de una gramática de reconocimiento de voz
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Crear las restricciones para una gramática de reconocimiento de voz
$speechRecogEng.LoadGrammar([System.Speech.Recognition.GrammarBuilder]::new("Hola"))
$speechRecogEng.LoadGrammar([System.Speech.Recognition.GrammarBuilder]::new("Tal"))
$speechRecogEng.LoadGrammar([System.Speech.Recognition.GrammarBuilder]::new("Edad"))

#Configurar el motor de síntesis de voz para recibir la entrada desde un archivo de formato de sonido (.wav)
$speechRecogEng.SetInputToWaveFile(".\holas2.wav")

do{
#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
Start-Sleep -Seconds 2
#Mientras que haya audio
}while($speechRecogEng.AudioFormat)
```

--------------------

# Reconocimiento

## Utilizar el motor de síntesis de voz en Powershell para analizar audios con voz comparando los resultados entre gramáticas
https://www.jesusninoc.com/2017/12/27/utilizar-el-motor-de-sintesis-de-voz-en-powershell-para-analizar-audios-con-voz-comparando-los-resultados-entre-gramaticas/

## Analizar frecuencias de audio con SDRSharp
https://www.jesusninoc.com/2016/04/29/analizar-frecuencias-de-audio-con-sdrsharp/

## Reproducir notas musicales con PowerShell
https://www.jesusninoc.com/2017/09/23/reproducir-notas-musicales-con-powershell/

## Detectar una frecuencia de sonido emitida desde un dispositivo utilizando la tarjeta de sonido y el programa SDRSharp
https://www.jesusninoc.com/2017/01/01/detectar-una-frecuencia-de-sonido-emitida-desde-un-dispositivo-utilizando-la-tarjeta-de-sonido-y-el-programa-sdrsharp/

## Analizar frecuencias de audio con SDRSharp (reconocer la palabra hola)
https://www.jesusninoc.com/2017/01/31/analizar-frecuencias-de-audio-con-sdrsharp-reconocer-la-palabra-hola/
