# Repaso evaluación
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-05.md#resolver-las-siguientes-situaciones

----------

# Administración y aseguramiento de la información
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------

# PowerShell

## Ejercicio sobre copias de seguridad con integridad: comprobar que los ficheros que tengo en una carpeta son correctos en la copia de seguridad mediante la integridad

```PowerShell
# Ideas

# Probar la integridad de las copias de seguridad:
# - Crear un plan de pruebas. 
# - Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
# - Comprobar si los tiempos de restauración son asumibles.

# Ficheros que se van a copiar
# fichero1.txt
# fichero2.txt
# fichero3.txt
# fichero4.txt

# Ficheros que tienen las integridades de los ficheros 1,2,3,4
# fichero1integridad.txt
# fichero2integridad.txt
# fichero3integridad.txt
# fichero4integridad.txt

# crear el zip 1,2,3,4

# -------------------- RECUPERACIÓN

# descomprimir zip 1,2,3,4

# ver integridad fichero que tiene los hashes 1,2,3,4

# fichero1 si abro si la integridad es correcta

"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt

# zip meter fichero1.txt más integridades.txt (se puede separar en dos archivos)

# hay fallo y tengo que recuperar la copia

# descomprimir y ver si el fichero1.txt lo puedo ver

# porque la integridad de fichero1 es correcta

# h(f1) == f1*

if((gc .\fichero1integridad.txt) -eq (Get-FileHash .\fichero1.txt).hash)
{
    "El hash coincide"
}
else
{
    "El hash no coincide"
}

# Ver si el hash coincide para todos los ficheros

mkdir ficheros
cd .\ficheros
"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt
"holas" > fichero2.txt
(Get-FileHash .\fichero2.txt).hash
(Get-FileHash .\fichero2.txt).hash > fichero2integridad.txt

# Se supone que se ha comprimido

# Hay fallo
 
# Verificar que todos los hashes son correctos

ls fichero?.txt | %{
    $ficherointeg = $_.FullName
    $ficherointeg2 = $ficherointeg.replace(".txt","")
    $ficherofinal = ([String]$ficherointeg2+"integridad.txt")

    if(((Get-FileHash $_).hash) -eq (gc $ficherofinal))
    {
        "El hash coincide"
    }
    else
    {
        "El hash no coincide"
    }
}
```

## Programar la copia de seguridad
* https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## Ejercicio: crear una tarea programada que ejecuta un script en PowerShell que realiza una copia de seguridad
### Crear una copia de seguridad
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-26.md#ejercicio-sobre-copias-de-seguridad-con-integridad-comprobar-que-los-ficheros-que-tengo-en-una-carpeta-son-correctos-en-la-copia-de-seguridad-mediante-la-integridad
* https://www.jesusninoc.com/12/08/crear-una-tarea-programada-en-windows-que-ejecute-un-script-de-powershell-cada-10-minutos-de-forma-indefinida-aunque-el-porcentaje-de-bateria-sea-bajo/
### Tener en cuenta a la hora de programar la tarea que ejecuta el script
```PowerShell
# Cambiar la política de ejecución de scripts para poder ejecutar
Set-ExecutionPolicy -ExecutionPolicy Unrestricted -Scope CurrentUser

# Ecribir un mensaje por pantalla
echo "hola"

# Mostrar la ruta
pwd

# Parar el script
pause

# Almacenar en un fichero la hora a la que se ejecuta el script junto con el porcentaje de batería
echo (Get-Date).Hour >> C:\xampp\mysql\bin\fichero.txt
```
### Repetir cada 1 hora indefinidamente la ejecución de un script en PowerShell
```PowerShell
$Sta = New-ScheduledTaskAction -Execute "powershell"
$Stt = New-ScheduledTaskTrigger -Once -At 19pm -RepetitionInterval (New-TimeSpan -hour 1)
Register-ScheduledTask Task01 -Action $Sta -Trigger $Stt
```

-------------
-------------

# Clase especial

## Instalar Icecast is free server software for streaming multimedia
```Bash
sudo apt-get install icecast2 darkice
```

## Descargar un mp4 y un mp3 en la carpeta /usr/share/icecast2/web
```Bash
wget https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3
```

## Reproducir ficheros desde el móvil
http://192.168.1.162:8000/sound.mp3

## Download videos from YouTube (youtube-dl)
https://www.jesusninoc.com/2014/10/18/download-videos-youtube/

## Subir a un servidor el contenido generado en PowerShell
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/

## Descargar ficheros de un servidor Linux desde PowerShell
https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## Cortar un vídeo
https://github.com/jesusninoc/Scripts/blob/master/Cortar%20un%20v%C3%ADdeo.sh

## Convertir a texto un audio en formato WAV
https://www.jesusninoc.com/08/15/convertir-audio-en-formato-wav-a-texto-version-15-08-2015/

## Reconocimiento de voz a texto
https://www.jesusninoc.com/06/26/reconocimiento-de-patrones-utilizando-powershell/#Reconocimiento_de_voz_a_texto

---------------------

# Clase especial

## Instalar Icecast is free server software for streaming multimedia
```Bash
sudo apt-get install icecast2 darkice
```

## Descargar un mp4 y un mp3 en la carpeta /usr/share/icecast2/web
```Bash
wget https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3
```

## Reproducir ficheros desde el móvil
http://192.168.1.162:8000/sound.mp3

## Download videos from YouTube (youtube-dl)
https://www.jesusninoc.com/2014/10/18/download-videos-youtube/

## Subir a un servidor el contenido generado en PowerShell
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/

## Descargar ficheros de un servidor Linux desde PowerShell
https://www.jesusninoc.com/2017/11/04/descargar-un-fichero-por-ssh-de-un-servidor-linux-desde-powershell-en-windows/

## Cortar un vídeo
https://github.com/jesusninoc/Scripts/blob/master/Cortar%20un%20v%C3%ADdeo.sh

## Convertir a texto un audio en formato WAV
https://www.jesusninoc.com/08/15/convertir-audio-en-formato-wav-a-texto-version-15-08-2015/

## Reconocimiento de voz a texto
https://www.jesusninoc.com/06/26/reconocimiento-de-patrones-utilizando-powershell/#Reconocimiento_de_voz_a_texto

---------------------

# Ejercicio 

## Partir en trozos un audio en MP3, convertirlos en WAV y después convertir a texto el audio

### Partir en trozos un audio en MP3 y convertirlos en WAV
```CMD
ffmpeg -i audio.mp3 -ss 70 -t 113 miaudio_cortado.mp3
ffmpeg -i song.mp3 -acodec pcm_u8 -ar 22050 song.wav
```

#### Versión 1
```PowerShell
[void][reflection.assembly]::LoadWithPartialName(‘system.speech’)

$rec = New-Object ‘System.Speech.Recognition.SpeechRecognitionEngine’
$rec.LoadGrammar((New-Object ‘System.Speech.Recognition.DictationGrammar’))
$rec.SetInputToWaveFile("C:\Users\ajnino\Downloads\ffmpeg-20191120-d73f062-win32-static\ffmpeg-20191120-d73f062-win32-static\bin\song.wav")
[String]$almacenarcadena=''
[String]$cadenaconvert=''

do
{
$cadena=$rec.Recognize().Text
$cadenaconvert=[String]$cadena.ToString()
$cadenaconvert
}while($rec.AudioFormat)
```

---------------------

# Otros enlaces interesantes

## Expresiones regulares
https://www.regular-expressions.info/tutorial.html
http://www.vicente-navarro.com/blog/2007/04/13/expresiones-regulares-en-la-shell-ejemplos-de-uso-con-grep-awk-y-sed/

## DEJAVU: AUDIO FINGERPRINTING AND RECOGNITION IN PYTHON
https://www.jesusninoc.com/02/06/dejavu-audio-fingerprinting-and-recognition-in-python/

## Número de hilos que ejecuta Icecast
https://github.com/jesnino/Bash/blob/master/Procesos/EjerciciosHilos.sh

## Simular la transmisión de vídeo entre un cliente y un servidor (streaming)
https://www.jesusninoc.com/2016/03/12/simular-la-transmision-de-video-entre-un-cliente-y-un-servidor-streaming/

## Enviar un vídeo MP4 entre dos Linux mediante Netcat
https://www.jesusninoc.com/2017/11/12/enviar-un-video-mp4-entre-dos-linux-mediante-netcat/

## Livestreamer is a command-line utility that pipes video streams from various services into a video player, such as VLC
https://www.jesusninoc.com/2017/10/07/livestreamer/

## Conectarse por SSH al router de fibra óptica MitraStar de Movistar desde PowerShell
https://www.jesusninoc.com/2017/11/16/conectarse-por-ssh-al-router-de-fibra-optica-mitrastar-de-movistar-desde-powershell/

## Ver los procesos que se están ejecutando en el router de fibra óptica MitraStar de Movistar desde PowerShell
https://www.jesusninoc.com/2017/11/17/ver-los-procesos-que-se-estan-ejecutando-en-el-router-de-fibra-optica-mitrastar-de-movistar-desde-powershell/

## Autenticarse en un router de fibra óptica MitraStar de Movistar y ver una lista de llamadas perdidas
https://www.jesusninoc.com/2017/04/10/autenticarse-en-un-router-de-fibra-optica-mitrastar-de-movistar-y-ver-una-lista-de-llamadas-perdidas/

## Autenticarse en un router de fibra óptica MitraStar de Movistar y ver las reglas del firewall
https://www.jesusninoc.com/2017/04/13/autenticarse-en-un-router-de-fibra-optica-mitrastar-de-movistar-y-ver-las-reglas-del-firewall/

## Autenticarse en un router de fibra óptica MitraStar de Movistar y ver las asignaciones DHCP
https://www.jesusninoc.com/2017/05/14/autenticarse-en-un-router-de-fibra-optica-mitrastar-de-movistar-y-ver-las-asignaciones-dhcp/

## Autenticarse en un router de fibra óptica MitraStar de Movistar y ver la tabla ARP
https://www.jesusninoc.com/2017/05/10/autenticarse-en-un-router-de-fibra-optica-mitrastar-de-movistar-y-ver-la-tabla-arp/

-----------------

# Clase especial

## REPRODUCIR TRÁILERES DE PELÍCULAS
* https://www.jesusninoc.com/11/21/reproducir-traileres-de-peliculas/

## ENVIAR LA REPRODUCCIÓN DE LOS TRÁILERES DE PELÍCULAS A LA SMART TV
* https://www.jesusninoc.com/11/22/enviar-la-reproduccion-de-los-traileres-de-peliculas-a-la-smart-tv/

-----------------

# Clase especial

## Crear un audio que vamos a mandar mediante señales de radio

```PowerShell
#Convertir una frase en audio con la voz del sistema operativo desde PowerShell

Add-Type -AssemblyName System.Speech
$synthesizer = New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer
$synthesizer.SetOutputToWaveFile("saludo.wav")
$synthesizer.Speak("Hola amigo Pedro")
$synthesizer.SetOutputToDefaultAudioDevice()
Get-ChildItem .\saludo.wav
```

## Subir el audio a Raspberry Pi realizando una conexión SCP
```PowerShell
#Iniciar una sesión SCP
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList "pi", $Pass

#Para configurar Set-SCPFile
#Indicar el fichero que vamos a subir -LocalFile
#Indicar el equipo al que nos vamos a conectar -ComputerName
#Indicar la ruta en la que vamos a subir el audio -RemotePath
#Forzar la conexión para evitar fallo "Key exchange negotiation failed."
#Indicar los credenciales que hemos creado anteriormente

Set-SCPFile -LocalFile .\saludo.wav -ComputerName 192.168.1.161 -RemotePath ./fmm/fm_transmitter-master -Force -Credential $Credential
```

-----------------

# Más clases especiales
* https://www.jesusninoc.com/02/16/muneco-bailando/
* https://github.com/jesusninoc/ClasesIAW/blob/master/2019-11-25.md#proyectos-de-la-semana
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-01-01.md
