# Correción del examen
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-03.md#preguntas-examen-liberatorio
* https://github.com/jesusninoc/ISO-1/blob/main/Examen%20liberatorio
## Soluciones
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-1-con-where/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-2-con-foreach/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-3-creando-una-carpeta-con-la-informacion-obtenida-cada-24-horas/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-4-pasando-como-parametro-el-proceso-a-monitorizar/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-crear-una-funcion-simple-para-monitorizar-procesos-version-5-pasando-como-parametro-cada-proceso-que-se-ejecuta-y-monitorizando-cada-24-horas/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-obtener-informacion-sobre-los-procesos-que-se-estan-ejecutando-que-hace-un-proceso/
* https://www.jesusninoc.com/12/10/ejercicios-de-powershell-obtener-informacion-sobre-los-procesos-que-se-estan-ejecutando-analizando-las-dll-que-ejecuta-que-hace-un-proceso/

## Examen subida de nota: realizar un ejercicio sobre copias de seguridad en Linux, utilizando como idea la solución en PowerShell (primer enlace)
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-10.md#ejercicio-sobre-copias-de-seguridad-con-integridad-comprobar-que-los-ficheros-que-tengo-en-una-carpeta-son-correctos-en-la-copia-de-seguridad-mediante-la-integridad
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-12-10.md#ejercicios-sobre-copias-de-seguridad

--------
--------

# Administración y aseguramiento de la información
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------

# Ficheros en Linux

## Introducción a buscar ficheros
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh

## Conocer la extensión de un fichero en Linux
```Bash
file fichero
```

## Ejercicio calcular hash en Linux
```Bash
proceso=`ps -C nano -o cmd --no-headers`
ruta=`whereis $proceso`
sha512sum $ruta
```

## Introducción a bucles en Linux
* https://www.jesusninoc.com/2015/07/13/bucles-2/
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/

## Bucle for en Linux
```Bash
for i in $(pgrep application.x); do ps -mo pid,tid,fname,user,psr -p $i;done
```

## Ver funcionamiento de awk
```Bash
echo "hola amigo" | awk '{print $1}'
echo "hola amigo" | awk '{print $2}'
echo "touch amigo" | awk '{print $1}'; echo "touch amigo" | awk '{print $2}'
```

## Calcular el hash SHA512 de todos los procesos que se están ejecutando en Linux
```Bash
for procesos in $(ps -aux | awk '{print $11}');do ruta=`whereis $procesos`; sha512sum $ruta;done
```

-------------

# Ficheros en PowerShell

## Listar ficheros cuya fecha de última escritura de ficheros sea de mayor que menos un día
```PowerShell
Get-ChildItem | where LastWriteTime -gt (Get-Date).AddDays(-1)
```
## Listar ficheros cuyo tamaño sea mayor de 1MB
```PowerShell
Get-ChildItem -Recurse | where Length -Gt 1MB
```
## Listar la ruta de los programas que se están ejecutando
```PowerShell
foreach($procesos in (Get-Process | select path))
{
    Get-FileHash $procesos.path
}
```
## Listar la ruta del programa Chrome que se está ejecutando
```PowerShell
foreach($id in Get-Process -Name chrome)
{
    Get-FileHash $id.Path
}
```

---------------

# Linux

## Copias de seguridad
* http://www.developandsys.es/copias-seguridad-linux/

## Programar la copia de seguridad
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh

## Ejercicios sobre copias de seguridad
- Listar archivos por fecha
  ```Bash
  ls -lt
  ls -ltr
  ls -l --sort=size
  ```
- Copia de seguridad para cada día de la semana y ser capaz de recuperar
  * https://www.youtube.com/watch?v=aDCfL9Pk3TQ&feature=youtu.be
  * https://github.com/jesnino/Bash/blob/master/Ficheros/EjercicioCalendario.sh
- Copiar cada fichero listado de un directorio en un nuevo directorio
  * https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-22.md#utilizar-xargs
- Comprimir las copias de seguridad que se han realizado
  * https://linuxzone.es/metodos-de-compresion-y-descompresion-en-linux/
- Enviar un mail cuando se haya realizado la copia de seguridad
  * https://www.interserver.net/tips/kb/linux-mail-command-usage-examples/

## Copias de seguridas de bases de datos

### MySQL dump ignorando tablas
* https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20ignorando%20tablas.sh

### MySQL dump completo
* https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20completo.sh

### Borrar copias de seguridad de bases de datos en MySQL.sh
* https://github.com/jesusninoc/Scripts/blob/master/Borrar%20copias%20de%20seguridad%20de%20bases%20de%20datos%20en%20MySQL.sh

### Database Backup Program (examples)
* https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/

-----------------

# PowerShell

## Ejercicio sobre copias de seguridad con integridad: comprobar que los ficheros que tengo en una carpeta son correctos en la copia de seguridad mediante la integridad

```PowerShell
# Ideas

# Probar la integridad de las copias de seguridad:
# - Crear un plan de pruebas. 
# - Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
# - Comprobar si los tiempos de restauración son asumibles.

# Ficheros que se van a copiar
# fichero1.txt
# fichero2.txt
# fichero3.txt
# fichero4.txt

# Ficheros que tienen las integridades de los ficheros 1,2,3,4
# fichero1integridad.txt
# fichero2integridad.txt
# fichero3integridad.txt
# fichero4integridad.txt

# crear el zip 1,2,3,4

# -------------------- RECUPERACIÓN

# descomprimir zip 1,2,3,4

# ver integridad fichero que tiene los hashes 1,2,3,4

# fichero1 si abro si la integridad es correcta

"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt

# zip meter fichero1.txt más integridades.txt (se puede separar en dos archivos)

# hay fallo y tengo que recuperar la copia

# descomprimir y ver si el fichero1.txt lo puedo ver

# porque la integridad de fichero1 es correcta

# h(f1) == f1*

if((gc .\fichero1integridad.txt) -eq (Get-FileHash .\fichero1.txt).hash)
{
    "El hash coincide"
}
else
{
    "El hash no coincide"
}

# Ver si el hash coincide para todos los ficheros

mkdir ficheros
cd .\ficheros
"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt
"holas" > fichero2.txt
(Get-FileHash .\fichero2.txt).hash
(Get-FileHash .\fichero2.txt).hash > fichero2integridad.txt

# Se supone que se ha comprimido

# Hay fallo
 
# Verificar que todos los hashes son correctos

ls fichero?.txt | %{
    $ficherointeg = $_.FullName
    $ficherointeg2 = $ficherointeg.replace(".txt","")
    $ficherofinal = ([String]$ficherointeg2+"integridad.txt")

    if(((Get-FileHash $_).hash) -eq (gc $ficherofinal))
    {
        "El hash coincide"
    }
    else
    {
        "El hash no coincide"
    }
}
```
