# Administración y aseguramiento de la información:
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.

# Instalar Windows Server
* https://www.microsoft.com/es-es/evalcenter/evaluate-windows-server-2016

# RAID
* http://www.developandsys.es/aseguramiento-la-informacion/

# Repasar discos en Linux y Windows
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-17.md#comandos-para-trabajar-con-discos-en-linux
## Montar unidades en Windows
* http://www.vicente-navarro.com/blog/2010/10/28/unidades-montadas-y-enlaces-simbolicos-en-windows/

---------------------

# Administración y aseguramiento de la información:
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.
  
# Introducción a las copias de seguridad
## Incremental
* https://github.com/jesusninoc/PowerShell/blob/master/CopiasSeguridad/EjemplosCopiasSeguridad1.ps1
## Diferencial
* https://github.com/jesusninoc/PowerShell/blob/master/CopiasSeguridad/EjemplosCopiasSeguridad2.ps1
    
# PowerShell
## 10. Gestión del rendimiento en PowerShell para administradores de sistemas (nivel básico)
* https://www.jesusninoc.com/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/

## Ayuda para copias de seguridad
### Comprimir y descomprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Comprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Descomprimir
```PowerShell
Compress-Archive -LiteralPath C:\powershell\example.txt –CompressionLevel Optimal -DestinationPath C:\powershell\comprimido.zip
Expand-Archive -LiteralPath C:\powershell\comprimido.zip -DestinationPath C:\powershell\descomprimir
Compress-Archive -LiteralPath C:\powershell\example2.txt -Update -DestinationPath C:\powershell\comprimido.zip
```
### Cifrar
* https://www.jesusninoc.com/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

## Ejercicios sobre copias de seguridad
- Listar archivos por fecha
  ```PowerShell
  mkdir (Get-Date).ToString("yyyyMMdd")
  cd (Get-Date).ToString("yyyyMMdd")
  Get-ChildItem ../ *.txt | Copy-Item

  Get-ChildItem | select LastWriteTime
  Get-ChildItem ../  | where LastWriteTime -gt (Get-Date).AddDays(-1) | Copy-Item
  ```
- Crear una función que realiza una copia de seguridad en el día de hoy
  ```PowerShell
  ## ¿Qué valores necesita la función? fecha, tipo de archivo y de dónde quiero obtener los archivos
  function copiadeseguridad($fecha,$dedonde,$tipoarchivo)
  {
      mkdir $fecha -Force
      cd $fecha
      Get-ChildItem $dedonde $tipoarchivo | Copy-Item -WhatIf    
  }

  copiadeseguridad -fecha (Get-Date).ToString("yyyyMMdd") -tipoarchivo *.txt -dedonde ../
  ```
- Crear una función que realiza una copia de seguridad en el día de hoy de los archivos que se han modificado respecto del día de ayer
  ```PowerShell
  ## ¿Qué valores necesita la función? fecha de hoy, fecha de ayer, tipo de archivo y de dónde quiero obtener los archivos
  function copiadeseguridad($fechahoy,$fechaayer,$dedonde,$tipoarchivo)
  {
      mkdir $fechahoy -Force
      cd $fechahoy
      Get-ChildItem $dedonde $tipoarchivo | where LastWriteTime -gt $fechaayer | Copy-Item -WhatIf
  }

  copiadeseguridad -fechahoy (Get-Date).ToString("yyyyMMdd") -fechaayer (Get-Date).AddDays(-1) -tipoarchivo *.txt -dedonde ../
  ```
- Copia de seguridad para cada día de la semana y ser capaz de recuperar
  ```PowerShell
  # Restaurar
  mkdir tuscosasperdidas
  cd .\tuscosasperdidas
  Get-ChildItem ../ | Copy-Item
  ```
- Crear una función que realiza una restauración de una copia de seguridad
  ```PowerShell
  function restaurar($fechahoy,$donderestaurar)
  {
      cd $donderestaurar
      Get-ChildItem ("..\"+$fechahoy) | Copy-Item
  }

  restaurar -fechahoy (Get-Date).ToString("yyyyMMdd") -donderestaurar restaurar
  ```
- Ser capaz de recuperar en función de lo que pide el usuario
  ```PowerShell
  # Restaurar en función de lo que pide el usuario
  $datosusar = Read-Host "Dime el nombre del arhcivo que tengo que recuperar"
  ls $datosusar* | Copy-Item
    ```
- Comprimir las copias de seguridad que se han realizado
  ```PowerShell
  # Comprimir el directorio con la fecha
  $fecha = (Get-Date).ToString("yyyyMMdd") + ".zip"
  Compress-Archive -LiteralPath .\20181119 –CompressionLevel Optimal -DestinationPath $fecha
  Compress-Archive -LiteralPath virus.exe -Update -DestinationPath $fecha
  ```

-------------
-------------

# Administración y aseguramiento de la información:
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.

# RAID
* http://www.developandsys.es/aseguramiento-la-informacion/

## Comandos para trabajar con discos en Linux
```Bash
df -h
sudo fdisk -l /dev/sdb
sudo mkfs.vfat /dev/sdc1
sudo mkfs.ntfs /dev/sdc1
sudo mkfs.ext4 /dev/sdc1
sudo blkid
sudo mkdir mount_name
sudo mount -t auto -v /dev/sdb1 /mnt/mount_name
sudo umount /dev/sdb
```
### Borrar copias de seguridad de bases de datos en MySQL.sh
