# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# ¿Server instalado?

---------------

# Repaso
## Eliminar el contenido de las carpetas impares de un servidor web
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-05.md#eliminar-el-contenido-de-las-carpetas-impares-de-un-servidor-web-1

## Estamos viendo sistema de archivos
* https://github.com/jesnino/PowerShell/blob/master/Ficheros/EjemplosLeerOperacionesTareasBasicasII.ps1

## TAREAS BÁSICAS II (SISTEMA DE ARCHIVOS)
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

|Tarea|Cmdlet
|---|---
|Crear o modificar un archivo|New-item
|Crear un directorio|New-item
|Ver el contenido de un archivo|Get-Content
|Acceder al contenido de un directorio|Set-Location
|Listar el contenido de un directorio|Get-Childitem
|Eliminar un archivo|Remove-Item
|Eliminar un directorio|Remove-Item
|Copiar un archivo o un directorio|Copy-Item
|Mover un archivo o un directorio|Move-Item
|Renombrar un archivo o un directorio|Rename-Item
|Imprimir un archivo|Out-Printer

## Fechas
https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Fechas

## Tienen atributos que se pueden listar (show hidden files)
https://www.jesusninoc.com/2014/11/23/show-hidden-files/

## Creación de directorios
* https://github.com/jesnino/PowerShell/blob/master/Ficheros/SolucionEjerciosFicherosProcesos.ps1
* https://www.youtube.com/watch?v=CibNbK9sp8A&list=PL89qBrmFzAa34fM6OEMLV6ybDk3Y34qud&index=3

## If
* https://www.jesusninoc.com/2016/08/05/sentencia-condicional-if/
* https://www.jesusninoc.com/2015/04/26/sentencia-condicional-if-else/
* https://www.jesusninoc.com/2016/08/07/sentencia-condicional-if-elseif-else/

## BUCLE EN POWERSHELL
* https://www.jesusninoc.com/2017/10/08/listar-todos-los-caracteres-ascii-en-powershell/
* https://www.jesusninoc.com/2017/10/05/listar-todos-los-caracteres-ascii-en-bash/

---------------

# Ejercicios

## Repaso eliminar ficheros impares
```PowerShell
"hola" | out-file 2020-11-26.txt
"hola" | out-file 2020-11-25.txt

foreach($nombre in Get-ChildItem)
{
    if($nombre.Name.Split("-")[2].replace(".txt","") % 2 -eq 1)
    {
        Remove-Item $nombre -WhatIf
    }
}
```

## Repaso elminar ficheros impares (con alias de foreach: %)
```PowerShell
Get-ChildItem | %{
    if($_.Name.Split("-")[2].replace(".txt","") % 2 -eq 1)
    {
        Remove-Item $_ -WhatIf
    }
} 
```

## Crear para varios días de la semana (desde lunes pasado hasta hoy jueves) una estructura de directorios con los procesos que se están ejecutando en el sistema
```PowerShell
-3..0 | %{
    mkdir (Get-Date).AddDays($_).ToString("yyyyMMdd")
    cd (Get-Date).AddDays($_).ToString("yyyyMMdd")
    mkdir (Get-Process).Name
    cd ..
}
```

## Preguntar al usuario por la operación que quiere realizar y el nombre del fichero que sobre el que quiere realizar las siguientes operaciones que tenemos que programar son:
## - comprimir un archivo
## - descomprimir un archivo
```PowerShell
$operacion = Read-Host "Introduzca operación"
if ($operacion -eq "comprimir")
{
    $ficheroparacomprimir = Read-Host "Introduzca fichero para comprimir"
    Compress-Archive $ficheroparacomprimir -DestinationPath $ficheroparacomprimir.Replace(".txt",".zip")
}
elseif ($operacion -eq "descomprimir")
{
    $ficheroparadescomprimir = Read-Host "Introduzca fichero para descomprimir"
    Expand-Archive $ficheroparadescomprimir
}
```


## Obtener el hash de los programas que se están ejecutando en el sistema
## 1. Obtener la ruta de los programas que se están ejecutando
## 2. Hacer el hash a esos programas
```PowerShell
foreach($ruta in (Get-Process))
{
    $ruta.name
    Get-FileHash $ruta.Path
}
```

## Realizar tareas leyendo de un fichero
```PowerShell
#Añadir operaciones al fichero
"fecha" | Out-File operaciones.txt -Append
"hilos" | Out-File operaciones.txt -Append
"crear" | Out-File operaciones.txt -Append
"imprimir" | Out-File operaciones.txt -Append
"comprimir" | Out-File operaciones.txt -Append

gc .\operaciones.txt

foreach($operaciones in gc .\operaciones.txt)
{
    switch($operaciones)
    {
        "fecha"{get-date}
        "hilos"{Get-Process | select Threads}
        "crear"{New-Item -Name elque -ItemType File}
        "imprimir"{echo "hola" | Out-Printer "Microsoft Print to PDF"}
        "comprimir"{Compress-Archive -LiteralPath .\123-11.txt –CompressionLevel Optimal -DestinationPath 123.zip}
    }
}
```

---------------

# Permisos en PowerShell
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos-2
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-26.md
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

---------------

# Permisos en Linux
## Permisos especiales en Linux
http://rm-rf.es/permisos-especiales-setuid-setgid-sticky-bit/

|Permiso|Explicación
|---|---
|- - - - - - - - -	= 0|Predeterminado, sin permisos especiales. No se requiere indicar.
|- - - - - - - - t	= 1|Bit de persistencia, sticky bit
|- - - - - s - - -	= 2|Bit sgid de grupo
|- - - - - s - - t	= 3|Bit sgid y sticky
|- - s - - - - - -	= 4|Bit suid
|- - s - - - - - t	= 5|Bit suid y sticky
|- - s - - s - - -	= 6|Bit suid y sgid
|- - s - - s - - t	= 7|Bit suid, sgid y sticky

- sticky: se utiliza para permitir que cualquiera pueda escribir y modificar sobre un archivo o directorio, pero que solo su propietario o root pueda eliminarlo. 
- suid: el bit SUID activo en un archivo significa que el que lo ejecute va a tener los mismos permisos que el que creó el archivo.
- sgid: el SGID es lo mismo que en el SUID, pero a nivel de grupo. Es decir, todo archivo que tenga activo el SGID, al ser ejecutado, tendrá los privilegios del grupo al que pertenece.

## Permisos en Linux (EJERCICOS AVANZADOS SOBRE PERMISOS)

### Permisos en Linux avanzados
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

### Asignar permisos mediante llamada a sistema chmod en C
* https://www.jesusninoc.com/2014/12/01/chmod-system-call-example/

--------------
--------------

# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Discos
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-04.md

---------------

# Clase especial
## ESCANEAR FRECUENCIAS Y CLASIFICAR LAS SEÑALES ENCONTRADAS
* https://www.jesusninoc.com/01/10/escanear-frecuencias-y-clasificar-las-senales-encontradas/
## DETECTAR MICRÓFONO ESPÍA CON CNN-RTLSDR (DEEP LEARNING SIGNAL CLASSIFICATION USING RTL-SDR DONGLE)
* https://www.jesusninoc.com/01/23/detectar-microfono-espia-con-cnn-rtlsdr-deep-learning-signal-classification-using-rtl-sdr-dongle/

---------------------

# Clase especial
## Instalar Icecast is free server software for streaming multimedia
```Bash
sudo apt-get install icecast2 darkice
```
## Descargar un mp4 y un mp3 en la carpeta /usr/share/icecast2/web
```Bash
wget https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3
```
## Reproducir ficheros desde el móvil
http://192.168.1.162:8000/sound.mp3
## Número de hilos que ejecuta Icecast
https://github.com/jesnino/Bash/blob/master/Procesos/EjerciciosHilos.sh

----------------------
----------------------

# Multimedia
## Leer palabras mediante la voz del Sistema Operativo
https://www.jesusninoc.com/2016/12/15/leer-palabras-mediante-la-voz-del-sistema-operativo/

## Leer palabras de un fichero y almacenar cada palabra en un fichero de audio mediante la voz del Sistema Operativo
https://www.jesusninoc.com/2016/12/24/leer-palabras-de-un-fichero-y-almacenar-cada-palabra-en-un-fichero-de-audio-mediante-la-voz-del-sistema-operativo/

## Convertir ficheros de audio a texto
https://www.jesusninoc.com/2016/12/25/convertir-ficheros-de-audio-a-texto/

## Convertir la entrada de micrófono a texto
https://www.jesusninoc.com/2016/12/26/convertir-la-entrada-de-microfono-a-texto/

--------------------

# Radio
## Ejercicios sobre señales de radio

[![Enviar señales de radio desde Raspberry Pi mediante una conexión SSH desde PowerShell
](https://img.youtube.com/vi/8kglbrLWHrY/0.jpg)](https://www.youtube.com/watch?v=8kglbrLWHrY)

## Enlaces importantes:
* Software-Defined Radio for Engineers https://news.ycombinator.com/item?id=17399554
* https://www.youtube.com/watch?v=8kglbrLWHrY
* https://github.com/markondej/fm_transmitter
* https://www.jesusninoc.com/2016/12/07/ejercicios-de-powershell-dividir-el-contenido-de-una-frase-en-palabras-y-guardar-cada-palabra-en-un-fichero/
* https://www.jesusninoc.com/2016/12/24/leer-palabras-de-un-fichero-y-almacenar-cada-palabra-en-un-fichero-de-audio-mediante-la-voz-del-sistema-operativo/
* https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/09/26/ejecutar-un-script-de-powershell-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/
* https://www.jesusninoc.com/2017/10/14/ejecutar-airodump-ng-en-linux-realizando-una-conexion-ssh-desde-powershell-en-windows/
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjemplosDescomprimir.sh

## Crear un audio que vamos a mandar mediante señales de radio

```PowerShell
#Convertir una frase en audio con la voz del sistema operativo desde PowerShell

Add-Type -AssemblyName System.Speech
$synthesizer = New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer
$synthesizer.SetOutputToWaveFile("saludo.wav")
$synthesizer.Speak("Hola amigo Pedro")
$synthesizer.SetOutputToDefaultAudioDevice()
Get-ChildItem .\saludo.wav
```

## Subir el audio a Raspberry Pi realizando una conexión SCP
```PowerShell
#Iniciar una sesión SCP
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList "pi", $Pass

#Para configurar Set-SCPFile
#Indicar el fichero que vamos a subir -LocalFile
#Indicar el equipo al que nos vamos a conectar -ComputerName
#Indicar la ruta en la que vamos a subir el audio -RemotePath
#Forzar la conexión para evitar fallo "Key exchange negotiation failed."
#Indicar los credenciales que hemos creado anteriormente

Set-SCPFile -LocalFile .\saludo.wav -ComputerName 192.168.1.161 -RemotePath ./fmm/fm_transmitter-master -Force -Credential $Credential
```

## Enviar mediante señales de radio el fichero que hemos subido
```PowerShell
#Ejecutar fm_transmitter (use Raspberry Pi as FM transmitter)

#Iniciar una sesión SSH
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$sUser = "pi"
$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList $sUser, $Pass
$oSessionSSH = New-SSHSession -ComputerName 192.168.1.161 -Force -Credential $Credential

#Crear canal de comunicación entre PowerShell y Linux (Raspberry Pi)
#Convertirse en sudo para ejecutar fm_transmitter

$stream = $oSessionSSH.Session.CreateShellStream("PS-SSH", 0, 0, 0, 0, 1000)
Invoke-SSHStreamExpectSecureAction -ShellStream $stream -Command "sudo su -" -ExpectString "[sudo] password for $($sUser):" -SecureAction $Pass

#Transmitir por radio en la frecuencia 90 MHz el saludo creado anteriormente
$stream.WriteLine("/home/pi/fmm/fm_transmitter-master/fm_transmitter -f 90 /home/pi/fmm/fm_transmitter-master/saludo.wav")

#Verificar que llega bien la señal desde SDR o desde una radio FM en la frecuencia 90 MHz
```

--------------------

# Realizar una comunicación enviando preguntas y respondiendo de forma automática

## Teniendo en cuenta la idea de comunicar dos ordenadores mediante la voz del sistema operativo
https://www.jesusninoc.com/2016/01/10/comunicar-dos-ordenadores-mediante-la-voz-del-sistema-operativo/

## ENVIAR PREGUNTAS
```PowerShell
#Leer el texto contenido dentro de un fichero mediante la voz del Sistema Operativo
Add-Type -AssemblyName System.Speech

#Añadir textos para que se lean
"¿Qué tal?" | Out-File conversacion.txt
"¿Cuántos años tienes?" | Out-File conversacion.txt -Append
"¿Tienes novia?" | Out-File conversacion.txt -Append

#Leer los textos mediante la voz del Sistema Operativo
gc conversacion.txt | %{
$_
(New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer).Speak($_)
Start-Sleep -Seconds 3
}
```

## RECONOCIMIENTO Y RESPUESTA
```PowerShell
#Crear objeto para reconocimiento
Add-Type -AssemblyName System.Speech
$rec = New-Object 'System.Speech.Recognition.SpeechRecognitionEngine'
$rec.LoadGrammar((New-Object 'System.Speech.Recognition.DictationGrammar'))
$rec.SetInputToDefaultAudioDevice()

#Añadir posibles respuestas
"tal|Bien y tú?" | Out-File frases.txt
"años|40" | Out-File frases.txt -Append
"novia|Sí" | Out-File frases.txt -Append
"novio|Sí" | Out-File frases.txt -Append

#Crear un ArrayList con las respuestas
[System.Collections.ArrayList]$arraylist = New-Object System.Collections.ArrayList
ForEach ($elemento in (gc .\frases.txt).split("|")){[void]$arraylist.Add($elemento)}

#Función para comprobar si el mensaje que llega está entre las posibles respuestas
#La función responde mediante la voz del Sistema Operativo
function comprobar($frase){
    [System.Collections.ArrayList]$arraylist2 = New-Object System.Collections.ArrayList
    ForEach ($elemento in $frase.split(" ")){[void]$arraylist2.Add($elemento)}

    $arraylist2 | %{
        if($arraylist.IndexOf($_) -ne -1){
            (New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer).Speak($arraylist[($arraylist.IndexOf($_))+1])
        }
    }
}

#Comenzar a reconocer los audios que vayan llegando y comprobar qué mensajes llegan
do{
$mensaje=$rec.Recognize().Text
$mensaje
comprobar $mensaje
}while(1)
```

--------------------

# Motor de síntesis de voz en PowerShell

## Realizar: 
- Pronunciar un texto mediante el motor de síntesis de voz en PowerShell
- Pronunciar un texto cambiando la voz del motor de síntesis de voz en PowerShell
- Guardar en un fichero de audio un texto pronunciado mediante el motor de síntesis de voz en PowerShell

## Vídeo en Youtube
https://www.youtube.com/watch?v=eFqCh7JR5rc&list=UUNQh1Ef6VUqRzejB5lrTc0Q&index=16

[![Utilizar el motor de síntesis de voz en Powershell para leer cualquier texto
](https://img.youtube.com/vi/eFqCh7JR5rc/0.jpg)](https://www.youtube.com/watch?v=eFqCh7JR5rc)

## Pronunciar un texto mediante el motor de síntesis de voz en PowerShell
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz
$speaker = [System.Speech.Synthesis.SpeechSynthesizer]::new()

#Obtener información sobre la voz actual del motor de síntesis de voz
$speaker.Voice

#Pronunciar el texto
$speaker.Speak("Hola, hola. ¿Qué tal estás?. ¿Qué edad tienes?.")
```

## Pronunciar un texto cambiando la voz del motor de síntesis de voz en PowerShell
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz
$speaker = [System.Speech.Synthesis.SpeechSynthesizer]::new()

#Cambiar la voz actual del motor de síntesis de voz
$speaker.SelectVoice("Microsoft Helena Desktop")

#Pronunciar el texto
$speaker.Speak("Hola, hola. ¿Qué tal estás?. ¿Qué edad tienes?.")
```

## Guardar en un fichero de audio un texto pronunciado mediante el motor de síntesis de voz en PowerShell
```PowerShell
#Cargar el espacio de nombres System.Speech que contiene los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz
$speaker = [System.Speech.Synthesis.SpeechSynthesizer]::new()

#Configurar el motor de síntesis de voz para guardar en un fichero de audio
$speaker.SetOutputToWaveFile("saludos.wav")

#Pronunciar el texto
$speaker.Speak("Hola, hola. ¿Qué tal estás?. ¿Qué edad tienes?.")

#Configurar el motor de síntesis de voz para enviar el resultado en el dispositivo de audio predeterminado
$speaker.SetOutputToDefaultAudioDevice()

.\saludos.wav
```

--------------------

# Reconocimiento mediante el motor de síntesis

## Realizar: 
1. Reconocer una palabra con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para el dictado de texto sin formato
2. Reconocer una palabra contenida en un fichero de audio con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para texto sin formato
3. Reconocer varias palabras con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para el dictado de texto sin formato
4. Reconocer varias palabras contenidas en un fichero de audio con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para texto sin formato
5. Reconocer varias palabras contenidas en un fichero de audio con el motor de síntesis de voz en PowerShell creando las restricciones de una gramática de reconocimiento de voz

## Vídeo en Youtube
https://www.youtube.com/watch?v=z2PHuFKBjfU

[![Utilizar el motor de síntesis de voz en Powershell para analizar audios con voz](https://img.youtube.com/vi/z2PHuFKBjfU/0.jpg)](https://www.youtube.com/watch?v=z2PHuFKBjfU)

## 1. Reconocer una palabra con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para el dictado de texto sin formato
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Representar una gramática de reconocimiento de voz utilizada para el dictado de texto sin formato
$speechRecogEng.LoadGrammar([System.Speech.Recognition.DictationGrammar]::new())

#Configurar el motor de síntesis de voz para recibir la entrada desde el dispositivo de audio predeterminado
$speechRecogEng.SetInputToDefaultAudioDevice()

#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
```

## 2. Reconocer una palabra contenida en un fichero de audio con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para texto sin formato
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Representar una gramática de reconocimiento de voz utilizada para el dictado de texto sin formato
$speechRecogEng.LoadGrammar([System.Speech.Recognition.DictationGrammar]::new())

#Configurar el motor de síntesis de voz para recibir la entrada desde un archivo de formato de sonido (.wav)
$speechRecogEng.SetInputToWaveFile(".\holas.wav")

#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
```

## 3. Reconocer varias palabras con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para el dictado de texto sin formato
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Representar una gramática de reconocimiento de voz utilizada para el dictado de texto sin formato
$speechRecogEng.LoadGrammar([System.Speech.Recognition.DictationGrammar]::new())

#Configurar el motor de sínteris de voz para recibir la entrada desde el dispositivo de audio predeterminado
$speechRecogEng.SetInputToDefaultAudioDevice()

do
{
#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
#Mientras que haya audio
}while($speechRecogEng.AudioFormat)
```

## 4. Reconocer varias palabras contenidas en un fichero de audio con el motor de síntesis de voz en PowerShell utilizando una gramática de reconocimiento de voz para texto sin formato
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Representar una gramática de reconocimiento de voz utilizada para el dictado de texto sin formato
$speechRecogEng.LoadGrammar([System.Speech.Recognition.DictationGrammar]::new())

#Configurar el motor de síntesis de voz para recibir la entrada desde un archivo de formato de sonido (.wav)
#El fichero holas2.wav contiene: "Hola, hola. ¿Qué tal estás?. ¿Qué edad tienes?."
$speechRecogEng.SetInputToWaveFile(".\holas2.wav")

do{
#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
#Mientras que haya audio
}while($speechRecogEng.AudioFormat)
```

## 5. Reconocer varias palabras contenidas en un fichero de audio con el motor de síntesis de voz en PowerShell creando las restricciones de una gramática de reconocimiento de voz
```PowerShell
#Cargar los espacios de nombres System.Speech que contienen los tipos que admiten el reconocimiento de voz
[void][System.Reflection.Assembly]::LoadWithPartialName("System.Speech")

#Crear un objeto de tipo motor de síntesis de voz que permite a PowerShell escuchar voz
$speechRecogEng = [System.Speech.Recognition.SpeechRecognitionEngine]::new()

#Crear las restricciones para una gramática de reconocimiento de voz
$speechRecogEng.LoadGrammar([System.Speech.Recognition.GrammarBuilder]::new("Hola"))
$speechRecogEng.LoadGrammar([System.Speech.Recognition.GrammarBuilder]::new("Tal"))
$speechRecogEng.LoadGrammar([System.Speech.Recognition.GrammarBuilder]::new("Edad"))

#Configurar el motor de síntesis de voz para recibir la entrada desde un archivo de formato de sonido (.wav)
$speechRecogEng.SetInputToWaveFile(".\holas2.wav")

do{
#Inicia una operación de reconocimiento de voz sincrónico
$speechRecogEng.Recognize()
Start-Sleep -Seconds 2
#Mientras que haya audio
}while($speechRecogEng.AudioFormat)
```

--------------------

# Reconocimiento

## Utilizar el motor de síntesis de voz en Powershell para analizar audios con voz comparando los resultados entre gramáticas
https://www.jesusninoc.com/2017/12/27/utilizar-el-motor-de-sintesis-de-voz-en-powershell-para-analizar-audios-con-voz-comparando-los-resultados-entre-gramaticas/

## Analizar frecuencias de audio con SDRSharp
https://www.jesusninoc.com/2016/04/29/analizar-frecuencias-de-audio-con-sdrsharp/

## Reproducir notas musicales con PowerShell
https://www.jesusninoc.com/2017/09/23/reproducir-notas-musicales-con-powershell/

## Detectar una frecuencia de sonido emitida desde un dispositivo utilizando la tarjeta de sonido y el programa SDRSharp
https://www.jesusninoc.com/2017/01/01/detectar-una-frecuencia-de-sonido-emitida-desde-un-dispositivo-utilizando-la-tarjeta-de-sonido-y-el-programa-sdrsharp/

## Analizar frecuencias de audio con SDRSharp (reconocer la palabra hola)
https://www.jesusninoc.com/2017/01/31/analizar-frecuencias-de-audio-con-sdrsharp-reconocer-la-palabra-hola/
