# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Soluciones examen simulacro (y ver funciones)
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-11-19.md#simulacro-examen-liberatorio

# Soluciones con funciones

## Información sobre servicios (pero no se obtiene información sobre procesos)
```PowerShell
(Get-Service -Name Audiosrv,CryptSvc) | select *

## Información sobre servicios (buscar dos nombres de servicios, atentos al .name)
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv")
    {
        $servicio
    }
    if($servicio.Name -eq "CryptSvc")
    {
        $servicio
    }
}
```

## Información sobre los procesos de los servicios
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv")
    {
        Get-Process -id $servicio.ProcessId
    }
    if($servicio.Name -eq "CryptSvc")
    {
        Get-Process -id $servicio.ProcessId
    }
}
```

## Información sobre los hilos de los procesos de los servicios
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv")
    {
        (Get-Process -id $servicio.ProcessId).Threads.id
        "----------------------------------"
    }
    if($servicio.Name -eq "CryptSvc")
    {
        (Get-Process -id $servicio.ProcessId).Threads.id
    }
}
```

## Juntar los dos if para obtener información sobre los servicios
```PowerShell
foreach ($servicio in Get-WmiObject -Class win32_service)
{
    if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
    {
        $servicio
    }
}
```
 
## Preguntar al usuario mediante una función por la operación que quiera realizar:
- 1. Información sobre servicio
- 2. Información sobre procesos relacionados con los servicios
- 3. Información sobre hilos relacionados con los procesos de los servicios
```PowerShell
function comprobar()
{
    $opcion = Read-Host "¿Qué información quiere obtener sobre Audiosrv y CryptSvc?"
    switch($opcion)
    {
        "1"{
            foreach ($servicio in Get-WmiObject -Class win32_service)
            {
                if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
                {
                    $servicio
                }
            }
        }
        "2"{
            foreach ($servicio in Get-WmiObject -Class win32_service)
            {
                if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
                {
                    Get-Process -id $servicio.ProcessId
                }
            }
        }
        "3"{
            foreach ($servicio in Get-WmiObject -Class win32_service)
            {
                if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
                {
                    (Get-Process -id $servicio.ProcessId).Threads.id
                }
            }
        }
    }
}

for(1)
{
    comprobar
}
```

## Función que se dedica a comprobar operaciones
```PowerShell
function comprobar($numero)
{
    foreach ($servicio in Get-WmiObject -Class win32_service)
    {
        if($servicio.Name -eq "Audiosrv" -or $servicio.Name -eq "CryptSvc")
        {
            switch($numero)
            {
                "1"{$servicio}
                "2"{Get-Process -id $servicio.ProcessId}
                "3"{(Get-Process -id $servicio.ProcessId).Threads.id}
            }
        }
    }
}
```

## Probar aleatoriamente operaciones
```PowerShell
for(1)
{
    comprobar (Get-Random(1..3))
    Start-Sleep -Seconds 5
}
```

## Probar operaciones leyendo de un fichero
```PowerShell
foreach ($operacionautomatica in gc .\operaciones.txt)
{
     comprobar $operacionautomatica
}
```

## Crear una función en la que pasas una fecha, te crea un directorio (año/mes/día) y también le pasas la palabra procesos, hilos o servicios y te crea ese contenido dentro de la carpeta que acabas de crear
```PowerShell
function pasarfecha($fecha,$palabra)
{
    mkdir $fecha.ToString("yyyyMMdd")
    cd $fecha.ToString("yyyyMMdd")
    switch($palabra)
    {
        "procesos"{Get-Process | Out-File procesos.txt}
        "servicios"{Get-Service | Out-File servicios.txt}
        "hilo"{(Get-Process).Threads.id | Out-File servicios.txt}
    }
    cd ..
}

pasarfecha (Get-Date) procesos
```

-------------

# Funciones en PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Funciones
* https://www.jesusninoc.com/10/14/funciones-con-parametros-y-sin-parametros/

## Ejemplos sobre funciones

### Mediante una función mostrar un mensaje para cada usuario y pedirle un valor
```PowerShell
function pedirymostrar($i)
{
    $valor = Read-Host ("Introduzca valor" + "usuario" + $i)
    Write-Host ("El valor es " + $valor)
}

foreach($i in 1..10)
{
    pedirymostrar $i
}
```

### Mediante una función crear una carpeta para cada proceso que se está ejecutando
```PowerShell
# mkdir (ps).Name -WhatIf

function crearcarpeta($procesos)
{
    mkdir $procesos -WhatIf
}

crearcarpeta (ps).Name
```

### Crear una función que sume dos número que pedimos al usuario
```PowerShell
function suma([Int]$valor1,[Int]$valor2)
{
    ($valor1)+($valor2)
}

$valor1 = Read-Host "Introduzca número 1"
$valor2 = Read-Host "Introduzca número 2"
suma $valor1 $valor2
```

## Ejercicios sobre funciones: mediante la utilización de funciones en PowerShell resolver las siguientes situaciones:
- Mostrar todos los procesos.
- Mostrar los X primeros procesos.
- Mostrar los X últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Mostrar los X procesos cuyo consumo (el parámetro que quieras utilizar) sea mayor que el valor que quieras monitorizar.
- Agrupar los procesos y muestra los que sean XXXXX.
- Abrir una página web las veces que quiera el usuario.
- Realizar un login.

### Función para mostrar todos los procesos
```PowerShell
function Procesos
{
Get-Process
}
Procesos
```

### Función para mostrar los X primeros procesos
```PowerShell
function ProcesosPrimeros($numero)
{
Get-Process | Select-Object -First $numero
}
ProcesosPrimeros 5
```

### Función para mostrar los X primeros procesos utilizando Mandatory
```PowerShell
function ProcesosUltimosM
{
param
(
[Parameter(Mandatory=$true)]
$numero
)
Get-Process | Select-Object -Last $numero
}
ProcesosUltimosM 5
```

### Función para mostrar los X últimos procesos
```PowerShell
function ProcesosUltimos($numero)
{
Get-Process | Select-Object -Last $numero
}
ProcesosUltimos 5
```

### Función para ordenar todos los procesos por CPU de forma descendente
```PowerShell
function ProcesosCPU
{
Get-Process | Sort-Object CPU -Descending
}
ProcesosCPU
```

### Función para mostrar los X procesos cuyo consumo (el parámetro que quieras utilizar) sea mayor que el valor que quieras monitorizar
```PowerShell
function ProcesosConsumo([String]$parametro,[Int]$valor,[Int]$numerovalores)
{
$parametro
$valor
$numerovalores
Get-Process | Where-Object $parametro -GT $valor | Select-Object -First $numerovalores
}
ProcesosConsumo CPU 30 5
```

### Función para agrupa los procesos y muestra los que sean XXXXX
```PowerShell
function ProcesoConcreto($nombreproceso)
{
Get-Process -Name $nombreproceso | Group-Object
}
ProcesoConcreto svchost
```

### Abrir una página web las veces que quiera el usuario
```PowerShell
function abrirweb ($numero,$url)
{
    1..$numero | %{
        start $url
        [System.Console]::Beep(261,500)
    }
}

abrirweb 3 http://www.jesusninoc.com
```

### Realizar un login mediante una función
```PowerShell
#Login de user y pass
#El user y pass correcto se escriben en el bloque BEGIN
#Ejecutar la función: login0
login0 -User jaime -Pass hola

function login0
{
  param([Parameter(Mandatory=$true, ValueFromPipeline=$true)][String[]][AllowEmptyString()]$User,$Pass)

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="user"
    $passcorrecto="pass"
  }

  process
  {
   if($User -eq $usercorrecto -and $Pass -eq $passcorrecto)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
        $User,$Pass | Out-File log.txt -Append
    }
    Write-Host "Fin de login"
  }
}
```

---------------

# Instalar un Windows Server
- Volumen
- RAID

---------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

## Ejercicios propuestos con ficheros y directorios (Bash)

- Asignar permisos para una carpeta para cada usuario
- Asignar permisos para un fichero para cada usuario
- Asignar permisos para una carpeta para cada grupo
- Asignar permisos para un fichero para cada grupo

## Script con tareas sobre permisos (script.sh)

- Crear un directorio (directorio) y un fichero (fichero)
```Bash
    mkdir directorio
    touch fichero
```
- Asignar permisos a directorio y fichero iniciales
```Bash
    chmod 611 directorio -> chmod u=rw,go=x directorio
    chmod 611 fichero -> chmod u=rw,go=x fichero
```
- Asignar permisos a directorio y fichero de cambio
```Bash
    chmod 742 directorio
    chmod 742 fichero
```
- Cambiar el usuario dueño del fichero
```Bash
    chown root fichero
```
- Cambiar el grupo dueño del directorio
```Bash
    chgrp root directorio
```

---------------

# Ejercicio PowerShell

## Ejercicio con if UN NÚMERO ES PAR O IMPAR POWERSHELL

### Un número es par?, si el resto es 0. La operación del resto es %
```PowerShell
$numero=5
$numero%2
```

### Comprobar si un número es par
```PowerShell
$numero=5
if($numero%2 -eq 0)
{
"Número par"
}
else
{
"Número impar"
}
```

### Mover a una carpeta los ficheros pares y borrar los ficheros impares
```PowwerShell
-2..-8 | % {ni ((Get-Date).AddDays($_).ToString("yyyyMMdd")+".txt")}
```

## Eliminar el contenido de las carpetas impares de un servidor web
```PowerShell
# Crear un fichero dentro de todos los directorios
-2..-8 | % {mkdir (Get-Date).AddDays($_).ToString("yyyyMM-dd")}
ni -Path (ls).name -Name fichero -ItemType File

(ls | select name).name | %{
    $resultado = $_.split("-")[1] % 2
    if ($resultado -eq 1)
    {
        cd $_
        rm * -WhatIf
    }
    else
    {

    }
}
```

# Ejercicio Bash

## Eliminar el contenido de las carpetas impares de un servidor web
```Bash
echo "hola" > 201811-7
echo "hola" > 201811-8
echo "hola" > 201811-9

for i in $( ls *-? ); do
    echo "---------"
    resultado=`echo $i | cut -d "-" -f2`
    let result=resultado%2
    echo $result
    if [ $result -eq 1 ]; then
        echo "mover"
    fi
done
```

--------------------

# Linux

## Compressing files
* https://www.cyberciti.biz/howto/question/general/compress-file-unix-linux-cheat-sheet.php

## Sumar en Linux
* https://uniwebsidad.com/foro/pregunta/300/como-se-pueden-sumar-dos-numeros-en-un-script-de-bash/

## Crear calendario en Linux
* https://www.youtube.com/watch?v=aDCfL9Pk3TQ&feature=youtu.be
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjercicioCalendario.sh

## Ejemplos en Bash (con repaso sobre comandos)

### Crea  directorios con los años desde 2020 hasta 2030
```Bash
mkdir {2020..2030}
```

### En cada uno de los directorios, crea un subdirectorio con los meses del año
```Bash
mkdir -p {2020..2030}/{Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre}
```

### En cada mes, crear un directorio con cada día de la semana
```Bash
mkdir -p {2020..2030}/{Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre}/{Lunes, Martes,Miercoles,Jueves,Viernes,Sabado,Domingo}
```

### Borrar todos los directorios Julio y Agosto de todos los años
```Bash
rm -r {2020..2030}/{Julio,Agosto}
```

### Crear un alias del comando "rm" que se llame borrar y que permita borrar el directorio Ejercicio1 (con su contenido)
```Bash
alias borrar='rm -r -f ejercicio1'
```
