# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Examen if y foreach
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-11-05.md#examen-de-noviembre

---------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

## Ejercicios propuestos con ficheros y directorios (Bash)

- Asignar permisos para una carpeta para cada usuario
- Asignar permisos para un fichero para cada usuario
- Asignar permisos para una carpeta para cada grupo
- Asignar permisos para un fichero para cada grupo

## Script con tareas sobre permisos (script.sh)

- Crear un directorio (directorio) y un fichero (fichero)
```Bash
    mkdir directorio
    touch fichero
```
- Asignar permisos a directorio y fichero iniciales
```Bash
    chmod 611 directorio -> chmod u=rw,go=x directorio
    chmod 611 fichero -> chmod u=rw,go=x fichero
```
- Asignar permisos a directorio y fichero de cambio
```Bash
    chmod 742 directorio
    chmod 742 fichero
```
- Cambiar el usuario dueño del fichero
```Bash
    chown root fichero
```
- Cambiar el grupo dueño del directorio
```Bash
    chgrp root directorio
```

-------------

# Ejerecicio repaso de PowerShell
## Crear un estructura de directorios con la fecha de hoy y en cada directorio meter información sobre hilos (relación con el proceso)

### Ayuda
```PowerShell

mkdir 20191029
cd 20191029

mkdir (Get-Process).Name

foreach($proceso in (Get-Process).Name)
{
    cd $proceso
    (Get-Process -Name $proceso).Threads > informacion.txt
    cd ..
}
```

### Solución
```PowerShell
mkdir (Get-Process).id -Force

(Get-Process -Id 4).Threads.id

foreach($procesos in (Get-Process).id)
{
    cd $procesos
    (Get-Process -id $procesos).Threads >> info.txt
    cd ..
}
```

## Crear dos ficheros y mostrar el nombre sin la extensión
```PowerShell
"fichero" > 123-10.txt
"fichero" > 123-11.txt
 
Get-ChildItem 123*.txt
foreach($elementos in (Get-ChildItem 123-??.txt).name)
{
    $elementos.Split("-")[1].replace(".txt","")
}
```

## Crear una carpeta por cada servicio
```PowerShell
mkdir (Get-Service).Name -WhatIf
```

## Trabajar con fechas
```PowerShell
$mes = (get-date).Month
$ano = (get-date).year
$dia = (get-date).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (día anterior)
```PowerShell
$mes = (get-date).AddDays(-1).Month
$ano = (get-date).AddDays(-1).Year
$dia = (get-date).AddDays(-1).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (listar varios días)
```PowerShell
-1..-7
 
foreach($dias in (-1..-7))
{
    $dias
}
 
foreach($dias in (-1..-7))
{
    (Get-Date).AddDays($dias)
}
 
foreach($dias in (-1..-7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
}
```

## Hay un proceso que falla, revisad la información sobre servicios, procesos e hilos durante una semana (creando ficheros de registro varias veces al día)
 
### Parte 1
### -Crear la carpeta para cada día y para varios momentos del día

#### Solución rara (o no), calculando el número de horas
```PowerShell
foreach($dias in (1..168))
{
    $mes = (get-date).AddHours($dias).Month
    $ano = (get-date).AddHours($dias).Year
    $dia = (get-date).AddHours($dias).Day
    $horas = (get-date).AddHours($dias).Hour
    mkdir $ano$mes$dia$horas -WhatIf
}
```
#### Solución medio buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    foreach($horas in 0..23)
    {
        mkdir $ano$mes$dia$horas -WhatIf
    }
}
```
#### Solución bastante buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
   
    foreach($horas in 0..23)
    {
        $ruta = [String]$ano+[String]$mes+[String]$dia
        $ruta
        New-Item -Name $horas -Path $ruta -ItemType Directory -WhatIf
    }
}
```
#### Solución mucha locura
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta0 = $ano+"\"+$mes+"\"+$dia
    mkdir $ruta0 -WhatIf
   
    foreach($horas in 0..23)
    {
        New-Item -Name $horas -Path $ruta0 -ItemType Directory -WhatIf
    }
}
```

### Parte 2
#### -Listar procesos
#### -Listar hilos
#### -Listar servicios

#### Solución que se ejecuta durante una semana (168 horas)
```PowerShell
foreach($veces in 168)
{
    $fecha = (Get-Date).ToString("yyyy\\MM\\dd")
    mkdir $fecha -Force
 
    $hora = (Get-Date).Hour
    New-Item -Name $hora -Path $fecha -ItemType Directory -Force
 
    (Get-Process).Name > ([String]($fecha+"\"+$hora+"\procesos.txt"))
    (Get-Service).Name > ([String]($fecha+"\"+$hora+"\servicios.txt"))
    (Get-Process).Threads > ([String]($fecha+"\"+$hora+"\hilos.txt"))
 
    Start-Sleep -Seconds 3600
}
```

#### Solución de Daniel Cebrián
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta = $ano+"\"+$mes+"\"+$dia

    mkdir $ruta -Force

    foreach($horas in 0..23)
    {   
        New-Item -Name $horas -Path $ruta -ItemType Directory -Force
        [String]$procesos = (gps).name
        [String]$ruta1= ($ruta+"\"+$horas)
        New-Item -Name procesos.txt -Path $ruta1 -ItemType File -value $procesos -Force
    }
}
```
