# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.

---------------

# Linux

## A First Script
* https://www.shellscript.sh/first.html

## Ejercicios con ficheros y directorios (Bash)

```Bash
#Crear o modificar un archivo
vi nombre
```
```Bash
#Crear un directorio
mkdir
```
```Bash
#Ver el contenido de un archivo
cat
```
```Bash
#Acceder al contenido de un directorio
cd
```
```Bash
#Listar el contenido de un directorio
ls
```
```Bash
#Ver la estructura de un directorio
tree
```
```Bash
#Eliminar un archivo
rm
```
```Bash
#Eliminar un directorio
rmdir
```
```Bash
#Copiar un archivo o un directorio
cp
```
```Bash
#Mover un archivo o un directorio
mv
```
```Bash
#Renombrar un archivo o un directorio
mv
```
```Bash
#Establecer permisos en un archivo o un directorio
chmod
```
```Bash
#Comprimir y descomprimir un archivo o un directorio
gzip
```
```Bash
#Imprimir un archivo
lpr
```

## Ejercicios propuestos con ficheros y directorios (Bash)

- Crear un directorio para cada usuario
- Crear un fichero para cada usuario
- Añadir contenido a cada fichero creado para cada usuario
- Eliminar un directorio
- Renombrar un directorio
- Mover archivos de una carpeta a otra

## Ejercicios resueltos con ficheros y directorios (Bash)

1. Crear fichero que tenga tu nombre
```Bash	
 	echo Alejandro > fichero.txt
	#-------------------------
	who | awk '{print $1}' > fichero.txt
```
2. Ver el contenido de un fichero cuyo nombre esta guardado en otro fichero
```Bash
	cat `cat fichero.txt`
	#--------------------
	fich1= cat fichero
	cat $fich1
```
3. Listar contenido de un directorio y almacenarlo en un fichero
```Bash	
	ls directorio > listaDeDirectorio.txt
	cat listadeDirectorio.txt
```
4. Eliminar un fichero leyendo el nombre de este desde otro fichero
```Bash
	echo fichero1.txt > fichero2.txt

	rm `cat ficher2.txt`
	#------------------------------
	fic=cat ficher2.txt
	rm $fic
```
5. Eliminar directorio leyendo el nombre desde este desde otro fichero.	
```Bash
	echo directorio > fichero.txt
	
	mkdir `cat fichero.txt`
	
	rm -r `cat fichero.txt`
	#------------------------------
	direc=cat fichero.txt
	
	mkdir $direc
	rm -r $direc
```
6. Comprimir un directorio
```Bash
	gzip fichero
```

------------------

# Ejercicios resueltos con ficheros y directorios (PowerShell)

## Crear directorios con los meses del año
```PowerShell
foreach($mes in 1..12)
{
    mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes) -WhatIf
}
```

## Crear directorios con los años desde 2020 hasta 2030 (opción 1)
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio) -WhatIf
}
```

## Crear directorios con los años desde 2020 hasta 2030 (opción 2)
```PowerShell
mkdir (2020..2030) -WhatIf
```

## Crear directorios con los años desde 2020 hasta 2030 (opción 3)
```PowerShell
foreach($anio in 1..10)
{
    (Get-Date).AddYears($anio).Year
}
```

## En cada uno de los directorios anteriores, crea un subdirectorio con los meses del año
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
    }
    cd ..
}
```

## En cada mes, crear un directorio con cada día del mes
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
        cd $mes
        1..31 | %{mkdir $_}
        cd ..
    }
    cd ..
}
```

## Trabajar con fechas
```PowerShell
$mes = (get-date).Month
$ano = (get-date).year
$dia = (get-date).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (día anterior)
```PowerShell
$mes = (get-date).AddDays(-1).Month
$ano = (get-date).AddDays(-1).Year
$dia = (get-date).AddDays(-1).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (listar varios días)
```PowerShell
-1..-7
 
foreach($dias in (-1..-7))
{
    $dias
}
 
foreach($dias in (-1..-7))
{
    (Get-Date).AddDays($dias)
}
 
foreach($dias in (-1..-7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
}
```

## Hay un proceso que falla, revisad la información sobre servicios, procesos e hilos durante una semana (creando ficheros de registro varias veces al día)
 
### Parte 1
### -Crear la carpeta para cada día y para varios momentos del día

#### Solución rara (o no), calculando el número de horas
```PowerShell
foreach($dias in (1..168))
{
    $mes = (get-date).AddHours($dias).Month
    $ano = (get-date).AddHours($dias).Year
    $dia = (get-date).AddHours($dias).Day
    $horas = (get-date).AddHours($dias).Hour
    mkdir $ano$mes$dia$horas -WhatIf
}
```
#### Solución medio buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    foreach($horas in 0..23)
    {
        mkdir $ano$mes$dia$horas -WhatIf
    }
}
```
#### Solución bastante buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
   
    foreach($horas in 0..23)
    {
        $ruta = [String]$ano+[String]$mes+[String]$dia
        $ruta
        New-Item -Name $horas -Path $ruta -ItemType Directory -WhatIf
    }
}
```
#### Solución mucha locura
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta0 = $ano+"\"+$mes+"\"+$dia
    mkdir $ruta0 -WhatIf
   
    foreach($horas in 0..23)
    {
        New-Item -Name $horas -Path $ruta0 -ItemType Directory -WhatIf
    }
}
```

### Parte 2
#### -Listar procesos
#### -Listar hilos
#### -Listar servicios

#### Solución que se ejecuta durante una semana (168 horas)
```PowerShell
foreach($veces in 168)
{
    $fecha = (Get-Date).ToString("yyyy\\MM\\dd")
    mkdir $fecha -Force
 
    $hora = (Get-Date).Hour
    New-Item -Name $hora -Path $fecha -ItemType Directory -Force
 
    (Get-Process).Name > ([String]($fecha+"\"+$hora+"\procesos.txt"))
    (Get-Service).Name > ([String]($fecha+"\"+$hora+"\servicios.txt"))
    (Get-Process).Threads > ([String]($fecha+"\"+$hora+"\hilos.txt"))
 
    Start-Sleep -Seconds 3600
}
```

#### Solución de Daniel Cebrián
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta = $ano+"\"+$mes+"\"+$dia

    mkdir $ruta -Force

    foreach($horas in 0..23)
    {   
        New-Item -Name $horas -Path $ruta -ItemType Directory -Force
        [String]$procesos = (gps).name
        [String]$ruta1= ($ruta+"\"+$horas)
        New-Item -Name procesos.txt -Path $ruta1 -ItemType File -value $procesos -Force
    }
}
```
