# Instalación de software libre y propietario

- Instalación/desinstalación de aplicaciones. Requisitos hardware y software, versiones y licencias.
- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
  
----------------

# PowerShell

## Bucle foreach PowerShell
https://www.jesusninoc.com/2015/09/29/bucles/

## Operadores de comparación en PowerShell
If you are used to operators such as > or < or =, you have to do some rethinking. As with batch scripts, PowerShell uses abbreviations of the corresponding English words.

|Op|Description
|---|---
|eq|Equal
|ne|Not equal
|lt|Less than
|le|Less than or equal
|gt|Greater than
|ge|Greater than or equal


## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/

## Bucle en Linux
Example C for loop syntax
```Bash
for (( i=1; i <= 10; i++ ))
do
echo "Number $i"
done
```

# Ejecutar comandos en PowerShell y Bash
## Bash
```Bash
echo ps
echo 'ps'
echo `ps`
```
## PowerShell
```PowerShell
$hola="Get-Process -Name notepad"
Invoke-Expression ($hola)
```

## Mezcla de comandos entre PowerShell y Bash
```PowerShell
for($i=1;$i -le 5;$i=$i+1)
{
    $multi=($i*100) 
    $nombre="fichero$i"
    $resultado=Invoke-SSHCommand -Index 0 ('echo' + $multi + ' >' + $nombre)
    $resultado.Output 
}
```

----------------

# Instalar con PowerShell
https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/
```PowerShell
Install-Package -provider chocolatey -name zoomit
```

## Leer de un fichero nombres de programas e instalarlos (ejercicio)
```PowerShell
### Instalar paquetes

Find-Package -name *
Install-Package GetBIOS -WhatIf

### Añadir paquetes a un fichero

"GetBIOS" | Out-File .\programas.txt -Append
"PowerShellGet" | Out-File .\programas.txt -Append
Get-Content .\programas.txt

### Leer el fichero programas.txt (línea a línea)

foreach($programa in Get-Content .\programas.txt)
{
    Install-Package $programa -WhatIf
}
```

# Actualizar en Windows
* https://docs.microsoft.com/en-us/windows/desktop/msi/command-line-options
* https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/

## Ejercicios sobre actualizaciones en PowerShell
```PowerShell
# Ejercicios sobre actualizaciones

## ID de la actualización y descripción

Get-HotFix | select Description,HotFixID

## Agrupar actualizaciones por tipo (descripción)

Get-HotFix | Group-Object Description

## Indicar el número de actualizaciones que hay por tipo (descripción)

Get-HotFix | Group-Object Description | select name,count

## Mostrar las actualizaciones que se han instalado el mes de febrero (o la semana pasada)

Get-HotFix | select HotFixID, InstalledOn | where InstalledOn -gt (Get-Date).AddDays(-30)
```

# Instalar en Bash
* https://help.ubuntu.com/community/AptGet/Howto

# Actualizar en Linux
### This command upgrades all installed packages. This is the equivalent of "Mark all upgrades" in Synaptic.
```Bash
apt-get update & apt-get upgrade
```
### Setting up apt-get to use a http-proxy
```Bash
export http_proxy=http://yourproxyaddress:proxyport
```

----------------
----------------

# Instalación de software libre y propietario

- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.
  
------------------

# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/
### Variables 4: almacenar en fichero
https://www.jesusninoc.com/2014/10/22/variables-4-almacenar-en-fichero/
### Variables 5: leer de un fichero
https://www.jesusninoc.com/2014/10/21/variables-5-leer-de-un-fichero/
### Variables 6: etiquetas HTML
https://www.jesusninoc.com/2014/10/20/variables-6-etiquetas-html/
### Variables 7: ordenar y eliminar elementos duplicados
https://www.jesusninoc.com/2014/10/19/variables-7-ordenar-y-eliminar-elementos-duplicados-2/
### Variables 8: eliminar caracteres en blanco
https://www.jesusninoc.com/2014/10/18/variables-8-eliminar-caracteres-en-blanco/

## Bucle
Example C for loop syntax
```Bash
for (( i=1; i <= 10; i++ ))
do
echo "Number $i"
done
```

## Ejercicio: ejecutar el comando almacenado en un fichero
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosIntroducci%C3%B3n.sh

```Bash
echo "ps" > fichero
echo "ls" >> fichero
`cat fichero | head -n 1`
```

```Bash
echo "ps" > fichero
echo "ls" >> fichero

while read linea
do
echo $linea
`echo $linea` >> resultado
done < fichero

cat resultado
```

------------------

# PowerShell
## Repaso bucle ForEach
* https://github.com/jesusninoc/PowerShell/blob/master/Bucles/RepasoBucleForEach.ps1

------------------

# Linux + PowerShell

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
New-SSHSession -ComputerName 10.20.104.35 -Credential (Get-Credential)

$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

## SSH en Windows 10
* https://www.illuminiastudios.com/dev-diaries/ssh-on-windows-subsystem-for-linux/

------------------

# Examen mes de octubre (obtener información sobre hilos en Linux y PowerShell)

## Linux

### Leer nombre de proceso de un fichero y mostrar hilos
```Bash
echo "ps -fL -C @sh" > fichero
echo "ps -fL -C @sh" >> fichero

while read linea
do
echo $linea
`echo $linea | cut -d '@' -f1 ; echo $linea | cut -d '@' -f2` >> resultado
done < fichero

cat resultado
```

### Mostrar el nombre de los procesos leyendo de un fichero el identificador de proceso
```Bash
echo "323@232@8888" > fichero

while read linea
do
echo $linea
ps -f -p `echo $linea | cut -d '@' -f1` >> resultado
done < fichero

cat resultado
```

### Sacar los hilos de los procesos leyendo el nombre del proceso de un fichero
```Bash
echo "nano" > fichero
echo "sh" >> fichero

while read linea
do
echo $linea
ps -fL -C `echo $linea | cut -d '@' -f1` >> resultado
done < fichero

cat resultado
```

## PowerShell

### Leer nombre de proceso de un fichero y mostrar hilos
```PowerShell
echo "ps @notepad" > fichero
echo "ps @notepad" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    $ejecutar = $linea.split("@")[0] + $linea.split("@")[1]
    $ejecutar + " | select threads" | iex
}
```

### Mostrar el nombre de los procesos leyendo de un fichero el identificador de proceso
```PowerShell
echo "1288" > fichero
echo "1200" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    Get-Process -Id $linea | select name
}
```

### Sacar los hilos de los procesos leyendo el nombre del proceso de un fichero
```PowerShell
echo "notepad" > fichero
echo "chrome" >> fichero
Get-Content .\fichero

foreach($linea in Get-Content .\fichero)
{
    Get-Process -name $linea | select name,threads
}
```

### Analizar hilos (solución)
https://www.jesusninoc.com/02/06/analizar-hilos-con-powershell/

### Otra más
```PowerShell
# Listar identificadores de hilos
(Get-Process -name notepad | select threads).threads.id

# Listar información de un hilo en concreto
Get-WmiObject -Class win32_thread -Filter "Handle = 6248" | Out-File

# Sirve para analizar la información de hilos en función del proceso que los crea (Notepad)
(Get-Process -name notepad).id
$var=(Get-Process -name notepad).id
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"

# (Leyenda) Sirve para analizar información de hilos en función de los identificadores de cada hilo del proceso que los crea (Notepad)
$var=(Get-Process -name notepad | select threads).threads.id
$var | %{$_}
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"
$var | %{Get-WmiObject -Class win32_thread -Filter "Handle = $_"}
```

### Otra posible solución
```PowerShell
#Mostrar el proceso que creó el hilo
Get-WmiObject -Class Win32_Thread | %{
    if((Get-Process -Id $_.ProcessHandle).name -eq "notepad")
    {
        write-host $_.ProcessHandle,$_.handle
        Get-Process -Id $_.ProcessHandle | select name,id
    }
}
```

### Solución para entender la solución de Linux
```PowerShell
echo "ps@notepad" > fichero

foreach ($linea in gc fichero)
{
    $ejecutar = $linea.split("@")[0] + " -name " + $linea.split("@")[1]
    $ejecutar | iex
}
```

------------------

# Ejercicios

## Instalar un paquete MSI junto con información sobre la instalación
```PowerShell
cd ~
msiexec /i C:\Windows\Installer\42014f.msi /Liwearucmopvx log.txt
msiexec /i C:\Windows\Installer\42014f.msi /Li logi.txt
Start-Sleep -Seconds 5
msiexec /i C:\Windows\Installer\42014f.msi /Lw logw.txt
```

## Ver el número de serie de un equipo
```PowerShell
(Get-WmiObject Win32_SystemEnclosure).SerialNumber
```

## Ver controladores
```PowerShell 
gwmi Win32_USBControllerDevice |%{[wmi]($_.Dependent)} | Sort Manufacturer,Description,DeviceID | Ft -GroupBy Manufacturer Description,Service,DeviceID
 
Get-PnpDevice
```
  
## Ver actualizaciones
```PowerShell
$Sesion = New-Object -ComObject Microsoft.Update.Session
$actualizacion = $Sesion.CreateUpdateSearcher().Search("IsInstalled=1").Updates
$actualizacion | Select-Object Title
```
  
## Obtener información sobre las actualizaciones
```PowerShell
#Seleccionar los identificadores de las actualizaciones de seguridad (HotFixID)
foreach($kb in (Get-HotFix | Select-Object HotFixID))
{
[String]$texto=''

#Componer URL con el valor HotFixID
$url='https://www.bing.com/search?q='+$kb.hotfixid
#Hacer petición al buscador Bing para analizar la información sobre la actualización de seguridad
$result=Invoke-WebRequest $url

#Analizar los datos devueltos por el buscador
foreach($linea in ($result.AllElements | Where class -eq 'b_caption').outerText)
{
#Marcar en los resultados obtenidos los identificadores de las actualizaciones de seguridad (HotFixID)
#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
$linea.Split(' ') | % {
if($_ | Select-String $kb.hotfixid)
{
Write-Host $_ ' ' -BackgroundColor Cyan -ForegroundColor Blue -NoNewline
}
else
{
Write-Host $_ ' ' -NoNewline
}
}
Write-Host ' '
}
#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
}
```
