# Repaso de comunicación por red entre Windows y Linux
* https://www.jesusninoc.com/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/

# Introducción al sistema de archivos

## Ejemplos básicos sobre el sistema de archivos en PowerShell

```PowerShell
####################
# Ayuda
# Crear un fichero llamado juan que tenga el contenido del fichero la palabra hola, después mostrar el contenido
New-Item juan -ItemType File -Value "hola" -Force
Get-ChildItem juan
Get-Content juan
# Crear un directorio llamado juan2 y meterse dentro del directorio
New-Item juan2 -ItemType Directory
Set-Location juan2
####################
# Solución fácil
# Tenemos cinco usuarios
# Crear para cada uno de ellos 5 directorios
New-Item juan -ItemType Directory
New-Item juan3 -ItemType Directory
New-Item juan4 -ItemType Directory
New-Item juan6 -ItemType Directory
New-Item juan7 -ItemType Directory
# Para cada una de las carpetas que he creado meterme dentro y crear un fichero con el nombre del usuario
Set-Location juan4
New-Item juan3.txt
Set-Location ../
####################
# Solución complicada
# Tenemos cinco usuarios
# Crear para cada uno de ellos 5 directorios
# Para cada una de las carpetas que he creado meterme dentro y crear un fichero con el nombre del usuario
 
New-Item pruebas -ItemType Directory -Force
Set-Location pruebas
New-Item juan,juan3,juan7 -ItemType Directory -Force
foreach($nombre in (Get-ChildItem | select Name).name)
{
    Set-Location $nombre
    New-Item $nombre
    Set-Location ../
}
####################
# Tenemos todos los procesos del sistema operativo
# Crear para cada uno de ellos una carpeta
# Para cada una de las carpetas que se han creado meter un fichero con información del prceso
 
New-Item pruebas -ItemType Directory -Force
Set-Location pruebas
New-Item (get-Process | select name).name -ItemType Directory -Force
foreach($nombre in (Get-ChildItem | select Name).name)
{
    Set-Location $nombre
    New-Item $nombre -Value ([String](Get-Process -Name $nombre)) -Force
    Set-Location ../
}
```

## Ejercicios sobre sistemas de archivos (mezclado con procesos)
```PowerShell
# Crear tres directorios 
# Dentro de cada directorio 
# un fichero con nuestro nombre y con
# el contenido de la palabra "hola"

Set-Location ../

New-Item tx1,tx2,tx3 -ItemType file
Set-Location tx1
new-item txt1 -ItemType file -value "hola" -force
Set-Location tx1
new-item txt1 -ItemType file -value "hola" -force
Set-Location tx1
new-item txt1 -ItemType file -value "hola" -force
Get-Content .\txt1

Set-Location C:\Users\angela

New-Item alvaro -Value "hola" -ItemType File -Path .\Directorio1

New-Item -name tx1.txt -Itemtype File -Path .\Directorio1 -Value "Javier" -Force 


# Crear carpetas para tres usuarios y dentro de cada carpeta un fichero con el nombre de 
# cada usuario y con el contenido de la palabra "hola"

New-Item pruebas -ItemType Directory -Force
Set-Location pruebas
New-Item juan,juan3,juan7 -ItemType Directory -Force

foreach($nombre in (Get-ChildItem | select Name).name)
{
    Set-Location $nombre
    New-Item $nombre -Value "hola" -Force
    Set-Location ../
    Start-Sleep -Seconds 5
}


# Crear tantas carpetas como procesos se están ejecutando y dentro
# de cada carpeta guardar información del proceso (por ejemplo el 
# identificador de proceso)

(Get-Process | select name).name
Get-Process | select name,id

foreach($procesos in (Get-Process | select name).name)
{
    New-Item $procesos -ItemType Directory -Force
    Start-Sleep -Seconds 1
}


# Crear tantas carpetas como procesos se están ejecutando y dentro
# de cada carpeta guardar información del proceso (por ejemplo el 
# identificador de proceso, el nomber y el consumo de CPU)

foreach($proceso in Get-Process)
{
New-Item $proceso.name -ItemType Directory -Force
New-Item -name $proceso.name -Value ([String]$proceso.id+"------"+[String]$proceso.name+"------"+[String]$proceso.cpu) -ItemType file -path $proceso.name -Force
}

# Crear carpetas con los nombre sobre los procesos que se están ejecutando como servicios
# y almacenar el identificador de proceso y el nombre del servicio a la vez

Get-WmiObject Win32_Service | %{
    New-Item $_.name -ItemType Directory -Force

    New-Item -name $_.name -Value ([String]$_.ProcessID+[String](Get-Process -Id $_.ProcessID).name) -ItemType file -path $_.name -Force
    $_.Name,$_.ProcessID,(Get-Process -Id $_.ProcessID).name
}
```
