# Instalación de software libre y propietario

- Consideraciones previas a la instalación de sistemas operativos libres y propietarios.
  - Particionado del disco duro.
  - En sistemas Windows determinar la partición donde instalaremos el S.O.
  - En sistemas Linux determinar las particiones para los distintos puntos de montaje.
  - Controladores (drivers) de almacenamiento necesarios.
- Instalación de sistemas operativos.
  - Requisitos hardware, versiones y licencias.
  - Soporte utilizado para la instalación: CD/DVD, Pendrive, LAN.
  - Datos necesarios para la instalación: usuarios, contraseñas, nombre del equipo, direcciones IP, número de licencia, etc.

----------------

# Obtener información sobre el pocesador en PowerShell

## Información sobre el procesador
```PowerShell
Get-WmiObject Win32_Processor
Get-WmiObject -query "select * from Win32_Processor"
```
## Información sobre la arquitectura
```PowerShell
(Get-WmiObject Win32_Processor).caption
```
## Información sobre la organización
```PowerShell
(Get-WmiObject Win32_Processor).name
```
## Información sobre la realización
```PowerShell
((Get-WmiObject Win32_Processor).name).split("@")[1]
```
## Información sobre los procesadores
```PowerShell
Get-WmiObject -Class Win32_Processor | Select -Property Name, Number*
```
## Número de cores
```PowerShell
Get-WmiObject -Class Win32_Processor | Select-Object NumberOfCores
Get-WmiObject -query "select NumberOfCores from Win32_Processor"
```
## Carga del procesador
```PowerShell
Get-WmiObject win32_processor | Select-Object LoadPercentage
```
## Ejercicios
### Información sobre el procesador
```PowerShell
Get-WmiObject -class "Win32_Processor" | % {
    Write-Host "CPU ID: "
    Write-Host $_.DeviceID
    Write-Host "CPU Model: "
    Write-Host $_.Name
    Write-Host "CPU Cores: "
    Write-Host $_.NumberOfCores
    Write-Host "CPU Max Speed: "
    Write-Host $_.MaxClockSpeed
    Write-Host "CPU Status: "
    Write-Host $_.Status
    Write-Host
}
```
### Procesador es Intel o no?
```PowerShell
if((Get-WmiObject Win32_Processor).name -match "Intel"){"Intel"}else{"No es Intel"}
if((Get-WmiObject Win32_Processor).Caption -match "Intel"){"Intel"}else{"No es Intel"}
```

----------------

# Prueba detectar proceso infectado
