# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

------------------

# Hemos explicado el segundo tema del libro, en concreto, qué es el sistemas operativo, tipos de núcleos, funciones del sistemas operativo, en concreto primera parte de la gestión, gestión de procesos

# Gestión de procesos: tabla de control de procesos con información de los mismos, creación y destrucción de procesos

# Introducción a PowerShell
Dónde encontrar ayuda:
- https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/
- https://www.jesusninoc.com/2017/07/02/2-programacion-en-powershell/

# Repaso semana pasada (ejercicios sobre procesos en Powershell)
- Listar procesos por identificador de proceso.
```PowerShell
gps | select id
```
- Listar todos los procesos.
```PowerShell
gps
```
- Mostrar los 5 primeros procesos.
```PowerShell
gps | select -First 5
```
- Mostrar los 5 últimos procesos.
```PowerShell
gps | select -Last 5
```
- Ordenar todos los procesos por CPU de forma descendente.
```PowerShell
gps | select cpu,name | sort -Descending -Property cpu
```
- Agrupa los procesos y muestras los que sean svchost.
```PowerShell
gps | Select-String svchost | Group-Object svchost
```
- Ordena el consumo de CPU de forma descendente.
```PowerShell
gps | select name, cpu | sort cpu -Descending
```
- Abre 5 notepad, ordena por el consumo de CPU.
```PowerShell
1..5 | %{notepad}
gps -Name notepad | sort CPU -Descending
```
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
```PowerShell
gps | select *
```
- Obtener los 5 primeros procesos ordenados.
```PowerShell
gps | Select-Object name -First 5 | Sort-Object name
```
- Listar los procesos que tengan consumo alto de tiempo de CPU.
```PowerShell
Get-Process | select cpu,id,name | sort cpu -Descending
```
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

# Ejercicios básicos sobre procesos en Linux
- Listar procesos por propiedades.
- Listar todos los procesos.
```Bash
ps
```
- Mostrar los 5 primeros procesos.
```Bash
ps | head -n 6
```
- Mostrar los 5 últimos procesos.
```Bash
ps | tail -n 5
```
- Ordenar todos los procesos por CPU de forma descendente.
```Bash
ps | sort
```
- Agrupa los procesos y muestras los que sean svchost.
```Bash
ps -A | egrep bash
```
- Ordena el consumo de CPU de forma descendente.
```Bash
ps -A --sort=cpu
```
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
```Bash
ps -l
```
- Obtener los 5 primeros procesos ordenados.
```Bash
ps | head -n 6 | sort
```

# Ejercicios avanzados
* Convertir 1. Introducción a PowerShell (nivel intermedio) en WSL
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario
* Listar un número de procesos que introduce el usuario y ordenar los procesos por un valor que introduce el usuario y almacena en un fichero

### Ayuda:
```PowerShell
ps | sort cpu
```
```PowerShell
ps | sort cpu | select -First 5
ps | sort cpu -Descending | select -First 5
```
```PowerShell
ps | select -First 5 | sort cpu
ps | select -First 5 | sort cpu -Descending
```
```PowerShell
ps | select -First (Read-Host) | sort (Read-Host)
ps | select -First (gc numero) | sort (gc buscar)
```
```PowerShell
$guardarnumero = Read-Host "Dime número de procesos a listar"
$guardarnumero | Out-File numerodeprocesos.txt
Get-Content .\numerodeprocesos.txt

$guardarvalor = Read-Host "Dime por qué valor ordenar"
$guardarvalor | Out-File numerodevalores.txt
Get-Content .\numerodevalores.txt

Get-Process | Select-Object -First (Get-Content .\numerodeprocesos.txt) | Sort-Object (Get-Content .\numerodevalores.txt)
```

-------------------
-------------------


# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Creación y destrucción de procesos
## Creación de procesos (apartado Crear procesos)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
## Destrucción de procesos (apartado Matar procesos)
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

# Más información sobre procesos
https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/

--------------------

# Ejercicio con Base64
## Ejercicio resuelto de CREAR TABLA DE BASE64
https://www.jesusninoc.com/2017/02/11/tabla-de-caracteres-base64/

## EJECUTAR UN START-PROCESS (CREAR UN PROCESO)
```PowerShell
Start-Process -FilePath powershell.exe -ArgumentList '-encodedcommand RwBlAHQALQBQAHIAbwBjAGUAcwBzAA=='
```

## Ejecutar un cmdlet codificado en Base64
https://www.jesusninoc.com/2016/09/24/ejecutar-un-cmdlet-convertido-en-base64/

# Para repasar
- https://github.com/jesnino/PowerShell
- https://github.com/jesnino/PowerShell/tree/master/Repaso
- https://www.jesusninoc.com/2017/07/07/7-gestion-de-procesos-en-powershell/
