# Repaso clase anterior

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell (nivel intermedio)
* https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/
## Operadores de comparación
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Operaciones_de_comparacion  

# Ejercicos realizados en clase

## Información sobre procesos en ejecución

```PowerShell
# Sacar el último proceso ejecutado
Get-Process | select StartTime,name | sort StartTime

# Preguntar si aparece algo nuevo (en bucle infinito)
$algo = Get-Process | select name

for(1)
{
    $algo2 = Get-Process | select name
    Compare-Object -Property name $algo $algo2
}

# Solución acortar -first (f)
ps|sort cpu -D|select name,cpu -f 5

# Solución completa acortada
Set-Alias -Name p -value ps
Set-Alias -Name s -value select
Set-Alias -Name o -value sort
p|o cpu|s -l 5 >>1
```

## Juntar dos ficheros con información (fichero con fecha y fichero con procesos que se ejecutan):
```PowerShell
Get-Date|Out-File f.txt
Get-Process|Select-Object Name,CPU|Out-File fp.txt
$numero1 = Get-Content f.txt
$numero2 = Get-Content fp.txt
$numero1 + $numero2
```
## Ejecutar un comando que se encuentra escrito en una cadena:
```PowerShell
$var=(get-content valores.txt)
("Get-Process|Select-Object "+ $var) | iex
```
## Mostrar los procesos con un Where:
```PowerShell
(Get-Process).name | Group-Object | where name -eq svchost
```
# Ejercicios propuestos

# Abrir procesos leyendo desde un fichero (en un fichero aparece el número de veces que se abre el proceso y en otro fichero aparece el nombre del proceso que queremos abrir)
```PowerShell
"notepad" | out-file abrir.txt
5 | Out-File veces.txt
1..(gc veces.txt) | %{Start-Process (gc .\abrir.txt)}
```
# Parar el proceso leyendo desde un fichero el nombre del proceso que vamos a parar (el nombre del proceso que vamos a parar se almacena mediante un Out-File siendo el primer proceso)
```PowerShell
(Get-Process -Name notepad).name | select -First 1 | Out-File procseomatar.txt
gc .\procseomatar.txt
Stop-Process -name (gc .\procseomatar.txt)
```
