# Instalación de software libre y propietario

- Estructura de un sistema informático. Monolítica. Jerárquica. Capas o anillos (ring). Máquinas virtuales. Cliente-servidor.
- Arquitectura de un sistema operativo. Sistemas por lotes (batch). Sistemas por lotes con multiprogramación. Sistemas de tiempo compartido. Sistemas distribuidos.

# Repaso día anterior
## Concepto de núcleo
## 1. Introducción a PowerShell (nivel intermedio)
* https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/
## Ejercicio propuesto
### Comparar la ejecución de procesos en dos momentos distintos (arrancar Notepad)
* https://www.jesusninoc.com/07/01/1-introduccion-a-powershell/#Comparar

---------------------

# Instalación de software libre y propietario

- Funciones de un sistema operativo.
  - Controlar y gestionar el uso del hardware del ordenador: CPU, dispositivos de E/S, Memoria principal, tarjetas gráficas y el resto de periféricos.
  - Administrar la ejecución de los procesos. Planificación.
  - Controlar el proceso de organización de la información. Creación, acceso (ubicación física) y borrado de archivos.
  - Controlar el acceso de los programas o los usuarios a los recursos del sistema.
  - Proporcionar interfaces de usuario: en modo texto y gráficos.
  - Servicios soporte: actualizaciones de software, controladores para nuevos periféricos, etc.

# Ejercicio de almacenar en un fichero los procesos que se están ejecutando y la fecha actual

## Solución simple:
```PowerShell
Get-Date|Out-File f.txt;Get-Process|Select-Object Name,CPU|Out-File f.txt -Append
date >> f.txt;gps|select Name,CPU >> f.txt
date >> f;ps|select Name,cpu >> f
(date),(ps|select Name,cpu)>>f
```
## Solución avanzada creando alias:
```PowerShell
Set-Alias -Name d -Value date
Set-Alias -Name p -Value ps
Set-Alias -Name s -Value select
d >> f;p|s Name,CPU >> f
(d),(p|s Name,CPU)>>f
```

## Solución con ofuscación:
* https://www.jesusninoc.com/09/06/utilizar-alias-ofuscacion-en-powershell/

# Cmdlets básicos en PowerShell
## 1. Introducción a PowerShell (nivel intermedio)
* https://www.jesusninoc.com/2017/07/01/1-introduccion-a-powershell/
## Operadores de comparación
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Operaciones_de_comparacion  

# Ejercicios sencillos
## Ejercicios básicos sobre procesos
- Listar procesos por propiedades.
- Listar todos los procesos.
- Mostrar los 5 primeros procesos.
- Mostrar los 5 últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Agrupa los procesos y muestras los que sean svchost.
- Ordena el consumo de CPU de forma descendente.
- Abre 5 notepad, ordena por el consumo de CPU.
- Abre 5 notepad, utiliza y ordena por el consumo de CPU.
- Listar las propiedades cpu y PM.
- Obtener información ampliada sobre procesos.
- Obtener los 5 primeros procesos ordenados.
- Listar los procesos que tengan consumo alto de tiempo de CPU.
- Listar los procesos junto el fabricante.
- Mostrar información sobre el proceso notepad.

# Ejercicos realizados en clase

## Juntar dos ficheros con información (fichero con fecha y fichero con procesos que se ejecutan):
```PowerShell
Get-Date|Out-File f.txt
Get-Process|Select-Object Name,CPU|Out-File fp.txt
$numero1 = Get-Content f.txt
$numero2 = Get-Content fp.txt
$numero1 + $numero2
```
## Ejecutar un comando que se encuentra escrito en una cadena:
```PowerShell
$var=(get-content valores.txt)
("Get-Process|Select-Object "+ $var) | iex
```
## Mostrar los procesos con un Where:
```PowerShell
(Get-Process).name | Group-Object | where name -eq svchost
```
# Ejercicios propuestos

# Abrir procesos leyendo desde un fichero (en un fichero aparece el número de veces que se abre el proceso y en otro fichero aparece el nombre del proceso que queremos abrir)
```PowerShell
"notepad" | out-file abrir.txt
5 | Out-File veces.txt
1..(gc veces.txt) | %{Start-Process (gc .\abrir.txt)}
```
# Parar el proceso leyendo desde un fichero el nombre del proceso que vamos a parar (el nombre del proceso que vamos a parar se almacena mediante un Out-File siendo el primer proceso)
```PowerShell
(Get-Process -Name notepad).name | select -First 1 | Out-File procseomatar.txt
gc .\procseomatar.txt
Stop-Process -name (gc .\procseomatar.txt)
```
