# Directivas de seguridad y auditorías:
- Requisitos de seguridad del sistema y de los datos.
- Derechos de usuario.
- Directivas de seguridad:
  - Locales
  - Del controlador de dominio
  - Del dominio.
- Directivas de grupo:
  - Administrar la directiva basada en el Registro con las plantillas administrativas.
  - Asignar secuencias de comandos al inicio/apagado del equipo y/o al inicio/cierre de sesión.
  - Redirección de carpetas.
  - Administrar aplicaciones.
  - Especificar las opciones de seguridad.
- Orden de aplicación de las directivas.
- Conjunto resultante de directivas.
- Filtrar la directiva en función de la pertenencia a grupos de seguridad
- Opciones avanzadas en la aplicación de las directivas:
  - Bloqueo de la herencia de directivas.
  - No reemplazar y deshabilitar.
- Registro del sistema operativo.
- Objetivos de la auditoría.
- Ámbito de la auditoría. Aspectos auditables.
- Mecanismos de auditoría. Alarmas y acciones correctivas.
- Información del registro de auditoría.
- Técnicas y herramientas de auditoría.
- Configurar la auditoría: Auditar sucesos de inicio de sesión de cuenta, la administración de cuentas, el acceso del servicio de directorio, sucesos de inicio de sesión, el acceso a objetos, el cambio de directivas, uso de privilegios, el seguimiento de procesos y sucesos del sistema.
- Informes de auditoría.

--------------------------

# Auditoría

## Enumeración FileSystemRights: Define los derechos de acceso que se utilizará al crear reglas de acceso y auditoría
https://msdn.microsoft.com/es-es/library/system.security.accesscontrol.filesystemrights(v=vs.110).aspx
```PowerShell
[Enum]::GetNames([System.Security.AccessControl.FileSystemRights]) 
```

## Eventos
### 10. Gestión del rendimiento en PowerShell (nivel intermedio)
https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/
### EventLog
https://www.jesusninoc.com/eventlog/
### Saber quién inició sesión en el sistema operativo de forma detallada analizando el registro de eventos de Windows (se requieren privilegios de administrador)
https://www.jesusninoc.com/07/23/saber-quien-inicio-sesion-en-el-sistema-operativo-de-forma-detallada-analizando-el-registro-de-eventos-de-windows-se-requieren-privilegios-de-administrador/
### Windows EVTX Samples [More than 160 EVTX examples]
https://github.com/sbousseaden/EVTX-ATTACK-SAMPLES

## Auditoría de proceso de línea de comandos
https://docs.microsoft.com/es-es/windows-server/identity/ad-ds/manage/component-updates/command-line-process-auditing

--------------------

# Supervisión del rendimiento del sistema:
- Herramientas de monitorización en tiempo real.
- Herramientas de monitorización continuada.
- Herramientas de análisis del rendimiento.
- Tipos de sucesos: sucesos del sistema, sucesos de seguridad, sucesos de aplicaciones, etc.
- Registros de sucesos.
- Monitorización de sucesos.
- Gestión de aplicaciones, procesos y subprocesos.
- Monitorización de aplicaciones y procesos.
- Monitorización del rendimiento:
  - Monitor del sistema: histogramas, gráficos e informes.
  - Contadores y registros de seguimiento.
  - Programas acciones mediante las alertas. 

# Introducción

## 10. Gestión del rendimiento en PowerShell
https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

- Monitorización
- Rendimiento
- Registros del sistema
- Reparación
- Copias de seguridad
- Restauración

## Encontrarse a uno mismo
```PowerShell
Get-EventLog Security | Where-Object Message -Match "asir1joselui"
```

## Ejemplos de introducción a monitorizar
```PowerShell
# (INCORRECTO) Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
Get-CimInstance -ClassName Win32_StartupCommand  | select Caption, @{n='NombreP';e={(Get-Process -name $_.Caption | Select Name).name}}

# Comprobar que se está ejecutando un programa que se arranca al inicio del arranque del sistema operativo
Get-Process -Name MSOSYNC

# (CORRECTO 1) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

Get-Process -Name $acumul

# (CORRECTO 2) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
function comprobar($programa){
    Get-Process -Name $programa -ErrorAction Ignore
}

Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        comprobar $temperal[$temperal.Count-1]

}

# (CORRECTO 3) # Intentar relacionar los procesos con los programas que se arrancan al inicio del arranque del sistema operativo 
$acumul = Get-CimInstance -ClassName Win32_StartupCommand | select Command | %{
    
        $temperal = $_.Command.tolower().replace(".exe","€").split("€")[0].split("\")

        $temperal[$temperal.Count-1]

}

$acumul | %{
    $_
    ((Get-Process).name.toupper()).contains($_.toupper())
}
```

## Ejercicio: registrar un evento cuando se logre realizar una conexión entre un cliente y un servidor mediante UDP (almacenar la dirección IP de la conexión del cliente o del servidor)
* https://www.jesusninoc.com/05/08/ejercicios-de-powershell-registrar-un-evento-cuando-se-logre-realizar-una-conexion-entre-un-cliente-y-un-servidor-mediante-udp-almacenar-la-direccion-ip-de-la-conexion-del-cliente-o-del-servidor/

### Solución (otra forma de verlo, el cliente manda crear un log al servidor)

#### Cliente
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]"192.168.43.61",$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('Write-EventLog -LogName "Application" -Source "Microsoft-Windows-User-Loader" -EventID 916 -EntryType Information -Message "192.168.43.108" -Category 2 -RawData 10,20')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```
#### Servidor
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$udpclient.Close()
Invoke-Expression ([Text.Encoding]::ASCII.GetString($content))
```
