# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

## Tener en cuenta
 - IP fija
 - ping
 - DNS
 - EQUIPO EN DOMINIO
 - QUE SE VEA EN EL AD
 - CONFIGURAR LA DIRECTIVA
 - PROBARLO
 - gpupdate /force
 - GPRESULT /z

# Listas de control de acceso
## Permisos desde PowerShell
* https://www.jesusninoc.com/01/23/clonar-permisos-ntfs/
* https://www.jesusninoc.com/08/19/anadir-permiso-ntfs-a-una-carpeta/
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

# Ejercicios
## Ejercicios con scripts
- Crear un usuario en el AD, delegar la tarea de "Unir un equipo al dominio" a ese usuario y ejecutar el script para que el equipo se meta en el dominio (desde el equipo que queremos meter en el dominio)
  - Local
  - Remoto
    * http://community.idera.com/powershell/powertips/b/tips/posts/joining-computers-to-a-domain
- Analizar GPO (en remoto y local)
  - Local
    * https://www.jesusninoc.com/05/12/view-group-policy-objects/
    ```PowerShell
      $resulta = gpresult /z
      foreach($lineas in $resulta)
      {
          if($lineas -match "CMD")
          {
              $lineas
          }
      } 
    ```
  - Remoto
    * https://www.jesusninoc.com/04/23/obtener-gpos-objetos-de-directiva-de-grupo-que-no-se-estan-utilizando/
    ```PowerShell
    Get-GPO -All | %{
      $_ | Get-GPOReport -ReportType XML | Select-String "Impedir el acceso al símbolo del sistema"
    }
    ```

# Práctica
## Añadir un equipo al dominio desde PowerShell
* http://community.idera.com/powershell/powertips/b/tips/posts/joining-computers-to-a-domain
