# Administración de dominios:
- Estructura grupo de trabajo.
- Estructura cliente-servidor.
- Protocolo LDAP.
- Estructura lógica del directorio activo (DA):
  - Concepto de dominio. Subdominios.
  - Unidades organizativas. Objetos.
  - Árboles y bosques.
  - Catálogo global. Esquema.
  - Funciones de los maestros de operaciones.
- Estructura física del DA:
  - Concepto de sitio (Site). Optimización del tráfico de red.
- Configurar la replicación entre Sites.
- Requisitos necesarios para montar un dominio.
- Administración de cuentas. Cuentas predeterminadas.
- Contraseñas. Bloqueos de cuenta.
- Cuentas de usuarios y equipos.
- Perfiles móviles y obligatorios.
- Carpetas personales.
- Plantillas de usuario. Variables de entorno.
- Restringir el inicio de sesión de una cuenta:
  - A ciertas horas y días.
  - En determinados ordenadores.
- Scripts de inicio de sesión.
- Administración de grupos. Tipos. Estrategias de anidamiento. Grupos predeterminados.
- Unidades Organizativas (UO).
  - Estrategias de administración.

------------------------

# Teoría
- Servicios de directorio
  - Dominio (árbol, bosque). Controlador de dominio. Miembro del servidor. Nivel funcional. Objetos (OU, grupos, usuarios, equipos)
    - Controlador de dominio adicional: Para tener más de un Controlador de Dominio, simplemente debemos ejecutar el mismo proceso anterior, sólo que en este caso durante el asistente le diremos que es Controlador de Dominio adicional, en un Dominio ya existente. En este caso toda la información de Active Directory que está en el primero se replicará en el segundo Controlador de Dominio
    - Diferenciar entre Dominio y Controlador de Dominio https://windowserver.wordpress.com/2011/05/05/comprender-active-directory/
    - Funciones del Catálogo Global (Global Catalog) https://windowserver.wordpress.com/2011/06/24/funciones-del-catlogo-global-global-catalog/
    - Replicación https://windowserver.wordpress.com/2014/12/02/windows-server-2012-r2-crear-un-dominio-instalacin-y-configuracin-del-segundo-controlador-de-dominio/
  - Contraseñas. Bloqueos de cuenta https://www.jesusninoc.com/contrasenas-seguras-con-powershell/
  - Cuentas de usuarios y equipos https://www.jesusninoc.com/03/05/create-users-add-into-a-group-and-share-directory-with-permissions-in-active-directory/
  - Perfiles móviles y obligatorios.
  - Carpetas personales.
  - Plantillas de usuario. Variables de entorno.
  - Restringir el inicio de sesión de una cuenta.
  - Scripts de inicio de sesión.

------------------

# Ejercicio
## Hay un problema de seguridad en el hospital, un ransomware ha sido capaz de crear usuarios (no administradores) que pueden crear otros usuarios mediante un script que se ha ejecutado (haciendo clicks) en la cuenta del administrador. Explica mediante capturas y scripts cómo se ha realizado (no te agobies, haz lo que sepas).

### Pasos (por ejemplo):
- Crear usuarios leyendo de un fichero
- Script gráfico que hace clicks en determinadas zonas de la configuración de Windows Server
- Dejar el script programado mediante una GPO

### Ayuda
#### Crear OU, usuarios, buscar
```PowerShell
# Crear una OU
New-ADOrganizationalUnit -Name UnidadPS

# Crea un usuario en un lugar determinado
New-ADUSer -Name NombrePs -Sam NombreInicioSesion -Path "OU=UnidadPS,DC=jesusninoc,DC=com"
 -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
 
$SAMAccountName = "asir*"
Get-ADUser -LDAPFilter "(samaccountname=$SAMAccountName)"
```

#### Más ayuda
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-24.md#crear-usuarios-leyendo-desde-un-fichero-explicar-fichero-y-bucle-foreach
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-25.md#utilizar-un-filtro-ldap-para-localizar-un-usuario
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-25.md#utilizar-un-filtro-ldap-para-verificar-la-hora-del-%C3%BAltimo-inicio-de-sesi%C3%B3n-de-los-usuarios-del-active-directory
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-27.md#crear-usuarios-grupos-ous-y-todo-lo-que-quieras-leyendo-de-una-p%C3%A1gina-web
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-01.md#instalaci%C3%B3n-configuraci%C3%B3n-objetos-relaciones-de-confianza-gpos-rodc-dc-secundario
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-02.md#funci%C3%B3n-comprobar-con-filtro-ldap-soluci%C3%B3n-de-enrique-carreras

---------------

# Administración del acceso al dominio:
- Equipos del dominio.
- Permisos y derechos.
- Delegación de permisos / autoridad.
  - Asistente para la delegación de control.
  - Herramientas de línea de comandos: dsacls.exe y dsrevoke.exe.	🤦
- Listas de control de acceso.

# Active Directory

## Joining Computers to a Domain
http://community.idera.com/powershell/powertips/b/tips/posts/joining-computers-to-a-domain

## Ejercicios sin scripts
- INSTALAR UN EQUIPO Y METERLO EN EL DOMINIO
