# Administración de dominios:
- Estructura grupo de trabajo.
- Estructura cliente-servidor.
- Protocolo LDAP.
- Estructura lógica del directorio activo (DA):
  - Concepto de dominio. Subdominios.
  - Unidades organizativas. Objetos.
  - Árboles y bosques.
  - Catálogo global. Esquema.
  - Funciones de los maestros de operaciones.
- Estructura física del DA:
  - Concepto de sitio (Site). Optimización del tráfico de red.
- Configurar la replicación entre Sites.
- Requisitos necesarios para montar un dominio.
- Administración de cuentas. Cuentas predeterminadas.
- Contraseñas. Bloqueos de cuenta.
- Cuentas de usuarios y equipos.
- Perfiles móviles y obligatorios.
- Carpetas personales.
- Plantillas de usuario. Variables de entorno.
- Restringir el inicio de sesión de una cuenta:
  - A ciertas horas y días.
  - En determinados ordenadores.
- Scripts de inicio de sesión.
- Administración de grupos. Tipos. Estrategias de anidamiento. Grupos predeterminados.
- Unidades Organizativas (UO).
  - Estrategias de administración.

------------------------

# Teoría
- Servicios de directorio
  - Centralizar
  - Base de datos https://www.jesusninoc.com/12/27/conectar-powershell-con-mysql/
  - X.500
  - DAP
  - LDAP
  - OpenLDAP
  - AD
  - Dominio (árbol, bosque). Controlador de dominio. Miembro del servidor. Nivel funcional. Objetos (OU, grupos, usuarios, equipos)
    - Árbol: red.local y despachos.red.local
    - Bosque: red.local y alumnos.local
    - Controlador de dominio adicional: Para tener más de un Controlador de Dominio, simplemente debemos ejecutar el mismo proceso anterior, sólo que en este caso durante el asistente le diremos que es Controlador de Dominio adicional, en un Dominio ya existente. En este caso toda la información de Active Directory que está en el primero se replicará en el segundo Controlador de Dominio
    - Diferenciar entre Dominio y Controlador de Dominio https://windowserver.wordpress.com/2011/05/05/comprender-active-directory/
    - Los registros DNS de servicio de Active Directory https://www.elladodelmal.com/2011/05/los-registros-dns-de-servicio-de-active.html
    - Funciones del Catálogo Global (Global Catalog) https://windowserver.wordpress.com/2011/06/24/funciones-del-catlogo-global-global-catalog/
    - Replicación https://windowserver.wordpress.com/2014/12/02/windows-server-2012-r2-crear-un-dominio-instalacin-y-configuracin-del-segundo-controlador-de-dominio/
  - DNS.

------------------

# Active Directory – Windows Server
* http://www.developandsys.es/active-directory-windows-server/

## AD Overview Graphical Tool: Active Directory Domain Services Section
* https://sid-500.com/2018/03/25/active-directory-domain-services-section-tool-for-active-directory-administrators/

## PowerShell CmdLine Conversion Guide AD
* https://github.com/PrateekKumarSingh/CheatSheets/blob/master/Powershell/PowerShell_CmdLine_Conversion_Guide_AD.pdf

------------------

# DAP, LDAP
LDAP es la abreviatura del Protocolo ligero de acceso a directorios. Como su nombre lo indica, este protocolo es compatible con un servicio de directorio (directorio).

## DAP en OSI
* https://myacordeon.files.wordpress.com/2011/04/osi.gif
* http://www.mitlinx.de/ldap/assets/osi_ldap_dap.gif
* http://www.mitlinx.de/ldap/index.html?http://www.mitlinx.de/ldap/ldap_geschichte.htm

## LDAP Query Basics
http://salta.xs4all.nl/docs/DirectoryServices/LDAP/LDAP%20Query%20Basics.pdf
## Utilizar un filtro LDAP para localizar un usuario
https://www.jesusninoc.com/2018/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
## Active Directory Service Interfaces (ADSI) is a set of COM interfaces used to access the features of directory services from different network providers
https://msdn.microsoft.com/en-us/library/aa772170(v=vs.85).aspx
## List local users (ADSI)
https://www.jesusninoc.com/2016/07/02/list-local-users/
## Posts sobre ADSI
https://www.jesusninoc.com/adsi/
## Using AD Filters with Cmdlets (Part 1)
http://community.idera.com/powershell/powertips/b/tips/posts/using-ad-filters-with-cmdlets-part-1
## Using AD Filters with Cmdlets (Part 2)
http://community.idera.com/powershell/powertips/b/tips/posts/using-ad-filters-with-cmdlets-part-2
## Using AD Filters with Cmdlets (Part 3)
http://community.idera.com/powershell/powertips/b/tips/posts/using-ad-filters-with-cmdlets-part-3
## Using AD Filters with Cmdlets (Part 4)
http://community.idera.com/powershell/powertips/b/tips/posts/using-ad-filters-with-cmdlets-part-4

## 3 ways to search with PowerShell
http://activedirectoryfaq.com/2015/02/ldap-search-powershell-find-ldapobject/

## Active Directory with PowerShell, ADSI, and LDAP
https://www.petri.com/active-directory-powershell-adsi-ldap
## A minimalistic LDAP server in Go
https://github.com/bradleypeabody/godap
## goddi (go dump domain info) dumps Active Directory domain information
https://github.com/NetSPI/goddi/blob/master/conn.go
## A JOURNEY FROM JNDI/LDAP MANIPULATION TO REMOTE CODE EXECUTION DREAM LAND
* https://www.blackhat.com/docs/us-16/materials/us-16-Munoz-A-Journey-From-JNDI-LDAP-Manipulation-To-RCE.pdf
* https://www.youtube.com/watch?v=Y8a5nB-vy78
## GPSCRIPT.EXE – ANOTHER LOLBIN TO THE LIST
https://oddvar.moe/2018/04/27/gpscript-exe-another-lolbin-to-the-list/
## Jugando con LDAP (I de III)
https://www.elladodelmal.com/2008/04/jugando-con-ldap-i-de-iii.html

------------------

# Ejercicios

## Crear OU, usuarios, buscar
```PowerShell
# Crear una OU
New-ADOrganizationalUnit -Name UnidadPS

# Crea un usuario en un lugar determinado
New-ADUSer -Name NombrePs -Sam NombreInicioSesion -Path "OU=UnidadPS,DC=jesusninoc,DC=com"
 -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
 
$SAMAccountName = "asir*"
Get-ADUser -LDAPFilter "(samaccountname=$SAMAccountName)"
```

## Más ejercicios
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-24.md#crear-usuarios-leyendo-desde-un-fichero-explicar-fichero-y-bucle-foreach
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-25.md#utilizar-un-filtro-ldap-para-localizar-un-usuario
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-25.md#utilizar-un-filtro-ldap-para-verificar-la-hora-del-%C3%BAltimo-inicio-de-sesi%C3%B3n-de-los-usuarios-del-active-directory
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-27.md#crear-usuarios-grupos-ous-y-todo-lo-que-quieras-leyendo-de-una-p%C3%A1gina-web
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-01.md#instalaci%C3%B3n-configuraci%C3%B3n-objetos-relaciones-de-confianza-gpos-rodc-dc-secundario
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-10-02.md#funci%C3%B3n-comprobar-con-filtro-ldap-soluci%C3%B3n-de-enrique-carreras

------------------

# Ataques DNS

## DNS Spoofing

https://tools.ietf.org/html/rfc5452

When certain steps are taken, it is feasible to "spoof" the current
   deployed majority of resolvers with carefully crafted and timed DNS
   packets.  Once spoofed, a caching server will repeat the data it
   wrongfully accepted, and make its clients contact the wrong, and
   possibly malicious, servers.

   To understand how this process works it is important to know what
   makes a resolver accept a response.

   The following sentence in Section 5.3.3 of [RFC1034] presaged the
   present problem:

     The resolver should be highly paranoid in its parsing of responses.
     It should also check that the response matches the query it sent
     using the ID field in the response.

   DNS data is to be accepted by a resolver if and only if:

   1.  The question section of the reply packet is equivalent to that of
       a question packet currently waiting for a response.

   2.  The ID field of the reply packet matches that of the question
       packet.

   3.  The response comes from the same network address to which the
       question was sent.

   4.  The response comes in on the same network address, including port
       number, from which the question was sent.

   In general, the first response matching these four conditions is
   accepted.
   
   If a third party succeeds in meeting the four conditions before the
   response from the authentic nameserver does so, it is in a position
   to feed a resolver fabricated data.  When it does so, we dub it an
   "attacker", attempting to spoof in fake data.

   All conditions mentioned above can theoretically be met by a third
   party, with the difficulty being a function of the resolver

## Informe sobre ataque en DNS

Enom Central Customers:

I want to inform you that Enom recently became the subject of what appears to be a very sophisticated attack by a group that targets large internet infrastructure companies. Within hours of this attack, we were in contact with federal law enforcement and the affected parties. This attack hijacked the DNS traffic of 4 domains for a very short period of time before we mitigated the situation.

You have not been impacted by this incident and you are not required to take any action to ensure your future security. However, in an effort to continue to strive for transparency and best in class services, I wanted to inform you of this unfortunate situation.

To be clear, no domain names were stolen, and after exhaustive analysis, with the exception of the DNS of the domains specifically targeted, we do not have any evidence or reason to believe that these malicious actors accessed any customer accounts, customer personal information, or any of Enom’s secured and encrypted data. Your security is a leading priority at Enom and we continue to work both with federal law enforcement and industry leading security forensic companies to protect your online presence.

I know you trust Enom Central with your domain names and services and we take this responsibility very seriously. We appreciate your business and you have our commitment to continue to do what it takes to protect your assets.

------------------

# Ataques DoS

## TCP SYN Flooding Attacks and Common Mitigations
https://tools.ietf.org/html/rfc4987

## XERXES – Most Powerful Tool For DoS Attack using Kali Linux
https://gbhackers.com/xerxes-kali-linux-tutorial/
https://github.com/zanyarjamal/xerxes

## Un poco DDoS y herramientas para detener los ataques
https://www.elevenpaths.com/es/noticias-y-eventos/elevenpaths-talks/un-poco-ddos-y-herramientas-para-detener-los-ataques/index.html

## LOIC
### Low Orbit Ion Cannon
An open source network stress tool, written in C#. Based on Praetox's LOIC project. USE ON YOUR OWN RISK. WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.

https://github.com/NewEraCracker/LOIC

### Java LOIC. Low Orbit Ion Cannon. 
A Java based network stress testing application

https://www.kitploit.com/2015/05/java-loic-low-orbit-ion-cannon-java.html

## Fail2ban
Fail2ban scans log files (e.g. /var/log/apache/error_log) and bans IPs that show the malicious signs -- too many password failures, seeking for exploits, etc. Generally Fail2Ban is then used to update firewall rules to reject the IP addresses for a specified amount of time, although any arbitrary other action (e.g. sending an email) could also be configured. Out of the box Fail2Ban comes with filters for various services (apache, courier, ssh, etc).

https://www.fail2ban.org/wiki/index.php/Main_Page

## How To Protect SSH and Apache Using Fail2Ban on Ubuntu Linux
https://blog.rapid7.com/2017/02/13/how-to-protect-ssh-and-apache-using-fail2ban-on-ubuntu-linux/
