# Situación crítica 2 (resolver la siguiente situación con scripts)

## Dentro de una empresa se está ejecutando una aplicación de forma anómala, utiliza todo lo que sabes para crear funciones en un script que permitan detectar la aplicación.

### Ideas que se pueden aplicar:
- ¿Cómo detectar que se está ejecutando un proceso? https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#c%C3%B3mo-detectar-que-se-est%C3%A1-ejecutando-un-proceso
- Mostrar un mensaje en PowerShell cuando se ejecuta y se para un programa https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#mostrar-un-mensaje-en-powershell-cuando-se-ejecuta-y-para-un-programa

-----------------

# Solución a la situación crítica 2

## Vamos a tener en cuenta:
- Un proceso que no se comporta como siempre es raro.
- Un proceso que abre muchos hilos es raro.
- Analizar los hilos de un proceso en concreto
- Un proceso que abre muchas comunicaciones es raro.
- Un proceso que consume fuera de normal es raro.
- Un proceso que se activa a una hora extraña es raro.
- Un proceso cuya firma ha cambiado es extraño.
- Mostrar los procesos que utiliza un controlador

## Scripts para cada uno de los apartados anteriores

### - Un proceso que no se comporta como siempre es raro
```PowerShell
$proceso1=(gps).name
start notepad
Start-Sleep -Seconds 3
$proceso2=(gps).name
Compare-Object -ReferenceObject $proceso1 -DifferenceObject $proceso2
  ```
### - Un proceso que abre muchos hilos es raro
  ```PowerShell
  Get-Process | %{
    $_.name, $_.Threads.Count
}
  ```
### - Analizar los hilos de un proceso en concreto
```PowerShell
# Realizar una función que muestre información sobre los hilos de un proceso.
function hilos($name){
    $processHandle = (Get-Process -Name $name).id
    $Threads = Get-WmiObject -Class Win32_Thread |
    Where-Object { $_.ProcessHandle -eq $processHandle }
    "The $name process has $($threads.count) threads"
    $threads | Format-Table -Property priority, thread*, User*Time, kernel*Time
}

hilos notepad
```

### - Un proceso que abre muchas comunicaciones es raro (solución compleja)
```PowerShell
function monitorizar
{
  param()
  begin
  {
  }
  process
  {
    foreach($conex in @(netstat -ano))
    {
        foreach($proceso in ps | where id -EQ ((Get-Process -name chrome | sort cpu -Descending | select -First 2)[0].id))
        {
            if($conex -match $proceso.Id -and $proceso.Id -ne 4 -and $proceso.Id -ne 0)
            {
                write-host $conex “-PROCESO->” $proceso.Name $proceso.Id
            }
        }
    }
  }
  end
  {
  }
}

monitorizar
```

### - Un proceso que consume fuera de lo normal es raro
```PowerShell
# Realizar una función de muestre el consumo de procesador analizando dos valores (consumo -cpu 20 -id 6000).
# Sirve para ir de uno en uno
(Get-Process | select $proceso).cpu -gt $valor

# Varios valores
Get-Process | Where-Object cpu -gt 10 | Where-Object id -gt 6000
```

### - Un proceso que se activa a una hora extraña es raro
```PowerShell
Get-EventLog -LogName Security -InstanceId 4688
Get-EventLog Application | Where-Object Message -Match "explore" 
```

### - Un proceso cuya firma ha cambiado es extraño
```PowerShell
# Realizar una función que permita detectar que hay una firma que ha cambiado en un programa.
# Función simple para almacenar un hash de un programa
function hashear($ruta){
    Get-FileHash $ruta
}

(hashear 'C:\Windows\System32\notepad.exe' | select hash).hash | Out-File hash.txt

(gc hash.txt)

Get-Process | select Path | %{
    hashear $_.Path
}

Get-Process | select Path | %{
    (hashear $_.Path).hash
}

Get-Process | select Path | %{
    if ((hashear $_.Path).hash -match (gc hash.txt))
    {
        "Igual",$_.path
    }
}
```

### - Mostrar los procesos que utiliza un controlador
```PowerShell
# Realizar una función que muestre los procesos que utilizan un controlador.
Get-Process -Module | select-string "OLEAUT32.dll"

Get-Process -Module | %{
    $_ | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules  | %{
    $_.name
    $_.Modules.ModuleName | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules | %{
    if($_.Modules.ModuleName -eq "OLEAUT32.dll")
    {
        $_.Name,$_.Modules.ModuleName
    }
}
```
