# Situación crítica 1 (resolver la siguiente situación con scripts)

## Los hospitales están habilitando zonas nuevas para poder atender a pacientes, eso quiere decir que van a utilizar equipos clientes y servidores, tu tarea es ser capaz de poner odenadores nuevos con la misma configuración que tienen los anteriores (usuarios, programas, actualizaciones, carpetas compartidas) y no solo es clonar y ya. Crea un procedimiento con scripts para resolver la situación.

## Ejemplos de cómo se puede resolver la situación:

- Sacar los usuarios de un equipo y crearlos en otro leyendo de un fichero.
- Ver los programas que hay instalados en un equipo e instalarlos en otro leyendo de un fichero.
- Ver las carpetas compartidas que hay en un equipo y crearlas en otro leyendo de un fichero.

## Ideas que se pueden aplicar:
- Tareas programadas https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task-
- WMI Query Language https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-10.md#wmi-query-language
- Ejercicios curso MySQL con PowerShell https://www.jesusninoc.com/2017/02/20/ejercicios-curso-mysql-con-powershell/
- Leer un usuario desde un servidor web (HTML, XML, JSON) crearlo y meterlo en el grupo de administradores (no te olvides del password).
- Detectar mediante una función que el usuario pertenece al grupo de administradores.
- Intentar utilizar las credenciales de un usuario y verificar que funciona (guarda en un fichero la captura).
- Expresiones regulares https://github.com/jesusninoc/ClasesISO/blob/master/2020-03-13.md#expresiones-regulares

-----------------

# Solución a la situación crítica 1

## Seleccionar usuarios que empiezan por una letra (con una expresión regular)
```PowerShell
Get-LocalUser | select name | %{
    $_.name -match '^[ag]'
}

Get-LocalUser [ag]* | select name 
```

## Restaurar usuarios creados anteriormente
```PowerShell
(Get-LocalUser).name | out-file .\usuarios3.txt

(gc .\usuarios3.txt) | % {
    New-LocalUser $_ -whatif -NoPassword
}

(Get-LocalUser).name | % {
    New-LocalUser $_ -whatif -NoPassword
}
```

## Ver los progrmas que hay instalados en un equipo e instalarlos en otro leyendo de un fichero
```PowerShell
Get-Package | Select-Object name | Out-File aplicaciones.txt

foreach ($item in gc aplicaciones.txt)
{
    Install-Package -name $item
}
```

## Mapear unidades
```PowerShell
foreach ($item in gc unidades.txt)
{
    New-PSDrive -Name “Etiqueta” -PSProvider FileSystem -Root $item –Persist
}
```

## Poner bonito
```PowerShell
Function showmenu {
    Clear-Host
    Write-Host "Starting Menu..."
    Write-Host "1. Search"
    Write-Host "2. Create"
    Write-Host "3. Delete"
    Write-Host "4. Exit"
}

showmenu

while(($inp = Read-Host -Prompt "Select an option") -ne "4"){

switch($inp){
        1 {
            Clear-Host
            Write-Host "------------------------------";
            Write-Host "Search account"; 
            Write-Host "------------------------------";
            pause;
            break
        }
        2 {
            Clear-Host
            Write-Host "------------------------------";
            Write-Host "Create account";
            Write-Host "------------------------------";
            pause; 
            break
        }
        3 {
            Clear-Host
            Write-Host "------------------------------";
            Write-Host "Remove account";
            Write-Host "------------------------------"; 
            pause;
            break
            }
        4 {"Exit"; break}
        default {Write-Host -ForegroundColor red -BackgroundColor white "Invalid option. Please select another option";pause}
        
    }

showmenu
}
```

# Solución a la situación crítica 2 (muy avanzada)

## Instalar software en cualquier equipo de la red desde PowerShell leyendo desde un archivo la información para instalar utilizando credenciales almacenados (solución de Diego A.)
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-09.md#instalar-software-en-cualquier-equipo-de-la-red-desde-powershell-leyendo-desde-un-archivo-la-informaci%C3%B3n-para-instalar-utilizando-credenciales-almacenados-soluci%C3%B3n-de-diego-a
