# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Administración y aseguramiento de la información
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.
- Identificación del software instalado mediante comandos y herramientas gráficas.
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.
- Implementación RAID por software:
  - Operaciones con volúmenes: extender y distribuir.
  - Aumentar la velocidad.
  - Tolerancia a fallos. Simular un fallo de disco para comprobar la tolerancia del sistema.
  - Detectar fallos consultando los registros del sistema.
  - Programar alertas por correo.
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.
  
# Administración de recursos compartidos
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

---------------------

# Repaso del mes
## Script para realizar tareas básicas y avanzadas
https://github.com/jesusninoc/Scripts/blob/master/Realizar%20tareas%20b%C3%A1sicas%20y%20avanzadas.sh
## Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
https://www.jesusninoc.com/2015/04/28/cmdlets-relacionados-con-tareas-basicas-y-de-administracion-en-el-sistema-operativo-windows/

# Repaso del BOE
- Administración y aseguramiento de la información
- Administración de software de base
- Administración de recursos compartidos

# Repaso de las tareas de administración III
### Gestión del almacenamiento
* https://www.jesusninoc.com/2017/07/03/3-gestion-del-hardware-en-powershell/
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/
### Gestión de la red
* https://www.jesusninoc.com/2017/07/09/9-gestion-de-la-red-en-powershell/
### Copias de seguridad
* https://www.jesusninoc.com/2017/07/10/10-gestion-del-rendimiento-en-powershell/

---------------------

# Realizar un script que sea una tarea programada que almacene información sobre la situación actual del sistema operativo (Windows y Linux), teniendo en cuenta:
- Programas instalados
- Actualizaciones
- Usuarios y grupos

## Además de almacenar información, el script tiene que permitir hacer una recuperación con la información almacenada, por ejemplo restaurar usuarios leyendo de un fichero los usuarios y grupos a los que pertenecen.

## Ideas que se pueden aplicar al script:
- Almacenar los .exe de los programas
- Almacenar los ficheros .dll de los programas
- Almacenar los instaladores .msi de los programas instalados
- Realizar un proceso de firma (hash) a los programas instalados
- Utilizar expresiones regulares

----------------------

# Hyper-V: Backup VMs to a shared folder with Windows Server Backup and a Scheduled Task-
https://sid-500.com/2018/03/11/hyper-v-backup-vms-to-a-shared-folder-with-windows-server-backup-and-a-scheduled-task/
```PowerShell
$Action=New-ScheduledTaskAction -Execute 'C:\Temp\backupVM.bat'
$Trigger=New-ScheduledTaskTrigger -Weekly -DaysOfWeek Saturday -At 11am
$Set=New-ScheduledTaskSettingsSet
$Principal=New-ScheduledTaskPrincipal -UserId 'sid-500\administrator' -LogonType S4U
$Task=New-ScheduledTask -Action $Action -Trigger $Trigger -Settings $Set -Principal $Principal
Register-ScheduledTask -TaskName "Backup VM" -InputObject $Task -Force
```

# Linux – Tigger commands and tasks during file system changes
https://www.capatek-tutorials.com/linux/linux-tigger-commands-tasks-file-system-changes/

# Scheduled Task with Daily Trigger and Repetition Interval
https://stackoverflow.com/questions/20108886/scheduled-task-with-daily-trigger-and-repetition-interval
```PowerShell
$trigger = New-ScheduledTaskTrigger `
    -Once `
    -At (Get-Date) `
    -RepetitionInterval (New-TimeSpan -Minutes 5) `
    -RepetitionDuration ([System.TimeSpan]::MaxValue)
```

---------------------

# ¿Cómo detectar que ha aparecido un equipo en la red WIFI?
- Mostrar un mensaje en PowerShell cuando aparece un equipo WIFI en la red
```PowerShell
```

---------------------

# ¿Cómo detectar que se está ejecutando un proceso?
- Conocer procesos
- Firmas de procesos
- Mostrar un mensaje en PowerShell cuando se ejecuta y se para un programa (por ejemplo se ejecuta powershell)
```PowerShell
Start-Process powershell.exe "-command ps"
```
- Localizar el proceso que está relacionado con el puerto de carpetas compartidas
```PowerShell
netstat -ano
```
- Contar procesos
- Contar hilos
- Analizar la red
- Auditar
- Registro
- Registro y logs de carpetas compartida
- Explorer
- Keylogger
- Volcado de procesos
- Capturar la pantalla
- Get-Counter

---------------------

# Listar información sobre usuarios y grupos en Bash (con repaso sobre comandos)

## Crea  directorios con los años desde 2020 hasta 2030
```Bash
mkdir{2020..2030}
```

## En cada uno de los directorios, crea un subdirectorio con los meses del año
```Bash
mkdir -p{2020..2030}/{Enero, Febrero, Marzo, Abril, Mayo, Junio, Julio, Agosto, Septiembre, Octubre, Noviembre, Diciembre}
```

## En cada mes, crear un directorio con cada día de la semana
```Bash
mkdir -p{2020..2030}/{Enero, Febrero, Marzo, Abril, Mayo, Junio, Julio, Agosto, Septiembre, Octubre, Noviembre, Diciembre}/{Lunes, Martes, Miercoles, Jueves, Viernes, Sabado, Domingo}
```

## Borrar todos los directorios Julio y Agosto de todos los años
```Bash
rm -r{2020..2030}/{Julio, Agosto}
```

## Crear un alias del comando "rm" que se llame borrar y que permita borrar el directorio Ejercicio1 (con su contenido)
```Bash
alias borrar='rm -r -f ejercicio1'
```

## Sacar solo el nombre del usuario y al lado cuántos caracteres tiene ese nombre
```Bash
cut -f1 -d: /etc/passwd | xargs -I{} /bin/bash -c 'echo -n "{} " ; echo $(echo {} | wc -c)-1 | bc'
```

## Sacar el nombre de usuario que más caracteres tiene
```Bash
cut -f1 -d: /etc/passwd | xargs -I{} /bin/bash -c 'echo -n "{} " ; echo $(echo {} | wc -c)-1 | bc' | sort -k2n | cut -f1 -d" " | tail -1
```

## Contar cuántos grupos hay en el sistema
```Bash
cat /etc/group | wc -l
```

## Muestre los nombres de los grupos ordenados alfabéticamente de forma descendente
```Bash
cut -f1 -d: /etc/group | sort -r
```

## Muestre los nombres de los grupos ordenados numéricamente por GID de grupo
```Bash
cat /etc/group | sort -k3n -t: | cut -f1 -d:
```

## ¿Cuál es el último nombre del grupo ordenado alfabéticamente? 
```Bash
cut -f1 -d: /etc/group | sort -r | tail -1
```

## Cuál es el nombre del grupo con GID de grupo más alto?
```Bash
cat /etc/group | sort -k3 -t: -n | cut -f1 -d: | tail -1
```

## Muestre los nombres de grupo que empiecen por vocal
```Bash
cut -f1 -d: /etc/group | grep -E -i "^[aeiou]"
```

## Indicar el número de caracteres que tiene el nombre del grupo que contiene varios usuarios
```Bash
cut -f1,4  -d: /etc/group | grep "," | cut -d: -f1 | wc -c
```

---------------------

# Register-WmiEvent

## Mostrar un mensaje en PowerShell cuando se ejecuta y para un programa
```PowerShell
#Arrancar programa notepad.exe y no avisa con mensaje que se ha ejecutado
Start-Process notepad.exe

#Registrar la acción de avisar cuando se ejecuta el programa notepad.exe
#La clase WMI del evento Win32_ProcessStartTrace indica que se ha iniciado un nuevo proceso.
Register-WMIEvent -Query "SELECT * FROM Win32_ProcessStartTrace WHERE ProcessName='notepad.exe'" -Action {Write-Host "Nuevo proceso notepad"} 

#Arrancar programa notepad.exe y avisa con mensaje que se ha ejecutado
Start-Process notepad.exe

Register-WMIEvent -Query "SELECT * FROM Win32_ProcessStopTrace WHERE ProcessName='notepad.exe'" -Action {Write-Host "Proceso notepad cerrado"} 
```

## Mostrar un mensaje en PowerShell cuando se ejecuta un programa
https://www.jesusninoc.com/2017/09/04/mostrar-un-mensaje-en-powershell-cuando-se-ejecuta-un-programa/

## Registrar un evento y mostrar un mensaje en PowerShell cuando se ejecuta un programa
https://www.jesusninoc.com/2017/09/29/registrar-un-evento-y-mostrar-un-mensaje-en-powershell-cuando-se-ejecuta-un-programa/

## Registrar un evento y mostrar un mensaje en PowerShell cuando se ejecutan varios programas
https://www.jesusninoc.com/2017/10/29/registrar-un-evento-y-mostrar-un-mensaje-en-powershell-cuando-se-ejecutan-varios-programas/

## Registrar y mostrar un evento en PowerShell cuando se ejecuta un programa
https://www.jesusninoc.com/2018/02/14/registrar-y-mostrar-un-evento-en-powershell-cuando-se-ejecuta-un-programa/

---------------------

# WMI Query Language

## WMI Query Language via PowerShell
http://eddiejackson.net/web_documents/WMI_Query_Language_via_PowerShell.pdf

## WMI Data Queries
https://www.jesusninoc.com/2015/02/20/wmi-data-queries/

## List services (written in WQL)
https://www.jesusninoc.com/2015/11/12/list-services-written-in-wql/

## List running services (written in WQL)
https://www.jesusninoc.com/2015/11/14/list-running-services-written-in-wql/

## Useful WMI classes
https://www.jesusninoc.com/2012/12/10/useful-wmi-classes/

## Post Exploitation Using WMIC (System Command)
http://www.hackingarticles.in/post-exploitation-using-wmic-system-command/

## Windows PowerShell 3.0 Language Quick Reference
https://download.microsoft.com/download/2/1/2/2122F0B9-0EE6-4E6D-BFD6-F9DCD27C07F9/WS12_QuickRef_Download_Files/PowerShell_LangRef_v3.pdf

## Basics of Tracking WMI Activity
https://www.darkoperator.com/blog/2017/10/14/basics-of-tracking-wmi-activity

---------------------

# osquery
SQL powered operating system instrumentation, monitoring, and analytics. https://osquery.io
https://github.com/osquery

---------------------

# Ejercicios curso MySQL con PowerShell
https://www.jesusninoc.com/2017/02/20/ejercicios-curso-mysql-con-powershell/

---------------------

# WQL-Datenabfrage
## WQL-Datenabfrage: Anzahl der Prozessoren
https://www.jesusninoc.com/2017/02/18/wql-datenabfrage-anzahl-der-prozessoren/
## WQL-Datenabfrage: Informationen über den Bildschirm
https://www.jesusninoc.com/2017/02/15/wql-datenabfrage-informationen-ueber-den-bildschirm/
## WQL-Datenabfrage: Füllstand der Laufwerke
https://www.jesusninoc.com/2017/05/03/wql-datenabfrage-fuellstand-der-laufwerke/
## WQL-Datenabfrage: Informationen über den Computer
https://www.jesusninoc.com/2017/05/02/wql-datenabfrage-informationen-ueber-den-computer/
## WQL-Datenabfrage: Softwareinventarisierung
https://www.jesusninoc.com/2017/04/05/wql-datenabfrage-softwareinventarisierung/
## WQL-Datenabfrage: Speichernutzung der aktiven Prozesse
https://www.jesusninoc.com/2017/04/03/wql-datenabfrage-speichernutzung-der-aktiven-prozesse/
## WQL-Datenabfrage: Informationen über den Prozessor
https://www.jesusninoc.com/2017/02/21/wql-datenabfrage-informationen-ueber-den-prozessor/
## WQL-Datenabfrage: Belastung des Prozessors
https://www.jesusninoc.com/2017/02/19/wql-datenabfrage-belastung-des-prozessors/
## WQL-Datenabfrage: Informationen über die Festplatten
https://www.jesusninoc.com/2017/03/27/wql-datenabfrage-informationen-ueber-die-festplatten/
## WQL-Datenabfrage: Liste aller laufenden Dienste
https://www.jesusninoc.com/2017/03/18/wql-datenabfrage-liste-aller-laufenden-dienste/
## WQL-Datenabfrage: Ermitteln der Seriennummer des Betriebssystems
https://www.jesusninoc.com/2017/03/14/wql-datenabfrage-ermitteln-der-seriennummer-des-betriebssystems/
## WQL-Datenabfrage: Informationen über die optischen Laufwerke (CD/DVD)
https://www.jesusninoc.com/2017/02/25/wql-datenabfrage-informationen-ueber-die-optischen-laufwerke-cddvd/
## WQL-Datenabfrage: Informationen über die Grafikkarte
https://www.jesusninoc.com/2017/02/22/wql-datenabfrage-informationen-ueber-die-grafikkarte/

-------------------

# PowerShell
## Detectar si hay un dispositivo USB conectado y copiar el contenido en una carpeta temporal
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Detectar%20si%20hay%20un%20dispositivo%20USB%20conectado%20y%20copiar%20el%20contenido%20en%20una%20carpeta%20temporal.ps1

## Discover a webcam
https://www.jesusninoc.com/2017/10/17/discover-a-webcam/

## Ver los teléfonos móviles que se han conectado al sistema operativo
https://www.jesusninoc.com/2016/12/01/ver-los-telefonos-moviles-que-se-han-conectado-al-sistema-operativo/

## Conocer el estado del ratón
https://www.jesusninoc.com/2016/10/05/conocer-el-estado-del-raton/

## Activar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/03/08/activar-un-dispositivo-plug-and-play-con-powershell/

## Desactivar un dispositivo Plug and Play con PowerShell
https://www.jesusninoc.com/2018/02/08/desactivar-un-dispositivo-plug-and-play-con-powershell/

## Show UDID of iPhone
https://www.commandlinefu.com/commands/view/15421/show-udid-of-iphone

-------------------

# Linux
## Setting Up NFS Share on Windows
https://support.microfocus.com/kb/doc.php?id=7020834

## Montar una carpeta compartida de Windows en Linux
https://blog.desdelinux.net/montar-unidades-smb-desde-consola/

## dd command
https://www.computerhope.com/unix/dd.htm

Caution: Use dd cautiously — improper usage or entering the wrong values could inadvertently wipe, destroy, or overwrite the data on your hard drive.

### Create a ISO disc image from the CD in the computer
```Bash
dd if=/dev/sr0 of=/home/hope/exampleCD.iso bs=2048 conv=noerror,sync
```

### Create an img file of the /dev/sda hard drive. To restore that image type: dd if=disk1.img of=/dev/sda
```Bash
dd if=/dev/sda of=~/disk1.img
```

### Copy the contents from the if= drive /dev/sda to the of= drive /dev/sdb.
```Bash
dd if=/dev/sda of=/dev/sdb
```

## How to dd a remote disk using SSH on local machine and save to a local disk
https://unix.stackexchange.com/questions/132797/how-to-dd-a-remote-disk-using-ssh-on-local-machine-and-save-to-a-local-disk

### run from remote computer
```Bash
$ dd if=/dev/sda | gzip -1 - | ssh user@local dd of=image.gz
```

### run from local computer
```Bash
$ ssh user@remote "dd if=/dev/sda | gzip -1 -" | dd of=image.gz
```
