# Administración de recursos compartidos:
- Instalación y configuración de servicios
- Administración del acceso a recursos. SMB/CIFS. SAMBA. NFS.
- Grupos de trabajo.
- Permisos de red. Permisos locales. Herencia. Permisos efectivos.

--------------

# Ejecicios sobre almacenamiento (discos, carpetas compartidas, etc.)
## PowerShell
### Crear un script en que detecta unidades compartidas y mueve los ficheros que contienen a otra unidad
Detectar uni#dades
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk”)
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk”).DeviceID
```
```PowerShell
GET-WMIOBJECT –query “SELECT * from win32_logicaldisk where DriveType = 3”
```
```PowerShell
GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID
```
```PowerShell
(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "q:"
```
```PowerShell
Get-ChildItem (GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
Get-ChildItem $unidad
```
```PowerShell
$unidad=(GET-WMIOBJECT –query “SELECT * from win32_logicaldisk” | Select-Object DeviceID).DeviceID | Select-String "c:"
$unidad
Get-ChildItem $unidad -Recurse
```
```PowerShell
Get-ChildItem c:\ -Recurse *.txt
Get-ChildItem c:\ -Recurse *.txt | %{copy-Item $_ $dondequierase}
```

### Create a drive mapped to a network share
https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/new-psdrive?view=powershell-6
```PowerShell
New-PSDrive -Name "P" -PSProvider "FileSystem" -Root "\\Server01\Public"
```

## Linux

### Repaso de ficheros de configuración en Linux

#### Network
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-02-20.md#repaso-de-ficheros-de-configuraci%C3%B3n-en-linux

### Montar un sistema SMB
```Bash
sudo mount -t cifs //10.0.1.101/copias /mnt/backup
```

### Compartir carpetas en Linux
#### Access the Windows Share from Linux
https://www.howtogeek.com/176471/how-to-share-files-between-windows-and-linux/

```Bash
sudo apt-get install cifs-utils
mkdir ~/Desktop/Windows-Share 
sudo mount.cifs //WindowsPC/Share /home/jes/Desktop/Windows-Share -o user=jesusninoc
````

#### Create a Share on Linux and Access It from Windows
```Bash
# Instalar samba
sudo apt-get install samba

# Poner password al usuario
smbpasswd -a jesusninoc

# Carpeta que vamos a compartir
mkdir ~/Desktop/Share

# Editar el fichero de configuración
sudo vi /etc/samba/smb.conf

# Añadir contenido sobre la carpeta que vamos a compartir al fichero de configuración smb.conf
[<folder_name>]
path = /home/<user_name>/<folder_name> 
available = yes 
valid users = <user_name> 
read only = no 
browsable = yes 
public = yes 
writable = yes

# Reiniciar samba
sudo service smbd restart
```

### Conectarse desde GNU/Linux a una carpeta Windows compartida (Samba)
http://fraterneo.blogspot.com.es/2011/06/conectarse-desde-gnulinux-una-carpeta.html

--------------

# Carpetas compartidas
## The Win32_Share class represents a shared resource on a computer system running Windows
```PowerShell
gwmi Win32_Share
```
```PowerShell
get-WmiObject -class Win32_Share -computer dc1 -Credential dominio\administrador
```
## Network resources
```PowerShell
net view \\dc1
```
## Listing Network Drives
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/listing-network-drives
```PowerShell
$obj = New-Object -ComObject WScript.Network
$result = $obj.EnumNetworkDrives() 
Foreach ($entry in $result)
{
    $letter = $entry
    $null = $foreach.MoveNext()
    $path = $foreach.Current
  
  
    [PSCustomObject]@{
        DriveLetter = $letter
        UNCPath = $path
    }
}
```
## Get shares that are connected to a specific server
https://docs.microsoft.com/en-us/powershell/module/smbshare/get-smbshare?view=win10-ps
```PowerShell
Get-SmbShare -ScopeName "Contoso-FS"
```

--------------

# Ejercicio
## -Copiar el contenido de todas las carpetas compartidas que tengas en la red a una carpeta
## -Crear una carpeta compartida en Linux

--------------

# MySQL desde PowerShell

## Conectar a MySQL desde PowerShell
https://www.jesusninoc.com/2017/12/13/conectar-a-mysql-desde-powershell/

## Crear una tabla en una base de datos en MySQL con PowerShell
https://www.jesusninoc.com/2017/01/13/crear-una-tabla-en-una-base-de-datos-en-mysql-con-powershell/

## Insertar valores en una tabla de una base de datos en MySQL con PowerShell
https://www.jesusninoc.com/2017/01/17/insertar-valores-en-una-tabla-de-una-base-de-datos-en-mysql-con-powershell/

## Insert into MySQL database
https://www.jesusninoc.com/2015/12/14/insert-into-mysql-database/

## Almacenar la información enviada entre un cliente y un servidor en una base de datos MySQL con PowerShell
https://www.jesusninoc.com/2017/01/15/almacenar-la-informacion-enviada-entre-un-cliente-y-un-servidor-en-una-base-de-datos-mysql-con-powershell/

## Ejercicios curso MySQL con PowerShell
https://www.jesusninoc.com/2017/02/20/ejercicios-curso-mysql-con-powershell/

## Análisis de una petición a MySQL con SoftPerfect Network Protocol Analyzer
https://www.jesusninoc.com/2017/03/31/analisis-de-una-peticion-a-mysql-con-softperfect-network-protocol-analyzer/

--------------

# Posibles preguntas para el examen

- Pedir un proceso
  - Comprobar la ruta y el hash (hay un listado de hash para los programas que hay en el sistema)
  - Comprobar si hay algún drivers cambiado (hay un listado de hash para los drivers)
- Instalar programas en Ubuntu leyendo desde un fichero
- Ver versión de programas instalados, los antiguos hay que actualizarlos
- Actualización
- Control de acceso a programas
- Controladores, drivers
- Instalar y actualizar
- Qué proceso realizas para crear un usuario
- Crear y añadir usuarios
- El usuario con más privilegios
- Habilitar usuarios
- Seguridad en contraseñas
- Permisos, herencia, permisos efectivos
- Cambiar dueño usuario
- Carpetas compartidas
