# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

-----------------

# Firewall
## Enable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/16/enable-the-microsoft-windows-firewall/
## Disable the Microsoft Windows Firewall
https://www.jesusninoc.com/2016/05/15/disable-the-microsoft-windows-firewall/
## Finding Open Firewall Ports
```PowerShell
$firewall = New-object -ComObject HNetCfg.FwPolicy2
$firewall.Rules |  Where-Object {$_.Action -eq 0} | 
    Select-Object Name, ApplicationName,LocalPorts
```
## Log del Firewall
```Cmd
%systemroot%\system32\LogFiles\Firewall\pfirewall.log
```

-----------------

# Ejercicios
- Analizar la red del Centro, ¿qué detectas?, ¿DNS?
- Se puede comunicar dentro del la red por UDP, enviar el movimiento del ratón entre dos equipos.

-----------------

# 9. Gestión de la red en PowerShell (nivel intermedio)
* https://www.jesusninoc.com/07/09/9-gestion-de-la-red-en-powershell/

# Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/2015/11/13/cmdlets-for-tcpip-model-layers/

- Aplicación	DNS, DHCP, RIP, ...
- Transporte	TCP, UDP, ...
- Red	IP, ...
- Enlace	Ethernet, Token Ring,
- FDDI, ...

## Capa 1
- Conocer los interfaces físicos
```PowerShell
Get-Command -Module Net* | Group Module
Get-NetAdapter -Physical | Select-Object 
Get-NetIPAddress | Select-Object InterfaceAlias,IPAddress
```
- Bytes recibidos y transmitidos
```PowerShell
Get-NetAdapterStatistics
```
## Capa 2
### Arp
- MacAddress
- Conocer la MAC
- Entradas ARP
- Todas las formas de ver la MAC, por comandos
```PowerShell
arp -a | Select-String "((?:(\d{1,2}|[a-fA-F]{1,2}){2})(?::|-*)){6}" | Select-String "192.168"
```
```PowerShell
Get-NetNeighbor
Get-NetNeighbor | Select-Object IPAddress | Select-String "192.168"
```
### Switch
- ¿Estoy cerca de un switch?
- Visitar página con relación de MAC y fabricantes
- OUI: https://www.wireshark.org/tools/oui-lookup.html
- Identificar MAC con fabricante
- Intentar localizar el mayor número de nodos de red y dispositivos de acceso, tener en cuenta subred
- Tabla de direccionamiento switch?????
- Ver las direcciones MAC de difusión FFFFF y otros tipos quiénes son los vecinos
https://en.wikipedia.org/wiki/Multicast_address
- macs broadcast y demás
- Saltos switches, cuántos hay? utilizar tracert
- mac broadcast qué hace y donde va
- MITM

## Capa 3
- Conocer IP virtual y física
- ¿Ves alguna relación?
- Tipo red colegio privada y publica
- red apipa
- Relación entre rutas y los índices de tarjetas
```PowerShell
Get-NetRoute
```
- Rangos de ips y análisis de whois y demás
- Analizar las IP de la red
- Relación con ARP
- Mac relación netstat y arp -a
- Buscar IP en el registro
- Ping a subredes
```PowerShell
foreach($tercero in 1..254)
{
    foreach($cuarto in 1..254)
    {
        ping '192.168.'+$tercero+'.'+$cuarto
    }
}
```
https://www.jesusninoc.com/2017/07/14/recorrer-un-rango-de-direcciones-ip/
https://www.jesusninoc.com/2017/07/06/recorrer-direcciones-ip/
https://github.com/jesusninoc/PowerShell/blob/master/Red/EjemplosRed.ps1
### ICMP
- Qué es el ping (Internet)
- Hacer ping a direcciones de red
- Comprobar funcionamiento de comando: ping y tracert
```PowerShell
Test-NetConnection
```
- ip de google ping -a
- ip detectar servicio como Dropbox
### NAT
- explicar nat y pat
### Firewall
- bloquear ip firewall windows
http://www.itechlounge.net/2014/11/windows-blocking-ip-from-command-line/
- log del firewall

## Capa 4
- Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/
- IANA Y UDP 
http://www.jesusninoc.com/2016/03/02/relacion-entre-puertos-abiertos-udp-y-lista-de-puertos-de-la-iana/
- COMUNICACIÓN TCP UDP
- SOCKET, BIND, LISENT, ACCEPT, CONNECT, SEND, RECEIVE, CLOSE
- ABRIR UN PUERTO?
```PowerShell
netsh advfirewall firewall add rule name="Programa TCP 87" dir=in action=allow protocol=TCP localport=87
```
- Lista de puertos IANA
http://www.jesusninoc.com/2016/02/29/relacion-entre-puertos-abiertos-tcp-y-lista-de-puertos-de-la-iana/
- YA EN CAPA 4, DETECTAR PUERTOS Y DEMÁS....... TENGO MIS SCRIPTS LEYENDO DE RFC PUERTOS
- ¿CUÁL ES MI IP PÚBLICA?
http://www.jesusninoc.com/2015/02/28/cual-es-mi-ip-publica/
- reserva v4
https://isc.sans.edu/forums/diary/Reserved+IP+Address+Space+Reminder/13228
### TCP (Transmission Control Protocol)
- Settings
```PowerShell
Get-NetTCPSetting
```
- Gets information about current connection statistics
```PowerShell
Get-NetTCPConnection
```
- Ports
```PowerShell
Get-NetTCPConnection | Select-Object LocalPort,Remoteport
```
### UDP (User Datagram Protocol)
- Settings
```PowerShell
Get-NetUDPSetting
```
- Gets information about current connection statistics
```PowerShell
Get-NetUDPEndpoint
```
- Ports
```PowerShell
(Get-NetUDPEndpoint).LocalPort
```

## Capa 5,6,7
https://en.wikipedia.org/wiki/Category:Application_layer_protocols


--------------

# Virus y WMI
## Change values to different experience. Works on laptops. Future update will add desktop monitor support
* https://gist.github.com/M3T4L5T3F/a80366c999f256050e26287375c06260

## Desactivar la visualización de inmediato mediante PowerShell
* https://www.jesusninoc.com/07/17/desactivar-la-visualizacion-de-inmediato-mediante-powershell/

## Desactivar la visualización de inmediato desde PowerShell, abrir Notepad y escribir un texto
* https://www.jesusninoc.com/07/18/desactivar-la-visualizacion-de-inmediato-desde-powershell-abrir-notepad-y-escribir-un-texto/

## Una aproximación a los virus en PowerShell
* https://github.com/jesusninoc/Seguridad/blob/master/Una%20aproximaci%C3%B3n%20a%20los%20virus%20en%20PowerShell.md

--------------

# Contraseñas

## Contraseñas seguras con PowerShell
https://www.jesusninoc.com/contrasenas-seguras-con-powershell/

--------------

# Contraseñas y fuerza bruta

## Realizar petición HTTP desde PowerShell utilizando el método GET
https://www.jesusninoc.com/2018/03/31/realizar-peticion-http-desde-powershell-utilizando-el-metodo-get/

## Simular una fuerza bruta mediante peticiones HTTP desde PowerShell utilizando el método GET
https://www.jesusninoc.com/2018/04/01/simular-una-fuerza-bruta-mediante-peticiones-http-desde-powershell-utilizando-el-metodo-get/

## crunch
Crunch is a wordlist generator where you can specify a standard character set or a character set you specify. crunch can generate all possible combinations and permutations.
https://tools.kali.org/password-attacks/crunch

## CeWL
CeWL is a ruby app which spiders a given url to a specified depth, optionally following external links, and returns a list of words which can then be used for password crackers such as John the Ripper.
https://tools.kali.org/password-attacks/cewl

## HUNT: Data Driven Web Hacking & Manual Testing - JP Villanueva - AppSecUSA 2017
https://www.youtube.com/watch?v=IEak_-SG8xM

## Using Hydra To Crack The Door Open
https://hakin9.org/usinghydratocrackthedooropen/

```MS-DOS
hydra <ip>-s <puerto> http-form-post "/:user=^USER^&password=^PASS^:<Mensaje de error>" -l "" -P <diccionario> -t 10 -v -I -o <archivo de salida>
hydra IP http-form-post "/index.php:user=^USER^&pass=^PASS^:error_msg" -l admin -P dicc.txt
```
Ese ejemplo es suponiendo que:
- Hay un parametro user que quieres que sea "admin"
- Hay un parametro pass que lo va a ir probando de dicc.txt
- Cuando metes mal un login aparece entre otras cosas el texto "error_msg"

--------------

# Bases de datos y PowerShell
* https://www.jesusninoc.com/02/20/ejercicios-curso-mysql-con-powershell/
