# Administración de software de base

 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
   - Archivos de red sin conexión.
   - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
   - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Repaso de ficheros de configuración en Linux

## Network
http://www.yolinux.com/TUTORIALS/LinuxTutorialNetworking.html

## Netplan configuration examples
https://netplan.io/examples

### To instead set a static IP address, use the addresses key, which takes a list of (IPv4 or IPv6), addresses along with the subnet prefix length (e.g. /24). Gateway and DNS information can be provided as well:

```Bash
network:
  version: 2
  renderer: networkd
  ethernets:
    enp3s0:
      addresses:
        - 10.10.10.2/24
      gateway4: 10.10.10.1
      nameservers:
          search: [mydomain, otherdomain]
          addresses: [10.10.10.1, 1.1.1.1]
```

-----------------

# Sort IPv4 Addresses Correctly
http://community.idera.com/powershell/powertips/b/tips/posts/sort-ipv4-addresses-correctly

# Recorrer rango direcciones IP
* https://www.jesusninoc.com/2017/07/14/recorrer-un-rango-de-direcciones-ip/
* https://www.jesusninoc.com/2017/07/06/recorrer-direcciones-ip/
* https://github.com/jesusninoc/PowerShell/blob/master/Red/EjemplosRed.ps1

# Puertos abiertos
## Si está abierto parece que no hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",25,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Si no está abierto hay resultado
```PowerShell
$tcpobject = New-Object System.Net.Sockets.TcpClient 
$connect = $tcpobject.BeginConnect("127.0.0.1",215,$null,$null)
    
# wait for the connection no longer than $timeoutMilliseconds 
$wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false)
$tcpobject.EndConnect($connect) 
```
## Scanning Ports
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/scanning-ports
```PowerShell
function Get-PortInfo
{
    param
    (
        [Parameter(Mandatory)]
        [Int]
        $Port,
    
        [Parameter(Mandatory)]
        [Int]
        $TimeoutMilliseconds,
        
        [String]
        $ComputerName = $env:COMPUTERNAME
    )
  
    # try and establish a connection to port async
    $tcpobject = New-Object System.Net.Sockets.TcpClient 
    $connect = $tcpobject.BeginConnect($computername,$port,$null,$null)
    
    # wait for the connection no longer than $timeoutMilliseconds 
    $wait = $connect.AsyncWaitHandle.WaitOne($timeoutMilliseconds,$false) 
    
    # return rich information
    $result = @{
        ComputerName = $ComputerName
    }
    
    if(!$wait) { 
        # timeout
        $tcpobject.Close() 
        $result.Online = $false
        $result.Error = 'Timeout'
    } else { 
        try { 
            # try and complete the connection
            $null = $tcpobject.EndConnect($connect)
            $result.Online = $true
        }
        catch { 
            $result.Online = $false
        } 
        $tcpobject.Close() 
    } 
    $tcpobject.Dispose()
    
    [PSCustomObject]$result
} 
```
