# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------------

# Nuevo tema de red

## Análisis de conexiones de red
https://www.jesusninoc.com/2017/05/01/analisis-de-conexiones-de-red/

## Equivalencias entre comandos de red de Windows y cmdlets de PowerShell
https://www.jesusninoc.com/2016/02/04/equivalencias-entre-comandos-de-red-de-windows-y-cmdlets-de-powershell/

## Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/2015/11/13/cmdlets-for-tcpip-model-layers/

## Realizar conexiones TCP/UDP con Powershell
https://www.jesusninoc.com/2015/11/10/realizar-conexiones-tcp-udp-con-powershell/

## Ejemplos de redes básicos

```PowerShell
1..254|%{$_}
1..254|%{"192.168.1."+$_}
1..254|%{$ip="192.168.1."+$_;$ip}
1..254|%{$ip="192.168.1."+$_;ping $ip}
1..254|%{$ip="192.168.1."+$_;ping $ip;arp -a $ip}
1..254|%{$ip="192.168.1."+$_;$ip;arp -a | Select-String $ip}
```
```PowerShell
Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress
```
```PowerShell
[String]$a=(Get-NetNeighbor | Where-Object IPAddress -EQ 192.168.204.190 | Select-Object LinkLayerAddress)
$a.Substring(3,3)
```

## Ejercicio sobre la red

Analizar la siguiente información utilizando la red:
- Aplicaciones instaladas
- Ver si hay IP repetida
- Comprobar si hay fallo en red por culpa de IP repetida
- Comprobar que los equipos se han creado correctamente con el nombre de dominio correcto
- Ver rango de IP en Wifi
- Ver rango de IP en VDI
- ¿Qué usuario ha iniciado sesión?
- Realizar un inventario de la red (PDQ Inventory Tracks It All https://www.pdq.com/pdq-inventory/)

```PowerShell
Invoke-Command -ScriptBlock{([System.Security.Principal.WindowsIdentity]::GetCurrent()).name} -ComputerName 192.168.1.56 -Credential (Get-Credential)
```
```PowerShell
$p = Get-WmiObject win32_process -filter "name='explorer.exe'" -ComputerName 192.168.1.56 -Credential (Get-Credential)
$p.getowner().user
```

--------------------

# Configurar un túnel utilizando un servidor SSH
https://www.jesusninoc.com/2016/02/08/configurar-un-tunel-utilizando-un-servidor-ssh/

--------------------

# Post Exploitation
## Post Exploitation Command List Wiki
https://github.com/mubix/post-exploitation/wiki

## Linux Post Exploitation Command List
https://github.com/mubix/post-exploitation/wiki/Linux-Post-Exploitation-Command-List

## Post Exploitation without Automated Tools (pdf) - InfoSec Resources
This book acts as an introduction to those who know how to use Metasploit and do not know what happens behind the screens.
http://resources.infosecinstitute.com/wp-content/uploads/Post-Exploitation-without-Automated-Tools1.pdf

--------------------

# Ejecutar PHP
## Ejecutar código PHP desde PowerShell
https://www.jesusninoc.com/2017/03/01/ejecutar-codigo-php-desde-powershell/
## Ejecutar un cmdlet de PowerShell desde PHP
https://www.jesusninoc.com/2018/01/06/ejecutar-un-cmdlet-de-powershell-desde-php/
## Ejecutar en PHP un cmdlet de PowerShell en Base64
https://www.jesusninoc.com/2018/02/21/ejecutar-en-php-un-cmdlet-de-powershell-en-base64/

--------------------

# Acceso remoto

Utilities like Telnet and remote control programs like Symantec's PC Anywhere let you execute programs on remote systems, but they can be a pain to set up and require that you install client software on the remote systems that you wish to access. PsExec is a light-weight telnet-replacement that lets you execute processes on other systems, complete with full interactivity for console applications, without having to manually install client software. PsExec's most powerful uses include launching interactive command-prompts on remote systems and remote-enabling tools like IpConfig that otherwise do not have the ability to show information about remote systems.

https://docs.microsoft.com/en-us/sysinternals/downloads/psexec

## Ejemplo psexec
```PowerShell
psexec -u jesusninoc\administrador \\2017lti1-19 -i -d cmd /c notepad
psexec -u jesusninoc\administrador \\192.168.104.122 -i -d cmd /c powershell -encodedcommand RwBlAHQALQBEAGEAdABlAA=="
psExec.exe -i \\192.168.1.56 powershell f:\script.ps1 #script.ps1 tiene que existir en el equipo remoto
```
## Starts an interactive session with a remote computer (PowerShell)
```PowerShell
Enter-PSSession -ComputerName 2017lti1-19
```
## Crear una tarea programada en un equipo remoto
```PowerShell
1..254 | %{Invoke-Command -ComputerName ('192.168.1.'+$_) {Register-ScheduledTask Task01 -Action (New-ScheduledTaskAction -Execute "Cmd") -Principal (New-ScheduledTaskPrincipal -GroupId "BUILTIN\administradores" -RunLevel Highest) -Settings (New-ScheduledTaskSettingsSet -RestartCount 5 -RestartInterval 60)}}
```
## Copssh - OpenSSH for Windows
https://itefix.net/copssh

## Introducción a la automatización en PowerShell
https://www.jesusninoc.com/2017/03/06/introduccion-a-la-automatizacion-en-powershell/

## Automation
https://www.jesusninoc.com/automation/

## Mover el ratón a varias posiciones
https://www.jesusninoc.com/2015/01/18/mover-el-raton-a-varias-posiciones/

## Mover Notepad de una posición de la pantalla a otra y escribir un texto dentro del proceso
https://www.jesusninoc.com/2016/03/23/mover-notepad-de-una-posicion-de-la-pantalla-a-otra-y-escribir-un-texto-dentro-del-proceso/

## Mover un proceso en diagonal de una posición de la pantalla a otra y que siempre permanezca en primer plano
https://www.jesusninoc.com/2016/04/11/mover-un-proceso-en-diagonal-de-una-posicion-de-la-pantalla-a-otra-y-que-siempre-permanezca-en-primer-plano/

## Mover un proceso en horizontal de una posición de la pantalla a otra y que siempre permanezca en primer plano
https://www.jesusninoc.com/2016/02/28/mover-un-proceso-en-horizontal-de-una-posicion-de-la-pantalla-a-otra-y-que-siempre-permanezca-en-primer-plano/

## Activar y mover un proceso de una posición de la pantalla a otra
https://www.jesusninoc.com/2016/02/20/activar-y-mover-un-proceso-de-una-posicion-de-la-pantalla-a-otra/

## Mover un proceso de una posición de la pantalla a otra
https://www.jesusninoc.com/2016/02/03/mover-un-proceso-de-una-posicion-de-la-pantalla-a-otra/

--------------------

# Servidor de correo

## SMTP
https://www.jesusninoc.com/2015/01/12/instalar-hmailserver-imap-smtp-y-pop3/

--------------------

# Cron
## Crear una tarea en el cron
https://www.jesusninoc.com/2016/02/13/crear-una-tarea-en-el-cron/

## Programar una tarea cada cinco minutos, la tarea que hay que programas es (crear un log que añada el contenido)
https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh

## Crear un archivo JSON con la programación de Movistar+
https://www.jesusninoc.com/2018/06/26/crear-un-archivo-json-con-la-programacion-de-movistar/

--------------------

# Antivirus y virus
* https://www.jesusninoc.com/2017/07/05/5-gestion-del-software-en-powershell/
* https://www.jesusninoc.com/antivirus/

## Vulnerability
* https://www.jesusninoc.com/vulnerability/

## Una aproximación a los virus en PowerShell
* https://github.com/jesusninoc/Seguridad/blob/master/Una%20aproximaci%C3%B3n%20a%20los%20virus%20en%20PowerShell.md

## Virus examples
* https://www.symantec.com/security_response/landing/threats.jsp
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-012722-4614-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-031313-1110-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-112410-5327-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051114-5305-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052722-4205-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051817-0655-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052017-5535-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-051210-1139-99&tabid=2
* https://www.symantec.com/security_response/writeup.jsp?docid=2016-052615-4530-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-012722-4614-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2002-111216-5350-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2009-061215-3706-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2009-063005-3448-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2010-100614-5201-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-031313-1110-99
* https://www.symantec.com/security_response/writeup.jsp?docid=2001-112410-5327-99

## VirusTotal
* https://www.virustotal.com/#/home/upload

## Upload a suspected infected file (Retail)
* https://submit.symantec.com/websubmit/retail.cgi

# Ideas sobre comportamientos de troyanos
## Grabar audio
* http://www.jesusninoc.com/2015/06/27/grabar-audio-desde-la-linea-de-comandos/

## Keylogger
* https://www.jesusninoc.com/03/11/keylogger-sencillo-con-powershell/

# Enviar un cmdlet a un servidor y ejecutarlo
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()
```

## Cliente (manda un cmdlet al servidor)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

# Enviar un cmdlet a un servidor, ejecutarlo y mostrar el resultado de la ejeucción en el cliente
https://www.jesusninoc.com/12/29/server-and-client/

## Servidor (que ejecuta lo que manda el cliente y devuelve el resultado de la ejecución al cliente)
```PowerShell
##Server
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
$respuesta=[Text.Encoding]::ASCII.GetString($content)  | iex
$udpclient.Dispose()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes($respuesta)
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()
```

## Cliente (manda un cmdlet al servidor y muestra la respuesta que manda el servidor de lo que ha ejecutado)
```PowerShell
##Client
$port=2020
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient
$b=[Text.Encoding]::ASCII.GetBytes('gps')
$bytesSent=$udpclient.Send($b,$b.length,$endpoint)
$udpclient.Close()

$port=2021
$endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Any,$port)
$udpclient=new-Object System.Net.Sockets.UdpClient $port
$content=$udpclient.Receive([ref]$endpoint)
[Text.Encoding]::ASCII.GetString($content)
$udpclient.Dispose()
```

--------------

# Simular ransomware
## Algoritmo de cifrado sencillo
https://www.jesusninoc.com/2016/03/06/algoritmo-de-cifrado-sencillo-2/
## Algoritmo de descifrado sencillo
https://www.jesusninoc.com/2016/03/07/algoritmo-de-descifrado-sencillo-2/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/01/23/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto (enviar la clave utilizada en el algoritmo mediante una petición web a un servidor)
https://www.jesusninoc.com/2017/05/16/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-enviar-la-clave-utilizada-en-el-algoritmo-mediante-una-peticion-web-a-un-servidor/
## Descifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto
https://www.jesusninoc.com/2017/05/18/descifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto/
## Cifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/18/cifrar-utilizando-una-clave-secreta/
## Descifrar utilizando una clave secreta
https://www.jesusninoc.com/2015/08/20/descifrar-utilizando-una-clave-secreta/
## Aproximación al cifrado y descifrado en PowerShell
https://www.jesusninoc.com/2017/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/

# Simular ransomware y subir por SSH
## Subir un fichero por SSH a un servidor Linux desde PowerShell en Windows
https://www.jesusninoc.com/2017/11/02/subir-un-fichero-por-ssh-a-un-servidor-linux-desde-powershell-en-windows/
## Cifrar con un algoritmo sencillo el nombre y el contenido de un fichero de texto y subirlo por SSH a un servidor Linux
https://www.jesusninoc.com/2017/11/13/cifrar-con-un-algoritmo-sencillo-el-nombre-y-el-contenido-de-un-fichero-de-texto-y-subirlo-por-ssh-a-un-servidor-linux/
## Utilizar tail -f en Windows Server 2003 con Copssh
https://www.jesusninoc.com/2009/05/21/utilizar-tail-f-en-windows-server-2003-con-copssh/

# SSH
## Configurar un túnel utilizando un servidor SSH
https://www.jesusninoc.com/2016/02/08/configurar-un-tunel-utilizando-un-servidor-ssh/
## Configurar Firefox para utilizar un túnel SSH como un proxy SOCKS
https://www.jesusninoc.com/2016/02/09/configurar-firefox-para-utilizar-un-tunel-ssh-como-un-proxy-socks/
## Realizar conexión con WinSCP utilizando un túnel SSH
https://www.jesusninoc.com/2016/02/12/realizar-conexion-con-winscp-utilizando-un-tunel-ssh/
## Conexión entre Bash Bunny y el equipo con PuTTY a través de la conexión de red IBM USB Remote NDIS Network Device
https://www.jesusninoc.com/2017/04/14/conexion-entre-bash-bunny-y-el-equipo-con-putty-a-traves-de-la-conexion-de-red-ibm-usb-remote-ndis-network-device/

# SCP
## Digging in to SCP Command Injection
https://dylankatz.com/digging-in-to-scp-command-injection/

# Acceso remoto
## Powershell + psExec
http://bertdotself.com/powershell-psexec/

## Acceso remoto desde Powershell
```PowerShell
Invoke-Command -Credential administrador -ComputerName 192.168.1.56 -ScriptBlock{hostname} 
```
## Netcat Cheat Sheet
https://www.sans.org/security-resources/sec560/netcat_cheat_sheet_v1.pdf

# Herramientas de seguridad
## MobaXterm
https://www.jesusninoc.com/2016/01/19/mobaxterm/

## THC-Hydra
https://www.jesusninoc.com/2015/03/11/thc-hydra/

