# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

# Seguridad en Linux

## Linux Shell script to add a user with a password to the system
https://www.cyberciti.biz/tips/howto-write-shell-script-to-add-user.html

--------------

# Permisos en Windows

## Obtener los descriptores de seguridad de todos los ficheros de una unidad
https://www.jesusninoc.com/2016/09/10/obtener-los-descriptores-de-seguridad-de-todos-los-ficheros-de-una-unidad/

## Eliminar permisos explícitos
https://www.jesusninoc.com/2016/03/30/eliminar-permisos-explicitos/

## Añadir permiso NTFS a una carpeta
https://www.jesusninoc.com/2015/08/19/anadir-permiso-ntfs-a-una-carpeta/

## Crear un recurso compartido y asignar permisos al recurso
https://www.jesusninoc.com/2015/06/09/crear-un-recurso-compartido-y-asignar-permisos-al-recurso/

## Clonar permisos NTFS
https://www.jesusninoc.com/2015/01/23/clonar-permisos-ntfs/

## PENTESTER’S WINDOWS NTFS TRICKS COLLECTION
https://www.sec-consult.com/en/blog/2018/06/pentesters-windows-ntfs-tricks-collection/
  
--------------

# Examen

## Crear usuarios

### En PowerShell (en Windows Server leyendo los usarios de la configuración actual del Directorio Activo del Centro con Win32_UserAccount)
```PowerShell
Get-WmiObject Win32_UserAccount | % {
    Invoke-Command -ScriptBlock {New-LocalUser $_.name -WhatIf} -ComputerName .
}
```
### Leyendo los usuarios desde un fichero en Linux
```PowerShell
wsl cat /root/usuarios.txt | %{
    New-LocalUser $_ -whatif
}
```

### Crear usuarios en Linux, leyendo de un fichero
```Bash
cat usuarios.txt | xargs -I{} useradd {}
```
