# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuario SYSTEM en Windows
* [https://windowstips.wordpress.com/2011/01/10/system-causa-y-efecto-i-de-iv/](https://windowstips.wordpress.com/2011/01/10/system-causa-y-efecto-i-de-iv/)
* [https://windowstips.wordpress.com/2011/01/11/system-causa-y-efecto-ii-de-iv/](https://windowstips.wordpress.com/2011/01/11/system-causa-y-efecto-ii-de-iv/)

## Ejercicio script de creación de usuarios en AD
```PowerShell
Import-Module ActiveDirectory
Import-Csv C:\Users\Administrador\Desktop\CrearAlumnos\Mis_Usuarios.csv |%{
$nombreco=$_.FirstName + " " + $_.LastName
$ru="OU=" + $_.Curso + ",OU=FP,OU=Alumnos,OU=Usuarios,DC=retared,DC=local"
$HomeDirectory="\\alumnos\fp\" + $_.Curso + "\" + $_.sAMAccountname
mkdir $HomeDirectory
$HomeDirectory
$HomeDrive=’Q:’
New-ADUser -Name $_.FirstName -SamAccountName $_.sAMAccountname -HomeDrive $HomeDrive –HomeDirectory $HomeDirectory -DisplayName $nombreco -Enabled $true -ChangePasswordAtLogon $false -AccountPassword (ConvertTo-SecureString $_.Password -AsPlainText -force) -PassThru -UserPrincipalName $_.sAMAccountname -Path $ru
$usereta="retared\" + $_.sAMAccountname + ":F"
$HomeDirectory + "-" + $usereta
cacls $HomeDirectory /G $usereta /E
Add-ADGroupMember -Identity "CN=alumni,CN=Builtin,DC=reto,DC=local" $_.sAMAccountname
}
```

## Más sobre usuarios en AD
* https://github.com/jesusninoc/ClasesASO/blob/master/2019-09-24.md

--------------

# Passwords

## ENCONTRAR UN PASSWORD QUE CONTIENE LOS NÚMEROS DE LA PRIMERA FILA DEL TECLADO QWERTY GENERANDO COMBINACIONES ALEATORIAS
https://www.jesusninoc.com/01/20/encontrar-un-password-que-contiene-los-numeros-de-la-primera-fila-del-teclado-qwerty-generando-combinaciones-aleatorias/

## Contraseñas seguras con PowerShell
https://www.jesusninoc.com/contrasenas-seguras-con-powershell/

## Cracking Passwords Version 1.1
https://repo.zenk-security.com/Reversing%20.%20cracking/Cracking_Passwords_Guide.pdf

## Privilege Escalation without Automated Tools - InfoSec Resources
https://securitydocs.com/privilege-escalation-without-automated-tools-infosec-resources/38418/

--------------

# Random

## Ejercicio PowerShell: adivinar un número aleatorio que genera PowerShell

```PowerShell
#Generar un número aleatorio entre 1 y 100
Get-Random (1..100)
```
```PowerShell
#Pedir al usuario un número una vez e intentar adivinar el número aleatorio que se ha generado
$numeroadivinar=Get-Random (1..100)
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100
$numeroadivinar=Get-Random (1..100)
while($true)
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
if($numeroadivinar -eq $a)
{
"Número adivinado"
#Si se adivina el número salir del bucle while con break
break
}
}
```
```PowerShell
#Pedir al usuario números para intentar adivinar un número aleatorio entre 1 y 100, ofrecer ayuda al usuario para adivinar el número
$numeroadivinar=Get-Random (1..100)
do
{
$a=Read-Host "Intentar adivinar un número, introduzca número"
switch($numeroadivinar)
{
{$_ -le $a -and $_ -ge 1}{Write-Host "No adivinado, el número es menor que $a" -ForegroundColor red}
{$_ -eq $a}{Write-Host "Número adivinado" -BackgroundColor Blue;break}
{$_ -ge $a -and $_ -le 100}{Write-Host "No adivinado, el número es mayor que $a" -ForegroundColor red}
}
#Si el número está adivinado acabar de preguntar al usuario
}while(!($numeroadivinar -eq $a))
```

## Más sobre random
### Generar letras aleatorias
https://www.jesusninoc.com/2017/10/11/generar-letras-aleatorias/

### Generate Random Text based on Length
https://www.commandlinefu.com/commands/view/24101/generate-random-text-based-on-length

### Ejercicios de PowerShell: mostrar y escribir una letra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/02/ejercicios-de-powershell-mostrar-y-escribir-una-letra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Generar palabras aleatorias con letras aleatorias
https://www.jesusninoc.com/2017/01/07/generar-palabras-aleatorias-con-letras-aleatorias/

### Ejercicios de PowerShell: mostrar y escribir una palabra aleatoria por consola en el menor tiempo posible con PowerShell
https://www.jesusninoc.com/2017/09/05/ejercicios-de-powershell-mostrar-y-escribir-una-palabra-aleatoria-por-consola-en-el-menor-tiempo-posible-con-powershell/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera
https://www.jesusninoc.com/2017/03/01/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera/

### Ejercicios de PowerShell: crear el juego de piedra, papel o tijera (script en una línea)
https://www.jesusninoc.com/2017/03/02/ejercicios-de-powershell-crear-el-juego-de-piedra-papel-o-tijera-script-en-una-linea/

### Tres en raya
```Java
private int[][] lineaGanadora = new int[][] { { 0, 1, 2 }, { 3, 4, 5 }, { 6, 7, 8 }, { 0, 3, 6 }, { 1, 4, 7 }, { 2, 5, 8 }, { 0, 4, 8 }, { 2, 4, 6 } };
```

--------------

# Ejercicio de password y random
## Crear usuarios con un password random e intentar adivinarlo con Cain y Abel
```PowerShell
(((1..9) | Get-Random -Count 4) -join "") + (((97..99) | Get-Random -Count 2 | % {[char]$_}) -join "") + (((65..67) | Get-Random -Count 2 | % {[char]$_}) -join "")
```
## Cain y Abel
* https://github.com/xchwarze/Cain

--------------------

# Proyecto 2ª Guerra Mundial

## Detección y análisis
### Detectar un mensaje enviado en código Morse mediante sonidos utilizando la tarjeta de sonido y el programa SDRSharp 
* https://www.jesusninoc.com/01/04/detectar-un-mensaje-enviado-en-codigo-morse-mediante-sonidos-utilizando-la-tarjeta-de-sonido-y-el-programa-sdrsharp/
### Analizar frecuencias de audio con SDRSharp
* https://www.jesusninoc.com/04/29/analizar-frecuencias-de-audio-con-sdrsharp/
### Detectar una frecuencia de sonido emitida desde un dispositivo utilizando la tarjeta de sonido y el programa SDRSharp
* https://www.jesusninoc.com/2017/01/01/detectar-una-frecuencia-de-sonido-emitida-desde-un-dispositivo-utilizando-la-tarjeta-de-sonido-y-el-programa-sdrsharp/
### Analizar frecuencias de audio con SDRSharp (reconocer la palabra hola)
* https://www.jesusninoc.com/2017/01/31/analizar-frecuencias-de-audio-con-sdrsharp-reconocer-la-palabra-hola/
### Detectar micrófono espía con CNN-rtlsdr (deep learning signal classification using rtl-sdr dongle)
* https://www.jesusninoc.com/01/23/detectar-microfono-espia-con-cnn-rtlsdr-deep-learning-signal-classification-using-rtl-sdr-dongle/
### Neural Network signal recognition rtlsdr
* https://www.jesusninoc.com/12/15/neural-network-signal-recognition-rtlsdr/
### Escanear frecuencias y clasificar las señales encontradas
* https://www.jesusninoc.com/01/10/escanear-frecuencias-y-clasificar-las-senales-encontradas/
### Analizar las señales de radio y convertir a texto con Bing Speech API
* https://www.jesusninoc.com/01/13/analizar-las-senales-de-radio-y-convertir-a-texto-con-bing-speech-api/
### Automatizar SDRSharp con PowerShell
* https://www.jesusninoc.com/03/03/automatizar-sdrsharp-con-powershell-parte-1/
* https://www.jesusninoc.com/03/12/automatizar-sdrsharp-con-powershell-parte-2/
* https://www.jesusninoc.com/03/15/automatizar-sdrsharp-con-powershell-parte-3/
* https://www.jesusninoc.com/03/19/automatizar-sdrsharp-con-powershell-parte-4/
* https://www.jesusninoc.com/03/21/automatizar-sdrsharp-con-powershell-parte-5/

## Aviones
### Descodificar señales ADS-B en Windows con dump1090
*  https://www.jesusninoc.com/05/02/descodificar-senales-ads-b-en-windows-con-dump1090/
### Detectar señales ADS-B con dump1090 en Windows con PowerShell
* https://www.jesusninoc.com/10/22/detectar-senales-ads-b-con-dump1090-en-windows-con-powershell/

## Noticias
### Cómo encontrar cámaras ocultas y equipo de espías como un profesional: La Guía Definitiva
Solo en los últimos dos años, hemos visto un aumento en el uso de cámaras ocultas y equipos de espionaje en formas infames, dirigidas a los huéspedes que permanecen en las líneas de cruceros, en las habitaciones de hoteles, en las casas de Airbnb, y la lista continúa. Desafortunadamente, esta tendencia no parece desaparecer pronto, pero puede, sin embargo, tomar medidas para asegurarse de que no sea una víctima. En este post, te mostraremos exactamente cómo hacerlo.
https://r3dbird.blogspot.com/2019/01/como-encontrar-camaras-ocultas-y-equipo.html

### Cazadores de espías en la Junta de Andalucía y empresas sevillanas
https://sevilla.abc.es/sevilla/sevi-caza-espias-junta-andalucia-201901222128_noticia.html

### Detectar micrófono espía con CNN-rtlsdr (deep learning signal classification using rtl-sdr dongle)
https://www.jesusninoc.com/01/23/detectar-microfono-espia-con-cnn-rtlsdr-deep-learning-signal-classification-using-rtl-sdr-dongle/
