# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Más ejercicios sobre usuarios en PowerShell

  - Ver el SID (Security Identifier) de un usuario en Windows con PowerShell
  - Verificar si existe un usuario en Windows 10 con PowerShell
  - Obtener los SID de las cuentas de usuario en Windows 10
  - Cmdlets relacionados con la gestión de cuentas locales en Windows 10
  - Creates a local user account
  - Creates a local security group
  - Gets local user accounts
  - Gets members from a local group
  - Gets the local security groups
  - Añadir usuarios a un grupo local en Windows 10 con PowerShell 5.1
  - Listar miembros de un grupo local en Windows 10 con PowerShell 5.1
  - Cambiar la contraseña a un usuario local en Windows 10 con PowerShell 5.1
  - Listar grupos locales en Windows 10 con PowerShell 5.1
  - Listar usuarios locales en Windows 10 con PowerShell 5.1
  - Eliminar un grupo local en Windows 10 con PowerShell 5.1
  - Crear un grupo local en Windows 10 con PowerShell 5.1
  - Crear un usuario local con contraseña en Windows 10 con PowerShell 5.1
  - Eliminar un usuario local en Windows 10 con PowerShell 5.1
  - Crear un usuario local en Windows 10 con PowerShell 5.1
  - Crear un usuario con contraseña leyendo los datos de un fichero
  - Cambiar contraseña a un usuario
  - Contar el número de grupos que hay en el sistema
  - Contar el número de usuarios que hay en el sistema
  - List local groups
  - List local users
  - Añadir un usuario a un grupo
  - Crear un grupo
  - Crear un usuario con contraseña
  - Usuario actual
  - Information about group accounts
  - Information about user accounts
  - Cmdlets relacionados con tareas básicas y de administración en el sistema operativo Windows
  - Reading username and password from file and do a login
  - Create users and groups, add a user to a group and share directory
  - Create users with passwords
  - Information about remote user

## CONVERTIR A JSON EL LISTADO DE USUARIOS QUE HAY EN EL SISTEMA EJECUTANDO UN CMDLET CON POWERSHELL
* https://www.jesusninoc.com/02/05/convertir-a-json-el-listado-de-usuarios-que-hay-en-el-sistema-ejecutando-un-cmdlet-con-powershell/

## UTILIZAR JSON CON NOMBRES Y APELLIDOS ALEATORIOS
* https://www.jesusninoc.com/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

## REGISTRAR Y MOSTRAR UN EVENTO EN POWERSHELL CUANDO SE CREA UN USUARIO
* https://www.jesusninoc.com/02/16/registrar-y-mostrar-un-evento-en-powershell-cuando-se-crea-un-usuario/

--------------

# Gestión de usuarios en Windows (Server)

## Instalación de servicios de directorio

# Administración de servicio de directorio

## Active Directory
* http://sec.cs.kent.ac.uk/x500book/
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-02-18.md
* http://www.developandsys.es/category/windows-server/active-directory/
* http://www.developandsys.es/gestion-objetos-active-directory/

### Instalación, configuración, objetos, relaciones de confianza, gpos, rodc, dc secundario (versión core)
* http://www.developandsys.es/category/windows-server/active-directory/

## OpenLDAP, Samba y Samba DC
* http://www.developandsys.es/?s=open+ldap
* http://www.developandsys.es/nfs-y-samba/

## Filtros LDAP

### UTILIZAR UN FILTRO LDAP PARA LOCALIZAR UN USUARIO
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
### UTILIZAR UN FILTRO LDAP PARA VERIFICAR LA HORA DEL ÚLTIMO INICIO DE SESIÓN DE LOS USUARIOS DEL ACTIVE DIRECTORY
* https://www.jesusninoc.com/07/05/utilizar-un-filtro-ldap-para-verificar-la-hora-del-ultimo-inicio-de-sesion-de-los-usuarios-del-active-directory/

## Crear usuarios leyendo desde un fichero (explicar fichero y bucle foreach)
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Ficheros
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Bucle_Foreach

## Cmdlets para Active Directory
* http://www.developandsys.es/gestion-objetos-active-directory/

## Crear en AD usuarios y OU leyendo de un fichero
```PowerShell
foreach($elemento in Get-Content .\crear.txt)
{
    $elemento
    New-ADUSer -Name $elemento -Sam $elemento -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    Start-Sleep -Seconds 5
}

foreach($elemento in Get-Content .\crear.txt)
{
    $elemento.split(",")[0]
}

foreach($elemento in Get-Content .\crear.txt)
{
    if($elemento.split(",")[0] -eq 1)
    {
        "crear ou " + $elemento.split(",")[1]
    }
    
    if($elemento.split(",")[0] -eq 2)
    {
        "crear user " + $elemento.split(",")[1]
        New-ADUSer -Name $elemento.split(",")[1] -Sam $elemento.split(",")[1] -Path "OU=Localizacion,DC=Dominio,DC=Local" -AccountPassword (ConvertTo-SecureString "Contra$ena" -AsPlainText -force) -Enable $true
    }
}
```

--------------

# Proyecto 2ª Guerra Mundial

## Enviar señales (audio)
### PRONUNCIAR TEXTOS CON DISTINTAS VOCES DEL SISTEMA OPERATIVO
* https://www.jesusninoc.com/11/22/pronunciar-textos-con-distintas-voces-del-sistema-operativo/
### Crear un audio que vamos a mandar mediante señales de radio
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-01-01.md#crear-un-audio-que-vamos-a-mandar-mediante-se%C3%B1ales-de-radio
### Subir el audio a Raspberry Pi realizando una conexión SCP
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-01-01.md#subir-el-audio-a-raspberry-pi-realizando-una-conexi%C3%B3n-scp
### Enviar mediante señales de radio el fichero que hemos subido
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-01-01.md#enviar-mediante-se%C3%B1ales-de-radio-el-fichero-que-hemos-subido

## Código Morse
* https://www.jesusninoc.com/10/27/morse-code/

## Detección y análisis
### Detectar un mensaje enviado en código Morse mediante sonidos utilizando la tarjeta de sonido y el programa SDRSharp 
* https://www.jesusninoc.com/01/04/detectar-un-mensaje-enviado-en-codigo-morse-mediante-sonidos-utilizando-la-tarjeta-de-sonido-y-el-programa-sdrsharp/
### Analizar frecuencias de audio con SDRSharp
* https://www.jesusninoc.com/04/29/analizar-frecuencias-de-audio-con-sdrsharp/
### Detectar una frecuencia de sonido emitida desde un dispositivo utilizando la tarjeta de sonido y el programa SDRSharp
* https://www.jesusninoc.com/2017/01/01/detectar-una-frecuencia-de-sonido-emitida-desde-un-dispositivo-utilizando-la-tarjeta-de-sonido-y-el-programa-sdrsharp/
