# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Ejercicios sobre usuarios en PowerShell
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuarios.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjerciciosUsuariosFicheros.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Usuarios/EjemplosCrearUsuariosGruposCarpetaCompartida2.ps1
* https://www.jesusninoc.com/2012/12/30/add-users-xml/
* https://www.jesusninoc.com/05/16/utilizar-un-filtro-ldap-para-localizar-un-usuario/
* https://www.jesusninoc.com/users/

## Crear usuarios leyendo de un fichero el user y password
```PowerShell
gc .\usuarios.txt | %{
    $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
    New-LocalUser $_.split(",")[0] -Password $pass
}
```

## Crear y eliminar usuarios
```PowerShell
"asir1,p@ssword1" > usuarios.txt
"asir2,p@ssword2" >> usuarios.txt
"asir3"  >> usuarios.txt

#####

gc .\usuarios.txt | %{
    $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
    New-LocalUser $_.split(",")[0] -Password $pass
}

######

gc .\fichero.txt | %{
    if($_.split(",").count -eq 1)
    {
        Remove-LocalUser $_.split(",")[0] -WhatIf
    }
    else
    {
        $pass=ConvertTo-SecureString $_.split(",")[1] -asplaintext -force
        New-LocalUser $_.split(",")[0] -Password $pass -WhatIf
    }
}
```

## Analizar información sobre usuarios con PowerShell (1ª parte)
* https://www.youtube.com/watch?v=bZWs08BBjDc
## Analizar información sobre usuarios con PowerShell (2ª parte)
* https://www.youtube.com/watch?v=CCipPiIUVFY
## Crear, modificar y borrar usuarios con PowerShell
* https://www.youtube.com/watch?v=7sxxCnyRwcg
## Analizar información sobre grupos con PowerShell (1ª parte)
* https://www.youtube.com/watch?v=jaIQHD9Jlgc
## Analizar información sobre grupos con PowerShell (2ª parte)
* https://www.youtube.com/watch?v=qprY8B6uI50
## Crear, modificar, añadir usuario, quitar usuario y borrar grupo con PowerShell
* https://www.youtube.com/watch?v=eudt3H2o8z0

## Perfiles
* https://www.jesusninoc.com/07/22/listar-las-rutas-de-los-perfiles-de-los-usuarios/

## UTILIZAR JSON CON NOMBRES Y APELLIDOS ALEATORIOS
* https://www.jesusninoc.com/02/04/utilizar-json-con-nombres-y-apellidos-aleatorios/

--------------

# Proyecto 2ª Guerra Mundial (instalación y configuración)
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-01-09.md#segunda-guerra-mundial-1--radio
* https://www.jesusninoc.com/01/07/que-necesito-para-enviar-y-recibir-senales-de-radio/
* https://github.com/Zebiano/piradio
* https://zadig.akeo.ie/
* https://www.jesusninoc.com/01/23/detectar-microfono-espia-con-cnn-rtlsdr-deep-learning-signal-classification-using-rtl-sdr-dongle/
* https://www.jesusninoc.com/01/17/encender-y-apagar-un-led-en-raspberry-pi-realizando-una-conexion-ssh-desde-powershell/
