# Administración de software de base

- Administración de usuarios y grupos locales.
  - Crear, modificar y editar usuarios y grupos. Añadir usuarios a los grupos.
  - Cambiar la ruta del perfil del usuario, scripts de inicio y carpeta particular. 
- Usuarios y grupos predeterminados.
  - Conocer los privilegios asignados.
- Seguridad de cuentas de usuario.
  - Establecer la contraseña.
  - Habilitar y deshabilitar cuentas de usuario.
  - Añadir las cuentas de usuario a los grupos predeterminados según sus necesidades.
- Seguridad de las contraseñas:
  - Algoritmos para la elección de contraseñas seguras.
  - Opciones de la contraseña: obligar a cambiar la contraseña, caducidad, etc. 
- Administración de perfiles locales de usuario. 
  - Directorios y ficheros implicados.
  - Cambiar la ruta de las carpetas de documentos a otra partición o recurso de red. 
 - Configuración del protocolo TCP/IP en un cliente de red. 
 - Configuración de la resolución de nombres. 
 - Ficheros de configuración de red. 
 - Optimización de sistemas para ordenadores portátiles.
  - Archivos de red sin conexión.
  - Asegurar la información para evitar su uso en caso de pérdida o robo. Cifrado de ficheros y de discos, copia de seguridad remota, etc.
  - Configurar el firewall para asegurar el portátil en las conexiones no seguras.

--------------

# Gestión de usuarios en Windows

## ¿Qué es el número de sesiones de usuario?
* https://www.jesusninoc.com/01/12/introduccion-a-los-sistemas-operativos/#El_numero_de_sesiones

## Usuarios en PowerShell
* https://www.jesusninoc.com/07/08/8-gestion-de-usuarios-en-powershell/

## Ejercicios

### Crear una funcion que indica el SID de los usuarios
```PowerShell
function damesid($verusuario)
{
    $objUser = New-Object System.Security.Principal.NTAccount($verusuario)
    $SID = $objUser.Translate([System.Security.Principal.SecurityIdentifier])
    $SID.Value
}
 
foreach($usuario in (Get-LocalUser).name)
{
    damesid $usuario
}
```
 
### Crear una función que dice si un usuario existe o no (mostrando todos los valores de la comparación)
```PowerShell
function damesid($verusuario)
{
    foreach($usuario in (Get-LocalUser).name)
    {
         if ($usuario -eq $verusuario)
         {
            "El usuario $verusuario existe"
         }
         else
         {
            "No es el usuario"
         }
    }
}
 
$verusuario = "LHR"
damesid $verusuario
```
 
### Crear una función que dice si un usuario existe o no (mostrando si existe o no)
```PowerShell
function damesid($verusuario)
{
    $usuarios = (Get-LocalUser).name
    if($usuarios.contains($verusuario))
    {
        "El usuario existe"
    }
    else
    {
        "El usuario no existe"
    }
}
 
$verusuario = "LHR"
damesid $verusuario
```

### Crear una función que dice si un usuario existe o no (mostrando si existe o no, con Read-Host)
```PowerShell
function damesid($verusuario)
{
    $usuarios = (Get-LocalUser).name
    if($usuarios.contains($verusuario))
    {
        "El usuario existe"
    }
    else
    {
        "El usuario no existe"
    }
}
 
damesid (Read-Host "Nombre del usuario")
```

### Crear una función que dice si un usuario existe o no (mostrando si existe o no, con Read-Host y aceptar minúsculas)
```PowerShell 
function damesid($verusuario)
{
    $usuarios = (Get-LocalUser).name
    if($usuarios.contains($verusuario.ToUpper()))
    {
        "El usuario existe"
    }
    else
    {
        "El usuario no existe"
    }
}
 
damesid (Read-Host "Nombre del usuario")
```

### Iniciar un programa siendo otro usuario

```PowerShell
$crede = Get-Credential
Start-Process notepad -Credential $crede
```

--------------

# Gestión de usuarios en Windows (Server)

## Instalación de sistemas operativos en red de forma local (tema del libro)
### - Instalar Windows Server 2016
