# Administración y aseguramiento de la información
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

---------------

# Repaso examen
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-12-05.md#soluciones-avanzadas

---------------

# Linux

## Copias de seguridad
* http://www.developandsys.es/copias-seguridad-linux/

## Programar la copia de seguridad
* https://github.com/jesusninoc/Bash/blob/master/Examenes/Examen-2016-02-11-Solucion.sh

## Ejercicios sobre copias de seguridad
- Listar archivos por fecha
  ```Bash
  ls -lt
  ls -ltr
  ls -l --sort=size
  ```
- Copia de seguridad para cada día de la semana y ser capaz de recuperar
  * https://www.youtube.com/watch?v=aDCfL9Pk3TQ&feature=youtu.be
  * https://github.com/jesnino/Bash/blob/master/Ficheros/EjercicioCalendario.sh
- Copiar cada fichero listado de un directorio en un nuevo directorio
  * https://github.com/jesusninoc/ClasesISO/blob/master/2019-01-22.md#utilizar-xargs
- Comprimir las copias de seguridad que se han realizado
  * https://linuxzone.es/metodos-de-compresion-y-descompresion-en-linux/
- Enviar un mail cuando se haya realizado la copia de seguridad
  * https://www.interserver.net/tips/kb/linux-mail-command-usage-examples/

## Copias de seguridas de bases de datos

### MySQL dump ignorando tablas
* https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20ignorando%20tablas.sh

### MySQL dump completo
* https://github.com/jesusninoc/Scripts/blob/master/MySQL%20dump%20completo.sh

### Borrar copias de seguridad de bases de datos en MySQL.sh
* https://github.com/jesusninoc/Scripts/blob/master/Borrar%20copias%20de%20seguridad%20de%20bases%20de%20datos%20en%20MySQL.sh

### Database Backup Program (examples)
* https://www.jesusninoc.com/11/26/database-backup-program-scripts-examples/

---------------

# PowerShell

## Cifrar
* https://www.jesusninoc.com/02/23/aproximacion-al-cifrado-y-descifrado-en-powershell/
