# Posibles preguntas examen liberatorio
- Asignar varios permisos a una carpeta
https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md#asignar-varios-permisos-a-una-carpeta
- Asignar varios permisos a distintas carpetas
https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md#asignar-varios-permisos-a-distintas-carpetas
- Crear carpetas con información sobre los datos obtenidos del hardware.
https://kevinmarquette.github.io/2016-10-28-powershell-everything-you-wanted-to-know-about-pscustomobject/
```PowerShell
$objeto | Get-Member -MemberType NoteProperty | Select -ExpandProperty definition
$objeto | Get-Member -MemberType NoteProperty | Select -ExpandProperty name

$objeto | Get-Member -MemberType NoteProperty | %{
    $_ | Select -ExpandProperty name
    $_ | Select -ExpandProperty definition
}
```
- Carpeta sistemaoperativo con un fichero que tiene la partición donde se ha instalado.
- Carpeta placa_base y dentro de la carpeta un fichero con información.
- Analizar la información de un servicio con capturas de pantalla y comandos de PowerShell.
- Explica la relación entre servicios, procesos y algo más?
- Qué te permite realizar la virtualización en sistemas heterogéneos.
- Cómo harías un script para instalar un gestor virtual y una máquina virtual.
- Es lo mismo ordenar en PowerShell y luego seleccionar que seleccionar y ordenar.
- Qué cantidad de memoria tienes en GB en tu equipo?
- Analiza por qué un proceso tiene tanto consumo de CPU.
- Listar un proceso en Linux desde Powershell.
- Convierte el comando systeminfo a cmdlets en PowerShell.
- Guarda un fichero con la siguiente información: procesos que se están ejecutando, añade una línea con tu nombre al fichero y la hora en que has comprobado los procesos (hazlo tres veces y comprueba que se añaden los datos de las tres ejecuciones).
- Realizar un script que almacene información de cada proceso que se está ejecutando, piensa qué información puede ser interesante.
- Un equipo de la red comienza a realizar comportamientos extraños, realiza un script que pueda detectar qué ocurre y a qué hora.
- Mostrar los servicios que representan comportamientos extraños.
- ¿Cómo puedes darte cuenta de que hay un proceso que consume toda la memoria RAM del equipo?
- Realiza una función de login que almacene los intentos fallidos y correctos.
- Crea una función para hacer un login con dos factores de verificación (incluye comprobar el nombre de usuario).
- Crea una función que intente localizar los hilos que se crean para un proceso.
- Guardar un listado con los ficheros que tenemos en la unidad Q.
- Crear carpetas para cada extensión.
- Carpeta doc y dentro de la carpeta copiar ficheros con extensión doc.
- Añadir a cada carpeta doc, txt un listado con los ficheros y además añadir un listado de permisos.
- Como usuario pedro Crea un fichero con nombre secreto.txt al que únicamente él tenga acceso, tanto de lectura como de escritura.
- Crea otro fichero, también como usuario juan, con nombre datos.txt al que tengan acceso, tanto para leer como para escribir todos los usuarios que pertenezcan al mismo grupo.  Comprueba como usuario pablo que puedes modificar el fichero.
- Como usuario juan, crea un fichero con nombre datos.txt al que pueda acceder cualquier usuario para leer su contenido, y cualquier usuario del mismo grupo para leer o escribir.
- Como usuario pedro, copia un programa del directorio /usr/bin al directorio de trabajo con un nombre diferente. Mira los permisos de este programa. Comprueba que se puede ejecutar.
- Cambia los permisos de un fichero de tal forma que sólo lo pueda ejecutar el propietario del archivo.
- Aparecen unas capturas que se han realizado con la webcam, la webcam esta en estado activo, ¿qué ha ocurrido en el sistema?
- Un empleado sabe que va a ser despedido...
- Realizar la firma de todos los programas que se están ejecutando
- Verificación de contraseña utilizando ficheros en Linux

------------------------

# Examen liberatorio
- Las preguntas que implican respuestas por scripts se pueden hacer en PowerShell, Linux o WSL (o en todos a la vez).
- Utiliza bucles, condiciones, ficheros, funciones, etc.
 
## 1. Realizar un inventario de tu equipo a nivel hardware y software, ten en cuenta cómo clasificar la información y no olvides temas importantes como por ejemplo controladores.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-12.md
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Hardware/EjemplosHardware2.ps1

## 2. Crear una estructura de ficheros en Linux y establece permisos, los permisos tienen que estar establecidos con el mayor criterio posible.
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjercicioPermisos.sh

## 3. Explicar todo lo que sepas sobre virtualización y qué relación tiene con las clases de los jueves.
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-30.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-23.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-11-16.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-09.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-02.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-26.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-10-19.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-28.md
* https://github.com/jesusninoc/ClasesISO/blob/master/2017-09-21.md

## 4. Analizar tu equipo desde el punto de vista de los programas, procesos, servicios e hilos.
* https://www.jesusninoc.com/2016/11/10/analizar-servicios-con-powershell/

## 5. Monitorizar un valor de tu equipo.
* https://github.com/jesusninoc/PowerShell/blob/master/Procesos/EjerciciosFuncionesProcesos2.ps1

## 6. Realizar un login implementando autenticación de segundo factor y almacena los intentos de login fallido.
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginIntentosFallidos.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLogin.ps1
* https://github.com/jesusninoc/PowerShell/blob/master/Funciones/EjerciciosFuncionesAvanzadasLoginHash.ps1

## 7. Crear carpetas con información sobre los datos obtenidos del hardware.
* https://www.jesusninoc.com/09/07/obtener-informacion-sobre-el-hardware-creando-un-objeto-con-todos-los-datos/
```PowerShell
$objeto | Get-Member -MemberType NoteProperty | %{
    [String]$dire=$_ | Select -ExpandProperty name
    mkdir $dire -Force
    cd $dire
    ni -name informacion.txt -Value ($_ | Select -ExpandProperty definition) -Force
    cd ..
}
```
## 8. Realizar la firma de todos los programas que se están ejecutando.
### Linux
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-11-13.md#calcular-el-hash-sha512-de-todos-los-procesos-que-se-est%C3%A1n-ejecutando-en-linux
### PowerShell función simple
```PowerShell
function hashear($ruta){
    Get-FileHash $ruta
}

Get-Process | select Path | %{
    hashear $_.Path
}
```
### PowerShell función compleja
```PowerShell
function hasheo
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    [AllowEmptyString()] 
    $ruta
  )

  begin
  {
    Write-Host "Principio de hasheo"
  }

  process
  {
    Get-FileHash $ruta
  }
  end
  {
    Write-Host "Final de hasheo"
  }
}

Get-Process | select Path | %{
    hashear $_.Path
}
```
## 9. Analiza por qué un proceso tiene tanto consumo de CPU.
### PowerShell función simple
```PowerShell
function consumo ($nombre,$valor)
{
   if((Get-Process -Name $nombre | select cpu).cpu -gt $valor)
    {
        "$nombre Consume mucho"
    }
    else
    {
        "$nombre No consume mucho"
    }
}

consumo -nombre powershell_ise -valor 10

Get-Process | %{
    consumo -nombre $_.Name -valor 10
}
```
### PowerShell función compleja
```PowerShell
function consumo
{
  param
  (
    [String[]]$nombre,$valor
  )

  begin
  {
    Write-Host "Principio de analizar"
    if($nombre -eq $null)
    {
        "Tiene que introducir un nombre de proceso, majo!"
        break
    }
  }

  process
  {
    if((Get-Process -Name $nombre | select cpu).cpu -gt $valor)
    {
        "$nombre Consume mucho"
    }
    else
    {
        "$nombre No consume mucho"
    }
  }
  end
  {
    Write-Host "Final de analizar"
  }
}

consumo -nombre notepad -valor 10
```
## 10. Simula un login, ten en cuenta que el password se encuentra en SHA512
```Powershell
[Reflection.Assembly]::LoadWithPartialName("System.Web")
[System.Web.Security.FormsAuthentication]::HashPasswordForStoringInConfigFile("Hola", "SHA512")
```
```Powershell
#################################################################################
#Función login de user y pass
#El user y pass (hash en SHA512) correcto se escriben en el bloque BEGIN

#Ejecutar la función
#PS C:\Users\usuario> loginH user pass

function loginH
{
  param
  (
    [Parameter(Mandatory=$true, ValueFromPipeline=$true)]
    [String[]]
    [AllowEmptyString()] 
    $User,$Pass
  )

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="user"
    #El pass en SHA512
    #$passcorrecto="pass"
    $passcorrecto="5B722B307FCE6C944905D132691D5E4A2214B7FE92B738920EB3FCE3A90420A19511C3010A0E7712B054DAEF5B57BAD
59ECBD93B3280F210578F547F4AED4D25"
  }

  process
  {
   #Realizar el SHA512 del pass introducido por el usuariO
   [Reflection.Assembly]::LoadWithPartialName("System.Web")
   $Pass
   if($User -eq $usercorrecto -and [System.Web.Security.FormsAuthentication]::HashPasswordForStoringInConfigFile($Pass, "SHA512") -eq $passcorrecto)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
    }
    Write-Host "Fin de login"
  }
}
#################################################################################
```

