# Administración y aseguramiento de la información
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.

# PowerShell

## Programar la copia de seguridad
* https://www.jesusninoc.com/2017/03/01/tareas-programadas-en-powershell/
* https://github.com/jesusninoc/PowerShell/blob/master/TareasProgramadas/EjemploTareaProgramada.ps1

## Ejercicio: crear una tarea programada que ejecuta un script en PowerShell que realiza una copia de seguridad
### Crear una copia de seguridad
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-26.md#ejercicio-sobre-copias-de-seguridad-con-integridad-comprobar-que-los-ficheros-que-tengo-en-una-carpeta-son-correctos-en-la-copia-de-seguridad-mediante-la-integridad
### Tener en cuenta a la hora de programar la tarea que ejecuta el script
```PowerShell
# Cambiar la política de ejecución de scripts para poder ejecutar
Set-ExecutionPolicy -ExecutionPolicy Unrestricted -Scope CurrentUser

# Ecribir un mensaje por pantalla
echo "hola"

# Mostrar la ruta
pwd

# Parar el script
pause

# Almacenar en un fichero la hora a la que se ejecuta el script junto con el porcentaje de batería
echo (Get-Date).Hour >> C:\xampp\mysql\bin\fichero.txt
```
### Repetir cada 1 hora indefinidamente la ejecución de un script en PowerShell
* https://www.jesusninoc.com/02/20/ejercicios-de-powershell-repetir-cada-1-hora-indefinidamente-la-ejecucion-de-un-script-en-powershell-2/

-----------------

# Clase especial

## REPRODUCIR TRÁILERES DE PELÍCULAS
* https://www.jesusninoc.com/11/21/reproducir-traileres-de-peliculas/

## ENVIAR LA REPRODUCCIÓN DE LOS TRÁILERES DE PELÍCULAS A LA SMART TV
* https://www.jesusninoc.com/11/22/enviar-la-reproduccion-de-los-traileres-de-peliculas-a-la-smart-tv/

-----------------

# Clase especial

## Crear un audio que vamos a mandar mediante señales de radio

```PowerShell
#Convertir una frase en audio con la voz del sistema operativo desde PowerShell

Add-Type -AssemblyName System.Speech
$synthesizer = New-Object -TypeName System.Speech.Synthesis.SpeechSynthesizer
$synthesizer.SetOutputToWaveFile("saludo.wav")
$synthesizer.Speak("Hola amigo Pedro")
$synthesizer.SetOutputToDefaultAudioDevice()
Get-ChildItem .\saludo.wav
```

## Subir el audio a Raspberry Pi realizando una conexión SCP
```PowerShell
#Iniciar una sesión SCP
#Para iniciar sesión SSH es necesario indicar la dirección IP del equipo al que nos vamos a conectar y también hay que introducir los credenciales (usuario y contraseña).

$Pass = ConvertTo-SecureString -String "raspberry" -AsPlainText -Force
$Credential = New-Object -TypeName "System.Management.Automation.PSCredential" -ArgumentList "pi", $Pass

#Para configurar Set-SCPFile
#Indicar el fichero que vamos a subir -LocalFile
#Indicar el equipo al que nos vamos a conectar -ComputerName
#Indicar la ruta en la que vamos a subir el audio -RemotePath
#Forzar la conexión para evitar fallo "Key exchange negotiation failed."
#Indicar los credenciales que hemos creado anteriormente

Set-SCPFile -LocalFile .\saludo.wav -ComputerName 192.168.1.161 -RemotePath ./fmm/fm_transmitter-master -Force -Credential $Credential
```

-----------------

# Más clases especiales
* https://www.jesusninoc.com/02/16/muneco-bailando/
* https://github.com/jesusninoc/ClasesIAW/blob/master/2019-11-25.md#proyectos-de-la-semana
* https://github.com/jesusninoc/ClasesISO/blob/master/2020-01-01.md
