# Administración y aseguramiento de la información:
- Niveles RAID:
  - Implementación por hardware y por software. Ventajas e inconvenientes.
  - Niveles RAID usados en la actualidad. Características: tolerancia a fallos, número de mínimo de discos necesarios para su implementación, cuántos discos pueden fallar sin perder el servicio, etc.
  - Funciones avanzadas. Unión de niveles RAID más usados como RAID 10, RAID 50 y RAID 60.

# RAID
* http://www.developandsys.es/aseguramiento-la-informacion/

## Comandos para trabajar con discos en Linux
```Bash
df -h
sudo fdisk -l /dev/sdb
sudo mkfs.vfat /dev/sdc1
sudo mkfs.ntfs /dev/sdc1
sudo mkfs.ext4 /dev/sdc1
sudo blkid
sudo mkdir mount_name
sudo mount -t auto -v /dev/sdb1 /mnt/mount_name
sudo umount /dev/sdb
```

---------------------

# Administración y aseguramiento de la información:
- Tipos de copias de seguridad:
  - Locales y Remotas.
  - Herramientas clásicas: copias de seguridad completas, diferenciales e incrementales.
  - Herramientas de sincronización con control de versiones.
- Planes de copias de seguridad y restablecimiento.
- Consideraciones:
    - Dónde realizar las copias de seguridad (backup), locales y remotas.
    - Programación de copias de seguridad: para decidir la programación habrá que tener en cuenta el tiempo asumible de pérdida de datos, si es necesario detener servicios para realizar las copias de seguridad, etc.
    - Espacio necesario, históricos, rotaciones de los medios, etc.
- Responsabilidad de las copias de seguridad. Personas encargadas de revisar las copias de seguridad y restablecerlas si es necesario. Asignar los permisos necesarios a estas personas. 
- Elección del software para realizar los backups. Uso de herramientas estándar o específicas para los datos/servicios a asegurar.
- Probar la integridad de las copias de seguridad:
    - Crear un plan de pruebas. Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
    - Comprobar si los tiempos de restauración son asumibles.
- Crear un plan de restauración:
    - Dónde se restaurarán los datos en caso de fallo físico de discos, servidores, etc.
    - Quien está autorizado para realizar la restauración.
    - Detallar los pasos a realizar.
- Recuperación en caso de fallo del sistema:
  - Responsables de la recuperación, mecanismos para localizar a estas personas.
  - Hardware crítico para la restauración.
  - Medidas a adoptar para mitigar el impacto del fallo.
  - Discos de arranque. Discos de recuperación.
  - Copias de seguridad del sistema. Recuperación del sistema mediante consola. Puntos de recuperación.
- Creación y recuperación de imágenes de servidores.
  - Cuotas de disco. Niveles de cuota y niveles de advertencia.
  - Compresión de datos.
    
# PowerShell

## 10. Gestión del rendimiento en PowerShell para administradores de sistemas (nivel básico)
* https://www.jesusninoc.com/11/16/10-gestion-del-rendimiento-en-powershell-para-administradores-de-sistemas/

## Integridad
* https://www.jesusninoc.com/02/04/integridad/

## Restauración
* https://www.jesusninoc.com/07/10/10-gestion-del-rendimiento-en-powershell/#Restauracion

## Comprimir y descomprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Comprimir
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Descomprimir
```PowerShell
Compress-Archive -LiteralPath C:\powershell\example.txt –CompressionLevel Optimal -DestinationPath C:\powershell\comprimido.zip
Expand-Archive -LiteralPath C:\powershell\comprimido.zip -DestinationPath C:\powershell\descomprimir
Compress-Archive -LiteralPath C:\powershell\example2.txt -Update -DestinationPath C:\powershell\comprimido.zip
```

# Ejercicio sobre copias de seguridad con integridad: comprobar que los ficheros que tengo en una carpeta son correctos en la copia de seguridad mediante la integridad

```PowerShell
# Ideas

# Probar la integridad de las copias de seguridad:
# - Crear un plan de pruebas. 
# - Ventajas del uso de máquinas virtuales para las pruebas de integridad de los backups.
# - Comprobar si los tiempos de restauración son asumibles.

# Ficheros que se van a copiar
# fichero1.txt
# fichero2.txt
# fichero3.txt
# fichero4.txt

# Ficheros que tienen las integridades de los ficheros 1,2,3,4
# fichero1integridad.txt
# fichero2integridad.txt
# fichero3integridad.txt
# fichero4integridad.txt

# crear el zip 1,2,3,4

# -------------------- RECUPERACIÓN

# descomprimir zip 1,2,3,4

# ver integridad fichero que tiene los hashes 1,2,3,4

# fichero1 si abro si la integridad es correcta

"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt

# zip meter fichero1.txt más integridades.txt (se puede separar en dos archivos)

# hay fallo y tengo que recuperar la copia

# descomprimir y ver si el fichero1.txt lo puedo ver

# porque la integridad de fichero1 es correcta

# h(f1) == f1*

if((gc .\fichero1integridad.txt) -eq (Get-FileHash .\fichero1.txt).hash)
{
    "El hash coincide"
}
else
{
    "El hash no coincide"
}

# Ver si el hash coincide para todos los ficheros

mkdir ficheros
cd .\ficheros
"hola" > fichero1.txt
(Get-FileHash .\fichero1.txt).hash
(Get-FileHash .\fichero1.txt).hash > fichero1integridad.txt
"holas" > fichero2.txt
(Get-FileHash .\fichero2.txt).hash
(Get-FileHash .\fichero2.txt).hash > fichero2integridad.txt

# Se supone que se ha comprimido

# Hay fallo
 
# Verificar que todos los hashes son correctos

ls fichero?.txt | %{
    $ficherointeg = $_.FullName
    $ficherointeg2 = $ficherointeg.replace(".txt","")
    $ficherofinal = ([String]$ficherointeg2+"integridad.txt")

    if(((Get-FileHash $_).hash) -eq (gc $ficherofinal))
    {
        "El hash coincide"
    }
    else
    {
        "El hash no coincide"
    }
}
```
