# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Discos
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-04.md

---------------

# Ficheros en Linux
## Introducción a buscar ficheros
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjerciciosFicherosBuscar.sh

## Conocer la extensión de un fichero en Linux
```Bash
file fichero
```

## Ejercicio calcular hash en Linux
```Bash
proceso=`ps -C nano -o cmd --no-headers`
ruta=`whereis $proceso`
sha512sum $ruta
```

## Introducción a bucles en Linux
* https://www.jesusninoc.com/2015/07/13/bucles-2/
* https://www.jesusninoc.com/2016/01/02/for-loop-examples/

## Bucle for en Linux
```Bash
for i in $(pgrep application.x); do ps -mo pid,tid,fname,user,psr -p $i;done
```

## Ver funcionamiento de awk
```Bash
echo "hola amigo" | awk '{print $1}'
echo "hola amigo" | awk '{print $2}'
echo "touch amigo" | awk '{print $1}'; echo "touch amigo" | awk '{print $2}'
```

## Calcular el hash SHA512 de todos los procesos que se están ejecutando en Linux
```Bash
for procesos in $(ps -aux | awk '{print $11}');do ruta=`whereis $procesos`; sha512sum $ruta;done
```

-------------

# Ficheros en PowerShell

## Listar ficheros cuya fecha de última escritura de ficheros sea de mayor que menos un día
```PowerShell
Get-ChildItem | where LastWriteTime -gt (Get-Date).AddDays(-1)
```
## Listar ficheros cuyo tamaño sea mayor de 1MB
```PowerShell
Get-ChildItem -Recurse | where Length -Gt 1MB
```
## Listar la ruta de los programas que se están ejecutando
```PowerShell
foreach($procesos in (Get-Process | select path))
{
    Get-FileHash $procesos.path
}
```
## Listar la ruta del prama Chrome que se está ejecutando
```PowerShell
foreach($id in Get-Process -Name chrome)
{
    Get-FileHash $id.Path
}
```

-------------

# Funciones en PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Funciones
* https://www.jesusninoc.com/10/14/funciones-con-parametros-y-sin-parametros/

## Ejemplos sobre funciones

### Mediante una función mostrar un mensaje para cada usuario y pedirle un valor
```PowerShell
function pedirymostrar($i)
{
    $valor = Read-Host ("Introduzca valor" + "usuario" + $i)
    Write-Host ("El valor es " + $valor)
}

foreach($i in 1..10)
{
    pedirymostrar $i
}
```

### Mediante una función crear una carpeta para cada proceso que se está ejecutando
```PowerShell
# mkdir (ps).Name -WhatIf

function crearcarpeta($procesos)
{
    mkdir $procesos -WhatIf
}

crearcarpeta (ps).Name
```

### Crear una función que sume dos número que pedimos al usuario
```PowerShell
function suma([Int]$valor1,[Int]$valor2)
{
    ($valor1)+($valor2)
}

$valor1 = Read-Host "Introduzca número 1"
$valor2 = Read-Host "Introduzca número 2"
suma $valor1 $valor2
```

## Ejercicios sobre funciones: mediante la utilización de funciones en PowerShell resolver las siguientes situaciones:
- Mostrar todos los procesos.
- Mostrar los X primeros procesos.
- Mostrar los X últimos procesos.
- Ordenar todos los procesos por CPU de forma descendente.
- Mostrar los X procesos cuyo consumo (el parámetro que quieras utilizar) sea mayor que el valor que quieras monitorizar.
- Agrupar los procesos y muestra los que sean XXXXX.
- Abrir una página web las veces que quiera el usuario.
- Realizar un login.

### Función para mostrar todos los procesos
```PowerShell
function Procesos
{
Get-Process
}
Procesos
```

### Función para mostrar los X primeros procesos
```PowerShell
function ProcesosPrimeros($numero)
{
Get-Process | Select-Object -First $numero
}
ProcesosPrimeros 5
```

### Función para mostrar los X primeros procesos utilizando Mandatory
```PowerShell
function ProcesosUltimosM
{
param
(
[Parameter(Mandatory=$true)]
$numero
)
Get-Process | Select-Object -Last $numero
}
ProcesosUltimosM 5
```

### Función para mostrar los X últimos procesos
```PowerShell
function ProcesosUltimos($numero)
{
Get-Process | Select-Object -Last $numero
}
ProcesosUltimos 5
```

### Función para ordenar todos los procesos por CPU de forma descendente
```PowerShell
function ProcesosCPU
{
Get-Process | Sort-Object CPU -Descending
}
ProcesosCPU
```

### Función para mostrar los X procesos cuyo consumo (el parámetro que quieras utilizar) sea mayor que el valor que quieras monitorizar
```PowerShell
function ProcesosConsumo([String]$parametro,[Int]$valor,[Int]$numerovalores)
{
$parametro
$valor
$numerovalores
Get-Process | Where-Object $parametro -GT $valor | Select-Object -First $numerovalores
}
ProcesosConsumo CPU 30 5
```

### Función para agrupa los procesos y muestra los que sean XXXXX
```PowerShell
function ProcesoConcreto($nombreproceso)
{
Get-Process -Name $nombreproceso | Group-Object
}
ProcesoConcreto svchost
```

### Abrir una página web las veces que quiera el usuario
```PowerShell
function abrirweb ($numero,$url)
{
    1..$numero | %{
        start $url
        [System.Console]::Beep(261,500)
    }
}

abrirweb 3 http://www.jesusninoc.com
```

### Realizar un login mediante una función
```PowerShell
#Login de user y pass
#El user y pass correcto se escriben en el bloque BEGIN
#Ejecutar la función: login0
login0 -User jaime -Pass hola

function login0
{
  param([Parameter(Mandatory=$true, ValueFromPipeline=$true)][String[]][AllowEmptyString()]$User,$Pass)

  begin
  {
    Write-Host "Principio de login"
    $usercorrecto="user"
    $passcorrecto="pass"
  }

  process
  {
   if($User -eq $usercorrecto -and $Pass -eq $passcorrecto)
    {
        $ok=1
    }
    else
    {
        $ok=0
    }
  }
  end
  {
   if($ok)
    {
        Write-Host "User correcto"
    }
    else
    {
        Write-Host "User no correcto"
        $User,$Pass | Out-File log.txt -Append
    }
    Write-Host "Fin de login"
  }
}
```

---------------------

# Clase especial
## Instalar Icecast is free server software for streaming multimedia
```Bash
sudo apt-get install icecast2 darkice
```
## Descargar un mp4 y un mp3 en la carpeta /usr/share/icecast2/web
```Bash
wget https://www.soundhelix.com/examples/mp3/SoundHelix-Song-1.mp3
```
## Reproducir ficheros desde el móvil
http://192.168.1.162:8000/sound.mp3
## Número de hilos que ejecuta Icecast
https://github.com/jesnino/Bash/blob/master/Procesos/EjerciciosHilos.sh
