# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Repaso
## Eliminar el contenido de las carpetas impares de un servidor web
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-11-05.md#eliminar-el-contenido-de-las-carpetas-impares-de-un-servidor-web-1

## Estamos viendo sistema de archivos
* https://github.com/jesnino/PowerShell/blob/master/Ficheros/EjemplosLeerOperacionesTareasBasicasII.ps1

## TAREAS BÁSICAS II (SISTEMA DE ARCHIVOS)
* https://www.jesusninoc.com/2017/07/04/4-gestion-del-sistema-de-archivos-en-powershell/

|Tarea|Cmdlet
|---|---
|Crear o modificar un archivo|New-item
|Crear un directorio|New-item
|Ver el contenido de un archivo|Get-Content
|Acceder al contenido de un directorio|Set-Location
|Listar el contenido de un directorio|Get-Childitem
|Eliminar un archivo|Remove-Item
|Eliminar un directorio|Remove-Item
|Copiar un archivo o un directorio|Copy-Item
|Mover un archivo o un directorio|Move-Item
|Renombrar un archivo o un directorio|Rename-Item
|Imprimir un archivo|Out-Printer

## Fechas
https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Fechas

## Tienen atributos que se pueden listar (show hidden files)
https://www.jesusninoc.com/2014/11/23/show-hidden-files/

## Creación de directorios
* https://github.com/jesnino/PowerShell/blob/master/Ficheros/SolucionEjerciosFicherosProcesos.ps1
* https://www.youtube.com/watch?v=CibNbK9sp8A&list=PL89qBrmFzAa34fM6OEMLV6ybDk3Y34qud&index=3

## If
* https://www.jesusninoc.com/2016/08/05/sentencia-condicional-if/
* https://www.jesusninoc.com/2015/04/26/sentencia-condicional-if-else/
* https://www.jesusninoc.com/2016/08/07/sentencia-condicional-if-elseif-else/

## BUCLE EN POWERSHELL
* https://www.jesusninoc.com/2017/10/08/listar-todos-los-caracteres-ascii-en-powershell/
* https://www.jesusninoc.com/2017/10/05/listar-todos-los-caracteres-ascii-en-bash/

---------------

# Ejercicio: realizar tareas leyendo de un fichero
```PowerShell
#Añadir operaciones al fichero
"fecha" | Out-File operaciones.txt -Append
"hilos" | Out-File operaciones.txt -Append
"crear" | Out-File operaciones.txt -Append
"imprimir" | Out-File operaciones.txt -Append
"comprimir" | Out-File operaciones.txt -Append

gc .\operaciones.txt

foreach($operaciones in gc .\operaciones.txt)
{
    switch($operaciones)
    {
        "fecha"{get-date}
        "hilos"{Get-Process | select Threads}
        "crear"{New-Item -Name elque -ItemType File}
        "imprimir"{echo "hola" | Out-Printer "Microsoft Print to PDF"}
        "comprimir"{Compress-Archive -LiteralPath .\123-11.txt –CompressionLevel Optimal -DestinationPath 123.zip}
    }
}
```

---------------

# Permisos en PowerShell
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Permisos-2
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-26.md
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-27.md
* https://www.jesusninoc.com/03/30/eliminar-permisos-explicitos/

---------------

# Permisos en Linux
## Permisos especiales en Linux
http://rm-rf.es/permisos-especiales-setuid-setgid-sticky-bit/

|Permiso|Explicación
|---|---
|- - - - - - - - -	= 0|Predeterminado, sin permisos especiales. No se requiere indicar.
|- - - - - - - - t	= 1|Bit de persistencia, sticky bit
|- - - - - s - - -	= 2|Bit sgid de grupo
|- - - - - s - - t	= 3|Bit sgid y sticky
|- - s - - - - - -	= 4|Bit suid
|- - s - - - - - t	= 5|Bit suid y sticky
|- - s - - s - - -	= 6|Bit suid y sgid
|- - s - - s - - t	= 7|Bit suid, sgid y sticky

- sticky: se utiliza para permitir que cualquiera pueda escribir y modificar sobre un archivo o directorio, pero que solo su propietario o root pueda eliminarlo. 
- suid: el bit SUID activo en un archivo significa que el que lo ejecute va a tener los mismos permisos que el que creó el archivo.
- sgid: el SGID es lo mismo que en el SUID, pero a nivel de grupo. Es decir, todo archivo que tenga activo el SGID, al ser ejecutado, tendrá los privilegios del grupo al que pertenece.

## Permisos en Linux (EJERCICOS AVANZADOS SOBRE PERMISOS)

### Permisos en Linux avanzados
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

### Asignar permisos mediante llamada a sistema chmod en C
* https://www.jesusninoc.com/2014/12/01/chmod-system-call-example/
