# Administración y aseguramiento de la información:
- Gestión de la información del sistema. Rendimiento. Estadísticas.
- Montaje y desmontaje de dispositivos en sistemas operativos. Automatización.
- En sistemas Windows montar un volumen en una o más carpetas.
- Herramientas de administración de discos. Particiones y volúmenes. Desfragmentación y chequeo.
- Permisos locales de acceso a ficheros y directorios.

---------------

# Sumar en Linux
* https://uniwebsidad.com/foro/pregunta/300/como-se-pueden-sumar-dos-numeros-en-un-script-de-bash/

---------------

# Permisos en Linux
* https://github.com/jesusninoc/ClasesSOM/blob/master/2018-11-23.md
* https://github.com/jesnino/Bash/blob/master/Permisos/EjercicioPermisos.sh

|Permiso|Explicación
|---|---
|- - -	= 0|no se tiene ningún permiso
|- - x	= 1|solo permiso de ejecución
|- w -	= 2|solo permiso de escritura
|- w x	= 3|permisos de escritura y ejecución
|r - -	= 4|solo permiso de lectura
|r - x	= 5|permisos de lectura y ejecución
|r w -	= 6|permisos de lectura y escritura
|r w x	= 7|todos los permisos establecidos, lectura, escritura y ejecución

## Comandos sobre permisos
|Command|Explain
|---|---
|chmod|modify file access rights
|su|temporarily become the superuser
|sudo|temporarily become the superuser
|chown|change file ownership
|chgrp|change a file's group ownership
|umask|mask

## Ejercicios resueltos sobre permisos
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatorios
* https://github.com/jesusninoc/Bash/blob/master/Permisos/EjemplosPermisosAleatoriosConUGO

## Ejercicios propuestos con ficheros y directorios (Bash)

- Asignar permisos para una carpeta para cada usuario
- Asignar permisos para un fichero para cada usuario
- Asignar permisos para una carpeta para cada grupo
- Asignar permisos para un fichero para cada grupo

## Script con tareas sobre permisos (script.sh)

- Crear un directorio (directorio) y un fichero (fichero)
```Bash
    mkdir directorio
    touch fichero
```
- Asignar permisos a directorio y fichero iniciales
```Bash
    chmod 611 directorio -> chmod u=rw,go=x directorio
    chmod 611 fichero -> chmod u=rw,go=x fichero
```
- Asignar permisos a directorio y fichero de cambio
```Bash
    chmod 742 directorio
    chmod 742 fichero
```
- Cambiar el usuario dueño del fichero
```Bash
    chown root fichero
```
- Cambiar el grupo dueño del directorio
```Bash
    chgrp root directorio
```

-------------

# Ejercicio PowerShell

## Ejercicio con if UN NÚMERO ES PAR O IMPAR POWERSHELL

### Un número es par?, si el resto es 0. La operación del resto es %
```PowerShell
$numero=5
$numero%2
```

### Comprobar si un número es par
```PowerShell
$numero=5
if($numero%2 -eq 0)
{
"Número par"
}
else
{
"Número impar"
}
```

### Mover a una carpeta los ficheros pares y borrar los ficheros impares
```PowwerShell
-2..-8 | % {ni ((Get-Date).AddDays($_).ToString("yyyyMMdd")+".txt")}
```

## Eliminar el contenido de las carpetas impares de un servidor web
```PowerShell
# Crear un fichero dentro de todos los directorios
-2..-8 | % {mkdir (Get-Date).AddDays($_).ToString("yyyyMM-dd")}
ni -Path (ls).name -Name fichero -ItemType File

(ls | select name).name | %{
    $resultado = $_.split("-")[1] % 2
    if ($resultado -eq 1)
    {
        cd $_
        rm * -WhatIf
    }
    else
    {

    }
}
```

# Ejercicio Bash

## Eliminar el contenido de las carpetas impares de un servidor web
```Bash
echo "hola" > 201811-7
echo "hola" > 201811-8
echo "hola" > 201811-9

for i in $( ls *-? ); do
    echo "---------"
    resultado=`echo $i | cut -d "-" -f2`
    let result=resultado%2
    echo $result
    if [ $result -eq 1 ]; then
        echo "mover"
    fi
done
```

---------------

# Clase especial
## ESCANEAR FRECUENCIAS Y CLASIFICAR LAS SEÑALES ENCONTRADAS
* https://www.jesusninoc.com/01/10/escanear-frecuencias-y-clasificar-las-senales-encontradas/
## DETECTAR MICRÓFONO ESPÍA CON CNN-RTLSDR (DEEP LEARNING SIGNAL CLASSIFICATION USING RTL-SDR DONGLE)
* https://www.jesusninoc.com/01/23/detectar-microfono-espia-con-cnn-rtlsdr-deep-learning-signal-classification-using-rtl-sdr-dongle/
