# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.

---------------

# Repaso clase anterior
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-24.md

---------------

# Linux

## A First Script
* https://www.shellscript.sh/first.html

## Ejercicios con ficheros y directorios (Bash)

```Bash
#Crear o modificar un archivo
vi nombre
```
```Bash
#Crear un directorio
mkdir
```
```Bash
#Ver el contenido de un archivo
cat
```
```Bash
#Acceder al contenido de un directorio
cd
```
```Bash
#Listar el contenido de un directorio
ls
```
```Bash
#Ver la estructura de un directorio
tree
```
```Bash
#Eliminar un archivo
rm
```
```Bash
#Eliminar un directorio
rmdir
```
```Bash
#Copiar un archivo o un directorio
cp
```
```Bash
#Mover un archivo o un directorio
mv
```
```Bash
#Renombrar un archivo o un directorio
mv
```
```Bash
#Establecer permisos en un archivo o un directorio
chmod
```
```Bash
#Comprimir y descomprimir un archivo o un directorio
gzip
```
```Bash
#Imprimir un archivo
lpr
```

## Ejercicios propuestos con ficheros y directorios (Bash)

- Crear un directorio para cada usuario
- Crear un fichero para cada usuario
- Añadir contenido a cada fichero creado para cada usuario
- Eliminar un directorio
- Renombrar un directorio
- Mover archivos de una carpeta a otra

## Ejercicios resueltos con ficheros y directorios (Bash)

1. Crear fichero que tenga tu nombre
```Bash	
 	echo Alejandro > fichero.txt
	#-------------------------
	who | awk '{print $1}' > fichero.txt
```
2. Ver el contenido de un fichero cuyo nombre esta guardado en otro fichero
```Bash
	cat `cat fichero.txt`
	#--------------------
	fich1= cat fichero
	cat $fich1
```
3. Listar contenido de un directorio y almacenarlo en un fichero
```Bash	
	ls directorio > listaDeDirectorio.txt
	cat listadeDirectorio.txt
```
4. Eliminar un fichero leyendo el nombre de este desde otro fichero
```Bash
	echo fichero1.txt > fichero2.txt

	rm `cat ficher2.txt`
	#------------------------------
	fic=cat ficher2.txt
	rm $fic
```
5. Eliminar directorio leyendo el nombre desde este desde otro fichero.	
```Bash
	echo directorio > fichero.txt
	
	mkdir `cat fichero.txt`
	
	rm -r `cat fichero.txt`
	#------------------------------
	direc=cat fichero.txt
	
	mkdir $direc
	rm -r $direc
```
6. Comprimir un directorio
```Bash
	gzip fichero
```

## Leer de un fichero en Linux información
```Bash
while read linea
do
    echo $linea
done < fichero
```

## Ejercicio con if UN NÚMERO ES PAR O IMPAR EN LINUX
```Bash
numero=5
resto=`echo $numero%2 | bc`
if [ $resto -eq 0 ]; then
echo “El numero $numero es par”
else
echo “El numero $numero es impar”
fi
```

## Ejercicio con if UN NÚMERO ES PAR O IMPAR POWERSHELL

### Un número es par?, si el resto es 0. La operación del resto es %
```PowerShell
$numero=5
$numero%2
```

### Comprobar si un número es par
```PowerShell
$numero=5
if($numero%2 -eq 0)
{
"Número par"
}
else
{
"Número impar"
}
```

## Crear calendario en Linux
* https://www.youtube.com/watch?v=aDCfL9Pk3TQ&feature=youtu.be
* https://github.com/jesnino/Bash/blob/master/Ficheros/EjercicioCalendario.sh

## Ejemplos en Bash (con repaso sobre comandos)

### Crea  directorios con los años desde 2020 hasta 2030
```Bash
mkdir {2020..2030}
```

### En cada uno de los directorios, crea un subdirectorio con los meses del año
```Bash
mkdir -p {2020..2030}/{Enero, Febrero, Marzo, Abril, Mayo, Junio, Julio, Agosto, Septiembre, Octubre, Noviembre, Diciembre}
```

### En cada mes, crear un directorio con cada día de la semana
```Bash
mkdir -p {2020..2030}/{Enero, Febrero, Marzo, Abril, Mayo, Junio, Julio, Agosto, Septiembre, Octubre, Noviembre, Diciembre}/{Lunes, Martes, Miercoles, Jueves, Viernes, Sabado, Domingo}
```

### Borrar todos los directorios Julio y Agosto de todos los años
```Bash
rm -r {2020..2030}/{Julio, Agosto}
```

### Crear un alias del comando "rm" que se llame borrar y que permita borrar el directorio Ejercicio1 (con su contenido)
```Bash
alias borrar='rm -r -f ejercicio1'
```

------------------

# Ejercicios resueltos con ficheros y directorios (Bash)
## Crear directorios con los meses del año
```PowerShell
foreach($mes in 1..12)
{
    mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes) -WhatIf
}
```

## Crear directorios con los años desde 2020 hasta 2030 (opción 1)
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio) -WhatIf
}
```

## Crear directorios con los años desde 2020 hasta 2030 (opción 2)
```PowerShell
mkdir (2020..2030) -WhatIf
```

## Crear directorios con los años desde 2020 hasta 2030 (opción 3)
```PowerShell
foreach($anio in 1..10)
{
    (Get-Date).AddYears($anio).Year
}
```

## En cada uno de los directorios anteriores, crea un subdirectorio con los meses del año
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
    }
    cd ..
}
```

## En cada mes, crear un directorio con cada día del mes
```PowerShell
foreach($anio in 2020..2030)
{
    mkdir ($anio)
    cd $anio
    foreach($mes in 1..12)
    {
        mkdir (Get-Culture).DateTimeFormat.GetMonthName($mes)
        cd $mes
        1..31 | %{mkdir $_}
        cd ..
    }
    cd ..
}
```

------------------

# Compressing files
* https://www.cyberciti.biz/howto/question/general/compress-file-unix-linux-cheat-sheet.php

---------------

# Ejerecicio repaso de PowerShell
## Crear un estructura de directorios con la fecha de hoy y en cada directorio meter información sobre hilos (relación con el proceso)

### Ayuda
```PowerShell

mkdir 20191029
cd 20191029

mkdir (Get-Process).Name

foreach($proceso in (Get-Process).Name)
{
    cd $proceso
    (Get-Process -Name $proceso).Threads > informacion.txt
    cd ..
}
```

### Solución
```PowerShell
mkdir (Get-Process).id -Force

(Get-Process -Id 4).Threads.id

foreach($procesos in (Get-Process).id)
{
    cd $procesos
    (Get-Process -id $procesos).Threads >> info.txt
    cd ..
}
```
