# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.

---------------

# Repaso día anterior
* https://github.com/jesusninoc/ClasesISO/blob/master/2019-10-22.md

---------------

# Ejemplos

## Crear dos ficheros y mostrar el nombre sin la extensión
```PowerShell
"fichero" > 123-10.txt
"fichero" > 123-11.txt
 
Get-ChildItem 123*.txt
foreach($elementos in (Get-ChildItem 123-??.txt).name)
{
    $elementos.Split("-")[1].replace(".txt","")
}
```

## Crear una carpeta por cada servicio
```PowerShell
mkdir (Get-Service).Name -WhatIf
```

## Trabajar con fechas
```PowerShell
$mes = (get-date).Month
$ano = (get-date).year
$dia = (get-date).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (día anterior)
```PowerShell
$mes = (get-date).AddDays(-1).Month
$ano = (get-date).AddDays(-1).Year
$dia = (get-date).AddDays(-1).Day
mkdir $ano$mes$dia -WhatIf
```

## Trabajar con fechas (listar varios días)
```PowerShell
-1..-7
 
foreach($dias in (-1..-7))
{
    $dias
}
 
foreach($dias in (-1..-7))
{
    (Get-Date).AddDays($dias)
}
 
foreach($dias in (-1..-7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
}
```

# Ejercicio
## Hay un proceso que falla, revisad la información sobre servicios, procesos e hilos durante una semana (creando ficheros de registro varias veces al día)
 
## Parte 1
## -Crear la carpeta para cada día y para varios momentos del día

### Solución rara (o no), calculando el número de horas
```PowerShell
foreach($dias in (1..168))
{
    $mes = (get-date).AddHours($dias).Month
    $ano = (get-date).AddHours($dias).Year
    $dia = (get-date).AddHours($dias).Day
    $horas = (get-date).AddHours($dias).Hour
    mkdir $ano$mes$dia$horas -WhatIf
}
```
### Solución medio buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    foreach($horas in 0..23)
    {
        mkdir $ano$mes$dia$horas -WhatIf
    }
}
```
### Solución bastante buena
```PowerShell
foreach($dias in (-1..7))
{
    $mes = (get-date).AddDays($dias).Month
    $ano = (get-date).AddDays($dias).Year
    $dia = (get-date).AddDays($dias).Day
    mkdir $ano$mes$dia -WhatIf
   
    foreach($horas in 0..23)
    {
        $ruta = [String]$ano+[String]$mes+[String]$dia
        $ruta
        New-Item -Name $horas -Path $ruta -ItemType Directory -WhatIf
    }
}
```
### Solución mucha locura
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta0 = $ano+"\"+$mes+"\"+$dia
    mkdir $ruta0 -WhatIf
   
    foreach($horas in 0..23)
    {
        New-Item -Name $horas -Path $ruta0 -ItemType Directory -WhatIf
    }
}
```

## Parte 2
## -Listar procesos
## -Listar hilos
## -Listar servicios

### Solución que se ejecuta durante una semana (168 horas)
```PowerShell
foreach($veces in 168)
{
    $fecha = (Get-Date).ToString("yyyy\\MM\\dd")
    mkdir $fecha -Force
 
    $hora = (Get-Date).Hour
    New-Item -Name $hora -Path $fecha -ItemType Directory -Force
 
    (Get-Process).Name > ([String]($fecha+"\"+$hora+"\procesos.txt"))
    (Get-Service).Name > ([String]($fecha+"\"+$hora+"\servicios.txt"))
    (Get-Process).Threads > ([String]($fecha+"\"+$hora+"\hilos.txt"))
 
    Start-Sleep -Seconds 3600
}
```

### Solución de Daniel Cebrián
```PowerShell
foreach($dias in (-1..7))
{
    [String]$mes = (get-date).AddDays($dias).Month
    [String]$ano = (get-date).AddDays($dias).Year
    [String]$dia = (get-date).AddDays($dias).Day
    [String]$ruta = $ano+"\"+$mes+"\"+$dia

    mkdir $ruta -Force

    foreach($horas in 0..23)
    {   
        New-Item -Name $horas -Path $ruta -ItemType Directory -Force
        [String]$procesos = (gps).name
        [String]$ruta1= ($ruta+"\"+$horas)
        New-Item -Name procesos.txt -Path $ruta1 -ItemType File -value $procesos -Force
    }
}
```
