# Administración y aseguramiento de la información:
- Sistemas de archivos:
  - Propietarios y libres.
  - Rutas y nombres de archivos. Estructura jerárquica.
- Gestión de sistemas de archivos mediante comandos y entornos gráficos.
- Gestión de enlaces.
- Estructura de directorios de sistemas operativos libres y propietarios.
- Búsqueda de información del sistema mediante comandos y herramientas gráficas.

---------------

# Repaso
## Built-In SSH support in Windows 10
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/built-in-ssh-support-in-windows-10
## Installing Google Chrome via PowerShell
* https://community.idera.com/database-tools/powershell/powertips/b/tips/posts/installing-google-chrome-via-powershell

---------------

# Introducción a sistema de archivos (archivos)
* https://www.jesusninoc.com/07/04/4-gestion-del-sistema-de-archivos-en-powershell/#Archivos

---------------

# Ejemplos

## Listar ficheros (partir por -, ejemplo de ficheros 123-10.txt)

```PowerShell
ls '*.txt'
```
```PowerShell
foreach($ficheros in (ls '*.txt').Name)
{
$ficheros.split('-')
}
```
```PowerShell
foreach($ficheros in (ls '*.txt').Name)
{
$ficheros.split('-')[1]
}
```
```PowerShell
foreach($ficheros in (ls '*.txt').Name)
{
$ficheros.split('-')[1].Replace('.txt','')
}
```

---------------

# Ejercicios

## Crear dos ficheros TXT, convertirlos a PDF y juntarlos con Poppler
```PowerShell
# Instalar en Ubuntu Poppler 
# $ sudo apt-get install poppler-utils

"pagina 1" | Out-File 01-22-10-2019.txt
"pagina 2" | Out-File 02-22-10-2019.txt

gc .\01-22-10-2019.txt | Out-Printer "Microsoft Print to PDF"
gc .\02-22-10-2019.txt | Out-Printer "Microsoft Print to PDF"

ls *.pdf

wsl ls
wsl pdfunite 01-22-10-2019-P.pdf 02-22-10-2019-P.pdf out.pdf
.\out.pdf

```

## Crear cinco directorios y dentro de cada directorio crear 10 ficheros
```PowerShell
foreach($directorio in 1..5)
{
    New-Item -Name $directorio -WhatIf -ItemType Directory
    foreach($fichero in 1..10)
    {
        New-Item -Path $directorio -Name $fichero -WhatIf -ItemType File 
    }
}
```

## Crear una estructura de directorios
```PowerShell
notepad amigos.txt

mkdir (gc .\amigos.txt)

foreach($elementitos in gc .\amigos.txt)
{
    Set-Location $elementitos
    mkdir "iso","fol","redes"
    cd ..
}
```

## Crear una estructura de directorios
```PowerShell
## 1 -> ISO   -> 1EVA
## 1 -> ISO   -> 2EVA
## 1 -> ISO   -> 3EVA
## 1 -> REDES -> 1EVA
## 1 -> REDES -> 2EVA
## 2 -> ISO   -> 1EVA
## 2 -> ISO   -> 2EVA
## 5

foreach($alumnos in 1..5)
{
    New-Item -Name $alumnos -ItemType Directory -Force
    foreach($materias in "iso","redes","fol")
    {
        New-Item -Name $materias -ItemType Directory -Path $alumnos -Force
        foreach($evaluacion in "1eva","2eva","3eva")
        {
            $ruta = [String]$alumnos + "\" + $materias 
            $ruta 
            New-Item -Name $evaluacion -ItemType Directory -Path $ruta -Force
            Write-Host $alumnos $materias $evaluacion
        }   
    }
}
```

## Crear una estructura de directorios (pero solo los números pares)
```PowerShell
## 2 -> ISO   -> 1EVA
## 2 -> ISO   -> 2EVA

foreach($alumnos in 1..5)
{
    New-Item -Name ($alumnos*2) -ItemType Directory -Force
    foreach($materias in "iso","redes","fol")
    {
        New-Item -Name $materias -ItemType Directory -Path ($alumnos*2) -Force
        foreach($evaluacion in "1eva","2eva","3eva")
        {
            $ruta = [String]($alumnos*2) + "\" + $materias 
            $ruta 
            New-Item -Name $evaluacion -ItemType Directory -Path $ruta -Force
            Write-Host ($alumnos*2) $materias $evaluacion
        }   
    }
}
```

## Crear una estructura de directorios (pero solo los números impares)
```PowerShell
## 1 -> ISO   -> 1EVA
## 3 -> ISO   -> 2EVA

for($alumnos=1;$alumnos -lt 5;$alumnos=$alumnos+2)
{
    New-Item -Name $alumnos -ItemType Directory -Force
    foreach($materias in "iso","redes","fol")
    {
        New-Item -Name $materias -ItemType Directory -Path $alumnos -Force
        foreach($evaluacion in "1eva","2eva","3eva")
        {
            $ruta = [String]$alumnos + "\" + $materias 
            $ruta 
            New-Item -Name $evaluacion -ItemType Directory -Path $ruta -Force
            Write-Host $alumnos $materias $evaluacion
        }   
    }
}
```

## Leer operaciones de un fichero y realizarlas

### Estructura del fichero asignaturas.txt (0 crear fichero, 1 crear directorio)
```
iso,0
aso,1
```

### Leer del fichero que tiene las asignaturas
```PowerShell
$fichero=get-content asignaturas.txt
$fichero | % {
$_
}
```

### Leer del fichero que tiene las asignaturas y obtener solo la operación que hay que realizar
```PowerShell
$fichero=get-content asignaturas.txt
$fichero | % {
$_.split(',')[1]
}
```

### Leer el fichero y detectar la operación a realizar utilizando el switch
```PowerShell
$fichero = Get-Content asignaturas.txt
$fichero | % {
    $operacion = $_.split(",")
    switch($operacion[1]){
        '0'{
            echo "crear fichero"
            New-Item -Name $operacion[0] -ItemType File -Force
            break
        }
        '1'{
            echo "crear directorio"
            mkdir $operacion[0] -Force
            break
        }
    }
}
```

---------------

#  IF en PowerShell
* https://www.jesusninoc.com/07/02/2-programacion-en-powershell/#Sentencias_condicionales

# Ejemplos con IF

## Pedir al usuario un nombre de usuario y un password
```PowerShell
$usuario=Read-Host "Introduzca nombre de usuario"
$pass=Read-Host "Introduzca nombre de usuario"
$usuario
$pass
```

## Pedir al usuario un nombre de usuario y un password y comprobar si es "juan"

```PowerShell
$usuario=Read-Host "Introduzca nombre de usuario"
$pass=Read-Host "Introduzca nombre de usuario"
$usuario
$pass
if($usuario -eq "juan")
{

}
else
{

}
```

## Introducir un nombre y pass y ver si es correcto

```PowerShell
$usuario=Read-Host "Introduzca nombre de usuario"
$pass=Read-Host "Introduzca nombre de usuario"
$usuario
$pass
if($usuario -eq "hola")
{
"el uusario es hola"
}
else
{
"el usuario no es hola"
}
```

## Introducir pass y ver si es correcto
```PowerShell
$user=Read-Host
$pass=Read-Host
if($user -eq "pepito" -and $pass -eq "secreto")
{
Write-Host $user
}
```

---------------

# Switch en PowerShell
* https://www.jesusninoc.com/2016/08/09/sentencia-condicional-switch/

# Ejemplos
## Ejemplos sobre operaciones con switch
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
echo Suma
break
}
}
```
## Pedir una operación y si es "suma" realizar una suma
```PowerShell
$a=Read-Host "Introduzca operación"
switch($a){
'+'{
suma
break
}
}

function suma()
{
2+3
}
```
