# Instalación de software libre y propietario

- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
- Ficheros necesarios para el arranque de los principales sistemas operativos.
- Registros (logs) del sistema.
  - Formato de los registros: fuente/origen, prioridades (informativos, advertencias, errores, etc.)
  - Herramientas para su monitorización en sistemas libres y propietarios.
  - Gestión: Aplicar filtros, asociar tareas en respuesta a ciertos eventos, etc.
- Actualización y mantenimiento de controladores de dispositivos.
  - Automatizar la actualización de controladores.
  - Volver a una versión anterior de un controlador.
  - Actualización manual de los controladores.
  
------------------

# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/
### Variables 4: almacenar en fichero
https://www.jesusninoc.com/2014/10/22/variables-4-almacenar-en-fichero/
### Variables 5: leer de un fichero
https://www.jesusninoc.com/2014/10/21/variables-5-leer-de-un-fichero/
### Variables 6: etiquetas HTML
https://www.jesusninoc.com/2014/10/20/variables-6-etiquetas-html/
### Variables 7: ordenar y eliminar elementos duplicados
https://www.jesusninoc.com/2014/10/19/variables-7-ordenar-y-eliminar-elementos-duplicados-2/
### Variables 8: eliminar caracteres en blanco
https://www.jesusninoc.com/2014/10/18/variables-8-eliminar-caracteres-en-blanco/

## Bucle
Example C for loop syntax
```Bash
for (( i=1; i <= 10; i++ ))
do
echo "Number $i"
done
```

## Ejercicio: ejecutar el comando almacenado en un fichero
* https://github.com/jesusninoc/Bash/blob/master/Introduccion/EjemplosIntroducci%C3%B3n.sh

```Bash
echo "ps" > fichero
echo "ls" >> fichero
`cat fichero | head -n 1`
```

```Bash
echo "ps" > fichero
echo "ls" >> fichero

while read linea
do
echo $linea
`echo $linea` >> resultado
done < fichero

cat resultado
```

------------------

# PowerShell
## Repaso bucle ForEach
* https://github.com/jesusninoc/PowerShell/blob/master/Bucles/RepasoBucleForEach.ps1

------------------

# Linux + PowerShell

## Configurar IP en Linux
https://www.tecmint.com/ifconfig-command-examples/
```Shell
sudo ifconfig eth0 172.16.25.125 netmask 255.255.255.224
```

## Instalar y ejecutar SSH para PowerShell
```PowerShell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned
Install-Module -Name Posh-SSH -RequiredVersion 2.0.2
New-SSHSession -ComputerName 10.20.104.35 -Credential (Get-Credential)

$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

## SSH en Windows 10
* https://www.illuminiastudios.com/dev-diaries/ssh-on-windows-subsystem-for-linux/

------------------

# Examen mes de octubre (obtener información sobre hilos en Linux y PowerShell)

## Linux

### Hilos (ayuda)
```Bash
echo "ps -fL -C @sh" > fichero
echo "ps -fL -C @sh" >> fichero

while read linea
do
echo $linea
`echo $linea | cut -d '@' -f1 ; echo $linea | cut -d '@' -f2` >> resultado
done < fichero

cat resultado
```

### Nombre de proceso por ID (ayuda)
```Bash
echo "323@232@8888" > fichero

while read linea
do
echo $linea
ps -f -p `echo $linea | cut -d '@' -f1` >> resultado
done < fichero

cat resultado
```

### Hilos por nombre de proceso (solución)
```Bash
echo "nano" > fichero
echo "sh" >> fichero

while read linea
do
echo $linea
ps -fL -C `echo $linea | cut -d '@' -f1` >> resultado
done < fichero

cat resultado
```

## PowerShell
### Analizar hilos (solución)
https://www.jesusninoc.com/02/06/analizar-hilos-con-powershell/

### Otra más
```PowerShell
# Listar identificadores de hilos
(Get-Process -name notepad | select threads).threads.id

# Listar información de un hilo en concreto
Get-WmiObject -Class win32_thread -Filter "Handle = 6248" | Out-File

# Sirve para analizar la información de hilos en función del proceso que los crea (Notepad)
(Get-Process -name notepad).id
$var=(Get-Process -name notepad).id
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"

# (Leyenda) Sirve para analizar información de hilos en función de los identificadores de cada hilo del proceso que los crea (Notepad)
$var=(Get-Process -name notepad | select threads).threads.id
$var | %{$_}
Get-WmiObject -Class win32_thread -Filter "ProcessHandle = $var"
$var | %{Get-WmiObject -Class win32_thread -Filter "Handle = $_"}
```

### Otra posible solución
```PowerShell
#Mostrar el proceso que creó el hilo
Get-WmiObject -Class Win32_Thread | %{
    if((Get-Process -Id $_.ProcessHandle).name -eq "notepad")
    {
        write-host $_.ProcessHandle,$_.handle
        Get-Process -Id $_.ProcessHandle | select name,id
    }
}
```

### Solución para entender la solución de Linux
```PowerShell
echo "ps@notepad" > fichero

foreach ($linea in gc fichero)
{
    $ejecutar = $linea.split("@")[0] + " -name " + $linea.split("@")[1]
    $ejecutar | iex
}
```

------------------

# Ejercicios

## Instalar un paquete MSI junto con información sobre la instalación
```PowerShell
cd ~
msiexec /i C:\Windows\Installer\42014f.msi /Liwearucmopvx log.txt
msiexec /i C:\Windows\Installer\42014f.msi /Li logi.txt
Start-Sleep -Seconds 5
msiexec /i C:\Windows\Installer\42014f.msi /Lw logw.txt
```

## Ver el número de serie de un equipo
```PowerShell
(Get-WmiObject Win32_SystemEnclosure).SerialNumber
```

## Ver controladores
```PowerShell 
gwmi Win32_USBControllerDevice |%{[wmi]($_.Dependent)} | Sort Manufacturer,Description,DeviceID | Ft -GroupBy Manufacturer Description,Service,DeviceID
 
Get-PnpDevice
```
  
## Ver actualizaciones
```PowerShell
$Sesion = New-Object -ComObject Microsoft.Update.Session
$actualizacion = $Sesion.CreateUpdateSearcher().Search("IsInstalled=1").Updates
$actualizacion | Select-Object Title
```
  
## Obtener información sobre las actualizaciones
```PowerShell
#Seleccionar los identificadores de las actualizaciones de seguridad (HotFixID)
foreach($kb in (Get-HotFix | Select-Object HotFixID))
{
[String]$texto=''

#Componer URL con el valor HotFixID
$url='https://www.bing.com/search?q='+$kb.hotfixid
#Hacer petición al buscador Bing para analizar la información sobre la actualización de seguridad
$result=Invoke-WebRequest $url

#Analizar los datos devueltos por el buscador
foreach($linea in ($result.AllElements | Where class -eq 'b_caption').outerText)
{
#Marcar en los resultados obtenidos los identificadores de las actualizaciones de seguridad (HotFixID)
#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
$linea.Split(' ') | % {
if($_ | Select-String $kb.hotfixid)
{
Write-Host $_ ' ' -BackgroundColor Cyan -ForegroundColor Blue -NoNewline
}
else
{
Write-Host $_ ' ' -NoNewline
}
}
Write-Host ' '
}
#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
}
```
