# Instalación de software libre y propietario

- Instalación/desinstalación de aplicaciones. Requisitos hardware y software, versiones y licencias.
- Actualización de sistemas operativos y aplicaciones.
  - Actualizar a una versión superior (update).
  - Cambiar a una versión inferior (downgrade).
  - Instalación de parches: de seguridad, funcionales, opcionales, etc.
  - Automatizar las actualizaciones. Configurar la fuente de las actualizaciones.
  
----------------

# PowerShell

## Bucle foreach PowerShell
https://www.jesusninoc.com/2015/09/29/bucles/

## Operadores de comparación en PowerShell
If you are used to operators such as > or < or =, you have to do some rethinking. As with batch scripts, PowerShell uses abbreviations of the corresponding English words.

|Op|Description
|---|---
|eq|Equal
|ne|Not equal
|lt|Less than
|le|Less than or equal
|gt|Greater than
|ge|Greater than or equal


## SSH sobre PowerShell
```PowerShell
New-SSHSession -ComputerName 192.168.1.162 -Credential (Get-Credential)
$resultado=Invoke-SSHCommand -Index 0 'ps -aux'
$resultado.Output
```

# Linux

## Variables
https://www.jesusninoc.com/2015/01/04/curso-de-bash-scripting-con-ejemplos/

### Variables 1: enteros, caracteres y cadenas de caracteres
https://www.jesusninoc.com/2014/10/28/variables-1-enteros-caracteres-y-cadenas-de-caracteres/
### Variables 2: concatenar, extraer, medir cadenas
https://www.jesusninoc.com/2014/10/24/variables-2-concatenar-extraer-elementos-y-medir-la-longitud-de-un-array/
### Variables 3: almacenar la ejecución de un comando
https://www.jesusninoc.com/2014/10/23/variables-3-almacenar-la-ejecucion-de-un-comando/

## Bucle en Linux
Example C for loop syntax
```Bash
for (( i=1; i <= 10; i++ ))
do
echo "Number $i"
done
```

# Ejecutar comandos en PowerShell y Bash
## Bash
```Bash
echo ps
echo 'ps'
echo `ps`
```
## PowerShell
```PowerShell
$hola="Get-Process -Name notepad"
Invoke-Expression ($hola)
```

## Mezcla de comandos entre PowerShell y Bash
```PowerShell
for($i=1;$i -le 5;$i=$i+1)
{
    $multi=($i*100) 
    $nombre="fichero$i"
    $resultado=Invoke-SSHCommand -Index 0 ('echo' + $multi + ' >' + $nombre)
    $resultado.Output 
}
```

----------------

# Instalar con PowerShell
https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/
```PowerShell
Install-Package -provider chocolatey -name zoomit
```

# Actualizar en Windows
* https://docs.microsoft.com/en-us/windows/desktop/msi/command-line-options
* https://www.jesusninoc.com/07/05/5-gestion-del-software-en-powershell/

# Instalar en Bash
* https://help.ubuntu.com/community/AptGet/Howto

# Actualizar en Linux
### This command upgrades all installed packages. This is the equivalent of "Mark all upgrades" in Synaptic.
```Bash
apt-get update & apt-get upgrade
```
### Setting up apt-get to use a http-proxy
```Bash
export http_proxy=http://yourproxyaddress:proxyport
```
