# Instalación de software libre y propietario

- Gestión de varios sistemas operativos en un ordenador.
  - Requisitos previos. Administración del espacio del disco. Particionado y redimensionado.
  - Problemas con el registro maestro de arranque (MBR). Elegir un gestor de arranque compatible con todos los sistemas operativos a instalar.
  - Preparar las particiones de los S.O. para permitir su arranque.
  - Analizar el orden en la instalación de los sistemas operativos.
- Gestores de arranque.
  - Código de arranque maestro (Master Boot Code).
  - Formatos tabla de particiones. Master Boot Record (MBR) y Guid Partition Table (GPT).
  - Configuración de los gestores de arranque de los sistemas operativos libres y propietarios.
  - Reparación del gestor de arranque.
  - Sustitución del gestor de arranque estándar por otro más completo.

---------------------

# Ejercicio repaso semana pasada
## Almacenar en un fichero información sobre la CPU mediante WSL desde PowerShell
```PowerShell
bash -c lscpu | Select-String "Architecture:","Model name:" | Out-File bonito.txt
[String]$var = bash -c lscpu | Select-String "Model name:"
$var.split("@")[1] | Out-File bonito.txt -Append
notepad .\bonito.txt
```

# Repaso examen
- Listar los procesos que sean Chrome
- Seleccionar los cinco primero procesos que sean Chrome ordenados por CPU
- Guardar en un fichero los cinco primeros procesos que sean Chrome ordenados por CPU
- Realizar el apartado anterior obteniendo los datos de ficheros

---------------------

# Arranque
- BIOS
- POST
- Arranque (dual, BCD, BCDEdit, etc.)
- Arranque de procesos

## Arranque en Linux
### Proceso de arranque en Linux
https://github.com/jesusninoc/ClasesISO/blob/master/2018-01-23.md

## Arranque en Windows
### Master Boot Record
https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-2000-server/cc976786(v=technet.10)
### Proteger el proceso de arranque de Windows 10
https://docs.microsoft.com/es-es/windows/security/hardware-protection/secure-the-windows-10-boot-process
### Procesos de credenciales de autenticación de Windows
https://docs.microsoft.com/es-es/windows-server/security/windows-authentication/credentials-processes-in-windows-authentication

---------------------

# Sistema de archivos

## Ejemplos básicos sobre el sistema de archivos en PowerShell

```PowerShell
####################
# Ayuda
# Crear un fichero llamado juan que tenga el contenido del fichero la palabra hola, después mostrar el contenido
New-Item juan -ItemType File -Value "hola" -Force
Get-ChildItem juan
Get-Content juan
# Crear un directorio llamado juan2 y meterse dentro del directorio
New-Item juan2 -ItemType Directory
Set-Location juan2
####################
# Solución fácil
# Tenemos cinco usuarios
# Crear para cada uno de ellos 5 directorios
New-Item juan -ItemType Directory
New-Item juan3 -ItemType Directory
New-Item juan4 -ItemType Directory
New-Item juan6 -ItemType Directory
New-Item juan7 -ItemType Directory
# Para cada una de las carpetas que he creado meterme dentro y crear un fichero con el nombre del usuario
Set-Location juan4
New-Item juan3.txt
Set-Location ../
####################
# Solución complicada
# Tenemos cinco usuarios
# Crear para cada uno de ellos 5 directorios
# Para cada una de las carpetas que he creado meterme dentro y crear un fichero con el nombre del usuario
 
New-Item pruebas -ItemType Directory -Force
Set-Location pruebas
New-Item juan,juan3,juan7 -ItemType Directory -Force
foreach($nombre in (Get-ChildItem | select Name).name)
{
    Set-Location $nombre
    New-Item $nombre
    Set-Location ../
}
####################
# Tenemos todos los procesos del sistema operativo
# Crear para cada uno de ellos una carpeta
# Para cada una de las carpetas que se han creado meter un fichero con información del prceso
 
New-Item pruebas -ItemType Directory -Force
Set-Location pruebas
New-Item (get-Process | select name).name -ItemType Directory -Force
foreach($nombre in (Get-ChildItem | select Name).name)
{
    Set-Location $nombre
    New-Item $nombre -Value ([String](Get-Process -Name $nombre)) -Force
    Set-Location ../
}
```
